/*
 * Decompiled with CFR 0.152.
 */
package com.betterinvisibility;

import com.betterinvisibility.BetterInvisibility;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.event.config.ModConfigEvent;
import net.neoforged.neoforge.common.ModConfigSpec;
import org.apache.commons.lang3.tuple.Pair;

@EventBusSubscriber(modid="betterinvisibility", bus=EventBusSubscriber.Bus.MOD)
public class BetterInvisibilityConfig {
    public static boolean showArmorWeapons;
    public static boolean showParticles;
    public static boolean invisibleToMobs;
    public static int invisibilityRadius;
    public static int proximityDetectionDistance;
    public static boolean sneakWhenClose;
    public static boolean discoveryRemovesInvisibility;
    public static boolean attackRemovesInvisibility;
    public static boolean removeParticlesFromMobs;
    public static boolean blindWhenInvisible;
    public static boolean soundsOn;
    public static boolean showMobArmorWeapons;
    public static final ModConfigSpec commonSpec;
    public static final Common COMMON;

    @SubscribeEvent
    public static void onModConfigEvent(ModConfigEvent configEvent) {
        if (configEvent.getConfig().getSpec() == commonSpec) {
            BetterInvisibilityConfig.bakeCommonConfig();
        }
    }

    public static void bakeCommonConfig() {
        showArmorWeapons = (Boolean)BetterInvisibilityConfig.COMMON.showArmorWeapons.get();
        showParticles = (Boolean)BetterInvisibilityConfig.COMMON.showParticles.get();
        invisibleToMobs = (Boolean)BetterInvisibilityConfig.COMMON.invisibleToMobs.get();
        invisibilityRadius = (Integer)BetterInvisibilityConfig.COMMON.invisibilityRadius.get();
        proximityDetectionDistance = (Integer)BetterInvisibilityConfig.COMMON.proximityDetectionDistance.get();
        sneakWhenClose = (Boolean)BetterInvisibilityConfig.COMMON.sneakWhenClose.get();
        discoveryRemovesInvisibility = (Boolean)BetterInvisibilityConfig.COMMON.discoveryRemovesInvisibility.get();
        attackRemovesInvisibility = (Boolean)BetterInvisibilityConfig.COMMON.attackRemovesInvisibility.get();
        removeParticlesFromMobs = (Boolean)BetterInvisibilityConfig.COMMON.removeParticlesFromMobs.get();
        blindWhenInvisible = (Boolean)BetterInvisibilityConfig.COMMON.blindWhenInvisible.get();
        showMobArmorWeapons = (Boolean)BetterInvisibilityConfig.COMMON.showMobArmorWeapons.get();
        soundsOn = (Boolean)BetterInvisibilityConfig.COMMON.soundsOn.get();
    }

    @SubscribeEvent
    public static void onLoad(ModConfigEvent.Loading configEvent) {
        BetterInvisibility.LOGGER.debug("Loaded Better Invisibility config file.", (Object)configEvent.getConfig().getFileName());
    }

    @SubscribeEvent
    public static void onFileChange(ModConfigEvent.Reloading configEvent) {
        BetterInvisibility.LOGGER.debug("Better Invisibility config was just changed on the file system.");
    }

    static {
        Pair specPair = new ModConfigSpec.Builder().configure(Common::new);
        commonSpec = (ModConfigSpec)specPair.getRight();
        COMMON = (Common)specPair.getLeft();
    }

    public static class Common {
        public final ModConfigSpec.BooleanValue showArmorWeapons;
        public final ModConfigSpec.BooleanValue showParticles;
        public final ModConfigSpec.BooleanValue invisibleToMobs;
        public final ModConfigSpec.IntValue invisibilityRadius;
        public final ModConfigSpec.IntValue proximityDetectionDistance;
        public final ModConfigSpec.BooleanValue sneakWhenClose;
        public final ModConfigSpec.BooleanValue discoveryRemovesInvisibility;
        public final ModConfigSpec.BooleanValue attackRemovesInvisibility;
        public final ModConfigSpec.BooleanValue removeParticlesFromMobs;
        public final ModConfigSpec.BooleanValue blindWhenInvisible;
        public final ModConfigSpec.BooleanValue soundsOn;
        public final ModConfigSpec.BooleanValue showMobArmorWeapons;

        Common(ModConfigSpec.Builder builder) {
            builder.comment("Better Invisibility Config Settings").push("common");
            this.showArmorWeapons = builder.comment("Show armor and weapons when invisible (default:false)").define("showArmorWeapons", false);
            this.showParticles = builder.comment("Show invisiblity potion particles (default:false)").define("showParticles", false);
            this.invisibleToMobs = builder.comment("Invisible to Mob AI when invisible (default:true)").define("invisibleToMobs", true);
            this.invisibilityRadius = builder.comment("Radius of Invisibility Effect (default: 30)").defineInRange("invisibilityRadius", 30, 1, 100);
            this.proximityDetectionDistance = builder.comment("Invisiblity detection distance (default: 3)").defineInRange("proximityDetectionDistance", 3, 1, 10);
            this.sneakWhenClose = builder.comment("Can sneak by mobs when inside detection distance (default:true)").define("sneakWhenClose", true);
            this.discoveryRemovesInvisibility = builder.comment("Invisibility effect removed when discovered by Mobs (default:true)").define("discoveryRemovesInvisibility", true);
            this.attackRemovesInvisibility = builder.comment("Invisibility effect removed if Player attacks (default:true)").define("attackRemovesInvisibility", true);
            this.removeParticlesFromMobs = builder.comment("Remove invisibility particles from other mobs (default:true)").define("removeParticlesFromMobs", false);
            this.showMobArmorWeapons = builder.comment("Show armor and weapons when invisible (default:false)").define("showMobArmorWeapons", false);
            this.blindWhenInvisible = builder.comment("Player loses sight when invisible (default:false)").define("blindWhenInvisible", false);
            this.soundsOn = builder.comment("Mod sounds on (default:true)").define("soundsOn", true);
            builder.pop();
        }
    }
}

