/*
 * Decompiled with CFR 0.152.
 */
package com.betterinvisibility;

import com.betterinvisibility.BetterInvisibilityConfig;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.level.Level;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.living.LivingDamageEvent;

@EventBusSubscriber(modid="betterinvisibility", bus=EventBusSubscriber.Bus.GAME)
public class OnPlayerAttack {
    @SubscribeEvent
    public static void notifyAttack(LivingDamageEvent.Pre event) {
        Player entityplayer;
        Level world;
        Projectile projectile;
        if (event.getSource().getDirectEntity() instanceof Player && BetterInvisibilityConfig.attackRemovesInvisibility) {
            Player entityplayer2 = (Player)event.getSource().getDirectEntity();
            Level world2 = entityplayer2.getCommandSenderWorld();
            if (!world2.isClientSide() && entityplayer2.hasEffect(MobEffects.INVISIBILITY)) {
                entityplayer2.removeEffect(MobEffects.INVISIBILITY);
                LivingEntity livingEntity = event.getEntity();
                if (livingEntity instanceof Monster) {
                    Monster monster = (Monster)livingEntity;
                    monster.setTarget((LivingEntity)entityplayer2);
                    monster.setAggressive(true);
                    monster.targetSelector.tickRunningGoals(true);
                }
                if (BetterInvisibilityConfig.soundsOn) {
                    world2.playSound(null, entityplayer2.position().x, entityplayer2.position().y, entityplayer2.position().z, SoundEvents.ALLAY_AMBIENT_WITHOUT_ITEM, SoundSource.PLAYERS, 0.7f, 1.4f);
                }
            }
        } else if (event.getSource().getDirectEntity() instanceof Projectile && BetterInvisibilityConfig.attackRemovesInvisibility && (projectile = (Projectile)event.getSource().getDirectEntity()).getOwner() instanceof Player && !(world = (entityplayer = (Player)projectile.getOwner()).getCommandSenderWorld()).isClientSide() && entityplayer.hasEffect(MobEffects.INVISIBILITY)) {
            entityplayer.removeEffect(MobEffects.INVISIBILITY);
            LivingEntity livingEntity = event.getEntity();
            if (livingEntity instanceof Monster) {
                Monster monster = (Monster)livingEntity;
                monster.setTarget((LivingEntity)entityplayer);
                monster.setAggressive(true);
                monster.targetSelector.tickRunningGoals(true);
            }
            if (BetterInvisibilityConfig.soundsOn) {
                world.playSound(null, entityplayer.position().x, entityplayer.position().y, entityplayer.position().z, SoundEvents.ALLAY_AMBIENT_WITHOUT_ITEM, SoundSource.PLAYERS, 0.7f, 1.4f);
            }
        }
    }
}

