/*
 * Decompiled with CFR 0.152.
 */
package com.betterinvisibility;

import com.betterinvisibility.BetterInvisibilityConfig;
import java.util.List;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.FlyingMob;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class PlayerTickHandler {
    @SubscribeEvent
    public void onLivingUpdateEvent(LivingEvent.LivingTickEvent event) {
        Mob entity;
        if (event.getEntity() instanceof Player) {
            Player entityplayer = (Player)event.getEntity();
            Level world = event.getEntity().getCommandSenderWorld();
            if (entityplayer.hasEffect(MobEffects.INVISIBILITY) && !BetterInvisibilityConfig.showParticles) {
                MobEffectInstance invisiCheck = entityplayer.getEffect(MobEffects.INVISIBILITY);
                if ((invisiCheck.getDuration() > 2 || invisiCheck.getDuration() == -1) && invisiCheck.isVisible()) {
                    entityplayer.addEffect(new MobEffectInstance(MobEffects.INVISIBILITY, 2, 0, false, false));
                } else if (invisiCheck.getDuration() == 0) {
                    entityplayer.removeEffect(MobEffects.INVISIBILITY);
                }
                if (BetterInvisibilityConfig.blindWhenInvisible) {
                    entityplayer.addEffect(new MobEffectInstance(MobEffects.BLINDNESS, 25, 0, false, false));
                }
            }
            if (entityplayer.hasEffect(MobEffects.INVISIBILITY) && !entityplayer.isCreative()) {
                LivingEntity entity2;
                int k;
                List<LivingEntity> entities = PlayerTickHandler.getEntitiesInRange(LivingEntity.class, BetterInvisibilityConfig.invisibilityRadius, event.getEntity().getCommandSenderWorld(), (Entity)entityplayer);
                int esize2 = entities.size();
                for (k = 0; k <= esize2 - 1; ++k) {
                    entity2 = entities.get(k);
                    if (entity2.distanceToSqr((Entity)entityplayer) >= (double)BetterInvisibilityConfig.proximityDetectionDistance) {
                        entity2.setLastHurtByPlayer(null);
                        if (!(entity2 instanceof Monster)) continue;
                        Monster monster = (Monster)entity2;
                        monster.setTarget(null);
                        monster.goalSelector.getAvailableGoals().clear();
                        continue;
                    }
                    if (!(entity2.distanceToSqr((Entity)entityplayer) < (double)BetterInvisibilityConfig.proximityDetectionDistance) || !(entity2.distanceToSqr((Entity)entityplayer) > 0.0) || !BetterInvisibilityConfig.discoveryRemovesInvisibility || entityplayer.isCrouching()) continue;
                    entityplayer.removeEffect(MobEffects.INVISIBILITY);
                    if (!BetterInvisibilityConfig.soundsOn) continue;
                    world.playSound(null, entityplayer.position().x, entityplayer.position().y, entityplayer.position().z, SoundEvents.ALLAY_AMBIENT_WITHOUT_ITEM, SoundSource.PLAYERS, 0.7f, 1.4f);
                }
                entities = PlayerTickHandler.getEntitiesInRange(FlyingMob.class, BetterInvisibilityConfig.invisibilityRadius * 2, event.getEntity().getCommandSenderWorld(), (Entity)entityplayer);
                esize2 = entities.size();
                for (k = 0; k <= esize2 - 1; ++k) {
                    entity2 = (FlyingMob)entities.get(k);
                    if (entity2.getLastHurtByMob() == entityplayer && entity2.distanceToSqr((Entity)entityplayer) >= (double)BetterInvisibilityConfig.proximityDetectionDistance) {
                        entity2.setLastHurtByPlayer(null);
                        entity2.setTarget(null);
                        entity2.goalSelector.getAvailableGoals().clear();
                        continue;
                    }
                    if (!(entity2.distanceToSqr((Entity)entityplayer) < (double)BetterInvisibilityConfig.proximityDetectionDistance) || !(entity2.distanceToSqr((Entity)entityplayer) > 0.0) || !BetterInvisibilityConfig.discoveryRemovesInvisibility || entityplayer.isCrouching()) continue;
                    entityplayer.removeEffect(MobEffects.INVISIBILITY);
                    if (!BetterInvisibilityConfig.soundsOn) continue;
                    world.playSound(null, entityplayer.position().x, entityplayer.position().y, entityplayer.position().z, SoundEvents.ALLAY_AMBIENT_WITHOUT_ITEM, SoundSource.PLAYERS, 0.7f, 1.4f);
                }
            }
        } else if (event.getEntity() instanceof LivingEntity) {
            LivingEntity entity3 = event.getEntity();
            if (entity3.hasEffect(MobEffects.INVISIBILITY)) {
                MobEffectInstance invisiCheck = entity3.getEffect(MobEffects.INVISIBILITY);
                if (BetterInvisibilityConfig.removeParticlesFromMobs && (invisiCheck.getDuration() > 2 || invisiCheck.getDuration() == -1) && invisiCheck.isVisible()) {
                    entity3.addEffect(new MobEffectInstance(MobEffects.INVISIBILITY, 2, 0, false, false));
                }
            }
        } else if (event.getEntity() instanceof Mob && (entity = (Mob)event.getEntity()).hasEffect(MobEffects.INVISIBILITY)) {
            MobEffectInstance invisiCheck = entity.getEffect(MobEffects.INVISIBILITY);
            if (BetterInvisibilityConfig.removeParticlesFromMobs && (invisiCheck.getDuration() > 2 || invisiCheck.getDuration() == -1)) {
                entity.addEffect(new MobEffectInstance(MobEffects.INVISIBILITY, 2, 0, false, false));
            }
        }
    }

    public static <T extends LivingEntity> List<T> getEntitiesInRange(Class<? extends T> filterEntity, double range, Level world, Entity theEntity) {
        return world.getEntitiesOfClass(filterEntity, new AABB(theEntity.position().x - range, theEntity.position().y - range, theEntity.position().z - range, theEntity.position().x + range, theEntity.position().y + range, theEntity.position().z + range));
    }
}

