/*
 * Decompiled with CFR 0.152.
 */
package dev.blackdev.inventorylink;

import dev.blackdev.inventorylink.AdminCommand;
import dev.blackdev.inventorylink.InventorySyncListener;
import dev.blackdev.inventorylink.LinkCommand;
import dev.blackdev.inventorylink.LinkManager;
import java.io.File;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.TabCompleter;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class InventoryLinkPlugin
extends JavaPlugin {
    private LinkManager linkManager;
    private InventorySyncListener syncListener;

    public void onEnable() {
        this.saveDefaultConfig();
        this.linkManager = new LinkManager(this);
        this.syncListener = new InventorySyncListener(this, this.linkManager);
        Bukkit.getPluginManager().registerEvents((Listener)this.syncListener, (Plugin)this);
        LinkCommand linkCommand = new LinkCommand(this, this.linkManager);
        this.getCommand("link").setExecutor((CommandExecutor)linkCommand);
        this.getCommand("link").setTabCompleter((TabCompleter)linkCommand);
        AdminCommand adminCommand = new AdminCommand(this);
        this.getCommand("inventorylink").setExecutor((CommandExecutor)adminCommand);
        this.getLogger().info("InventoryLink enabled.");
    }

    public void onDisable() {
        this.linkManager.flushAll();
        this.getLogger().info("InventoryLink disabled.");
    }

    public boolean isLiveSync() {
        return this.getConfig().getBoolean("live-sync", true);
    }

    public long getDebounceMs() {
        return this.getConfig().getLong("sync-debounce-ms", 200L);
    }

    public String getKickMessage() {
        return this.getConfig().getString("kick-message", "&cYour linked partner is already online. Live sync is disabled.");
    }

    public File getPlayerFolder(String name) {
        File dir = new File(this.getDataFolder(), "playerdata" + File.separator + name);
        if (!dir.exists()) {
            dir.mkdirs();
        }
        return dir;
    }
}

