/*
 * Decompiled with CFR 0.152.
 */
package dev.blackdev.inventorylink;

import dev.blackdev.inventorylink.InventoryLinkPlugin;
import dev.blackdev.inventorylink.LinkManager;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.serializer.legacy.LegacyComponentSerializer;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.PlayerDeathEvent;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryDragEvent;
import org.bukkit.event.player.PlayerDropItemEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerPickupItemEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.plugin.Plugin;

public class InventorySyncListener
implements Listener {
    private final InventoryLinkPlugin plugin;
    private final LinkManager linkManager;

    public InventorySyncListener(InventoryLinkPlugin plugin, LinkManager linkManager) {
        this.plugin = plugin;
        this.linkManager = linkManager;
    }

    @EventHandler
    public void onJoin(PlayerJoinEvent e) {
        Player partner;
        String partnerName;
        Player p = e.getPlayer();
        this.linkManager.saveInventorySnapshot(p);
        if (this.plugin.getConfig().getBoolean("clear-on-death", true) && this.linkManager.consumePendingClearOnJoin(p)) {
            this.linkManager.clearAllOf(p);
            this.linkManager.saveInventorySnapshot(p);
            p.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)this.plugin.getConfig().getString("messages.pending-cleared-on-join", "&eYour inventory was cleared due to your partner's recent death.")));
        }
        if ((partnerName = this.linkManager.getPartnerNameOffline(p.getName())) != null && (partner = Bukkit.getPlayerExact((String)partnerName)) != null && partner.isOnline()) {
            if (!this.linkManager.isLinked(p)) {
                this.linkManager.activateLink(p, partner);
            }
            if (!this.plugin.isLiveSync()) {
                Bukkit.getScheduler().runTask((Plugin)this.plugin, () -> p.kick((Component)LegacyComponentSerializer.legacyAmpersand().deserialize(this.plugin.getKickMessage())));
                return;
            }
            this.linkManager.mirrorInventories(partner, p);
        }
    }

    @EventHandler
    public void onQuit(PlayerQuitEvent e) {
        Player p = e.getPlayer();
        this.linkManager.saveInventorySnapshot(p);
        this.linkManager.unlinkAllFor(p);
    }

    @EventHandler
    public void onClick(InventoryClickEvent e) {
        if (!(e.getWhoClicked() instanceof Player)) {
            return;
        }
        Player p = (Player)e.getWhoClicked();
        if (!this.linkManager.isLinked(p)) {
            return;
        }
        Player partner = this.linkManager.getPartner(p);
        if (partner == null || !partner.isOnline()) {
            return;
        }
        if (!this.plugin.isLiveSync()) {
            return;
        }
        Bukkit.getScheduler().runTask((Plugin)this.plugin, () -> this.linkManager.mirrorInventories(p, partner));
    }

    @EventHandler
    public void onDrag(InventoryDragEvent e) {
        if (!(e.getWhoClicked() instanceof Player)) {
            return;
        }
        Player p = (Player)e.getWhoClicked();
        if (!this.linkManager.isLinked(p)) {
            return;
        }
        Player partner = this.linkManager.getPartner(p);
        if (partner == null || !partner.isOnline()) {
            return;
        }
        if (!this.plugin.isLiveSync()) {
            return;
        }
        Bukkit.getScheduler().runTask((Plugin)this.plugin, () -> this.linkManager.mirrorInventories(p, partner));
    }

    @EventHandler
    public void onDrop(PlayerDropItemEvent e) {
        Player p = e.getPlayer();
        if (!this.linkManager.isLinked(p)) {
            return;
        }
        Player partner = this.linkManager.getPartner(p);
        if (partner == null || !partner.isOnline()) {
            return;
        }
        if (!this.plugin.isLiveSync()) {
            return;
        }
        Bukkit.getScheduler().runTask((Plugin)this.plugin, () -> this.linkManager.mirrorInventories(p, partner));
    }

    @EventHandler
    public void onPickup(PlayerPickupItemEvent e) {
        Player p = e.getPlayer();
        if (!this.linkManager.isLinked(p)) {
            return;
        }
        Player partner = this.linkManager.getPartner(p);
        if (partner == null || !partner.isOnline()) {
            return;
        }
        if (!this.plugin.isLiveSync()) {
            return;
        }
        Bukkit.getScheduler().runTask((Plugin)this.plugin, () -> this.linkManager.mirrorInventories(p, partner));
    }

    @EventHandler
    public void onDeath(PlayerDeathEvent e) {
        Player dead = e.getEntity();
        if (!this.plugin.getConfig().getBoolean("clear-on-death", true)) {
            return;
        }
        String partnerName = this.linkManager.getPartnerNameOffline(dead.getName());
        if (partnerName == null) {
            return;
        }
        Player partner = Bukkit.getPlayerExact((String)partnerName);
        if (partner != null && partner.isOnline()) {
            this.linkManager.clearAllOf(partner);
            this.linkManager.saveInventorySnapshot(dead);
            this.linkManager.saveInventorySnapshot(partner);
        } else {
            this.linkManager.markPendingClearOnJoin(partnerName);
        }
    }
}

