/*
 * Decompiled with CFR 0.152.
 */
package dev.blackdev.inventorylink;

import dev.blackdev.inventorylink.InventoryLinkPlugin;
import dev.blackdev.inventorylink.LinkManager;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.entity.Player;

public class LinkCommand
implements CommandExecutor,
TabCompleter {
    private final InventoryLinkPlugin plugin;
    private final LinkManager linkManager;

    public LinkCommand(InventoryLinkPlugin plugin, LinkManager linkManager) {
        this.plugin = plugin;
        this.linkManager = linkManager;
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        String sub;
        if (!(sender instanceof Player)) {
            sender.sendMessage(String.valueOf(ChatColor.RED) + "Players only.");
            return true;
        }
        Player player = (Player)sender;
        if (this.plugin.getConfig().getBoolean("block-command-while-linked", true) && this.linkManager.isLinked(player)) {
            player.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)this.plugin.getConfig().getString("messages.already-linked", "&cYou are already inventory-linked and cannot use /link.")));
            return true;
        }
        if (args.length == 0) {
            player.sendMessage(String.valueOf(ChatColor.YELLOW) + "Usage: /link <player|accept|deny> [player]");
            return true;
        }
        switch (sub = args[0].toLowerCase()) {
            case "accept": {
                if (args.length < 2) {
                    player.sendMessage(String.valueOf(ChatColor.RED) + "Usage: /link accept <player>");
                    return true;
                }
                Player requester = Bukkit.getPlayerExact((String)args[1]);
                if (requester == null) {
                    player.sendMessage(String.valueOf(ChatColor.RED) + "Player must be online to accept.");
                    return true;
                }
                long timeoutMs = this.plugin.getConfig().getLong("request-timeout-seconds", 60L) * 1000L;
                if (this.linkManager.isPendingExpiredFor(player, timeoutMs)) {
                    this.linkManager.clearPending(player);
                    player.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)this.plugin.getConfig().getString("messages.request-expired", "&cThat link request has expired. Please send a new one.")));
                    return true;
                }
                if (!this.linkManager.hasPending(player, requester)) {
                    player.sendMessage(String.valueOf(ChatColor.RED) + "No pending link request from " + requester.getName() + ".");
                    return true;
                }
                if (this.plugin.getConfig().getBoolean("block-command-while-linked", true) && this.linkManager.isLinked(requester)) {
                    player.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)this.plugin.getConfig().getString("messages.target-already-linked", "&cThat player is already inventory-linked and cannot accept new links.")));
                    return true;
                }
                this.linkManager.saveInventorySnapshot(player);
                this.linkManager.saveInventorySnapshot(requester);
                this.linkManager.mirrorInventories(requester, player);
                this.linkManager.clearPending(player);
                this.linkManager.activateLink(player, requester);
                player.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)this.plugin.getConfig().getString("messages.accepted", "&aYou are now linked with %other%. Inventories are now synced.").replace("%other%", requester.getName())));
                requester.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)this.plugin.getConfig().getString("messages.accepted", "&aYou are now linked with %other%. Inventories are now synced.").replace("%other%", player.getName())));
                return true;
            }
            case "deny": {
                if (args.length < 2) {
                    player.sendMessage(String.valueOf(ChatColor.RED) + "Usage: /link deny <player>");
                    return true;
                }
                Player requester = Bukkit.getPlayerExact((String)args[1]);
                if (requester == null) {
                    player.sendMessage(String.valueOf(ChatColor.RED) + "Player is not online.");
                    return true;
                }
                long timeoutMs = this.plugin.getConfig().getLong("request-timeout-seconds", 60L) * 1000L;
                if (this.linkManager.isPendingExpiredFor(player, timeoutMs)) {
                    this.linkManager.clearPending(player);
                    player.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)this.plugin.getConfig().getString("messages.request-expired", "&cThat link request has expired. Please send a new one.")));
                    return true;
                }
                if (!this.linkManager.hasPending(player, requester)) {
                    player.sendMessage(String.valueOf(ChatColor.RED) + "No pending link request from " + requester.getName() + ".");
                    return true;
                }
                this.linkManager.clearPending(player);
                player.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)this.plugin.getConfig().getString("messages.denied", "&eYou denied the link request from %other%.").replace("%other%", requester.getName())));
                requester.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)this.plugin.getConfig().getString("messages.denied", "&eYou denied the link request from %other%.").replace("%other%", player.getName())));
                return true;
            }
        }
        Player target = Bukkit.getPlayerExact((String)args[0]);
        if (target == null) {
            player.sendMessage(String.valueOf(ChatColor.RED) + "Player not found or not online.");
            return true;
        }
        if (target.getUniqueId().equals(player.getUniqueId())) {
            player.sendMessage(String.valueOf(ChatColor.RED) + "You cannot link with yourself.");
            return true;
        }
        if (this.plugin.getConfig().getBoolean("block-command-while-linked", true) && this.linkManager.isLinked(target)) {
            player.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)this.plugin.getConfig().getString("messages.target-already-linked", "&cThat player is already inventory-linked and cannot accept new links.")));
            return true;
        }
        this.linkManager.requestLink(player, target);
        player.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)this.plugin.getConfig().getString("messages.request-sent", "&aLink request sent to %target%.").replace("%target%", target.getName())));
        target.sendMessage(String.valueOf(ChatColor.GOLD) + "----- Inventory Link Request -----");
        target.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)this.plugin.getConfig().getString("messages.request-received", "&e%sender% wants to link inventories with you. &cAccepting will CLEAR your current inventory and cannot be undone. Linking to unknown players is not a good idea.").replace("%sender%", player.getName())));
        target.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)this.plugin.getConfig().getString("messages.accept-hint", "&aType /link accept %sender%  or  /link deny %sender%").replace("%sender%", player.getName())));
        target.sendMessage(String.valueOf(ChatColor.GOLD) + "----------------------------------");
        return true;
    }

    public List<String> onTabComplete(CommandSender sender, Command command, String alias, String[] args) {
        if (args.length == 1) {
            ArrayList<String> base = new ArrayList<String>();
            base.add("accept");
            base.add("deny");
            base.addAll(Bukkit.getOnlinePlayers().stream().map(Player::getName).collect(Collectors.toList()));
            return base;
        }
        if (args.length == 2 && (args[0].equalsIgnoreCase("accept") || args[0].equalsIgnoreCase("deny"))) {
            return Bukkit.getOnlinePlayers().stream().map(Player::getName).collect(Collectors.toList());
        }
        return List.of();
    }
}

