/*
 * Decompiled with CFR 0.152.
 */
package dev.blackdev.inventorylink;

import dev.blackdev.inventorylink.InventoryLinkPlugin;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.PlayerInventory;

public class LinkManager {
    private final InventoryLinkPlugin plugin;
    private final Map<UUID, UUID> pending = new HashMap<UUID, UUID>();
    private final Map<UUID, Long> pendingAt = new HashMap<UUID, Long>();
    private final Map<UUID, UUID> active = new HashMap<UUID, UUID>();
    private final Map<UUID, Long> lastSync = new HashMap<UUID, Long>();

    public LinkManager(InventoryLinkPlugin plugin) {
        this.plugin = plugin;
    }

    public void requestLink(Player requester, Player target) {
        this.pending.put(target.getUniqueId(), requester.getUniqueId());
        this.pendingAt.put(target.getUniqueId(), System.currentTimeMillis());
    }

    public boolean hasPending(Player target, Player requester) {
        return requester != null && requester.isOnline() && requester.getUniqueId().equals(this.pending.get(target.getUniqueId()));
    }

    public boolean isPendingExpiredFor(Player target, long timeoutMs) {
        Long t = this.pendingAt.get(target.getUniqueId());
        if (t == null) {
            return true;
        }
        return System.currentTimeMillis() - t > timeoutMs;
    }

    public void clearPending(Player target) {
        this.pending.remove(target.getUniqueId());
        this.pendingAt.remove(target.getUniqueId());
    }

    public void activateLink(Player a, Player b) {
        this.active.put(a.getUniqueId(), b.getUniqueId());
        this.active.put(b.getUniqueId(), a.getUniqueId());
        this.saveLinkedName(a.getName(), b.getName());
        this.saveLinkedName(b.getName(), a.getName());
    }

    public boolean isLinked(Player p) {
        return this.active.containsKey(p.getUniqueId());
    }

    public Player getPartner(Player p) {
        UUID id = this.active.get(p.getUniqueId());
        return id == null ? null : Bukkit.getPlayer((UUID)id);
    }

    public String getPartnerNameOffline(String playerName) {
        File f = new File(this.getPlayerFolder(playerName), "link.yml");
        if (!f.exists()) {
            return null;
        }
        YamlConfiguration y = YamlConfiguration.loadConfiguration((File)f);
        return y.getString("linked");
    }

    public void unlinkAllFor(Player p) {
        UUID partner = this.active.remove(p.getUniqueId());
        if (partner != null) {
            this.active.remove(partner);
        }
    }

    public void saveLinkedName(String name, String linked) {
        try {
            File f = new File(this.getPlayerFolder(name), "link.yml");
            YamlConfiguration y = f.exists() ? YamlConfiguration.loadConfiguration((File)f) : new YamlConfiguration();
            y.set("linked", (Object)linked);
            y.set("created", (Object)System.currentTimeMillis());
            y.save(f);
        }
        catch (IOException e) {
            this.plugin.getLogger().warning("Failed saving link.yml for " + name + ": " + e.getMessage());
        }
    }

    public void markPendingClearOnJoin(String playerName) {
        try {
            File f = new File(this.getPlayerFolder(playerName), "link.yml");
            YamlConfiguration y = f.exists() ? YamlConfiguration.loadConfiguration((File)f) : new YamlConfiguration();
            y.set("pendingClearOnJoin", (Object)true);
            y.save(f);
        }
        catch (IOException e) {
            this.plugin.getLogger().warning("Failed marking pendingClearOnJoin for " + playerName + ": " + e.getMessage());
        }
    }

    public boolean consumePendingClearOnJoin(Player player) {
        try {
            File f = new File(this.getPlayerFolder(player.getName()), "link.yml");
            if (!f.exists()) {
                return false;
            }
            YamlConfiguration y = YamlConfiguration.loadConfiguration((File)f);
            boolean pending = y.getBoolean("pendingClearOnJoin", false);
            if (pending) {
                y.set("pendingClearOnJoin", (Object)false);
                y.save(f);
                return true;
            }
        }
        catch (IOException e) {
            this.plugin.getLogger().warning("Failed consuming pendingClearOnJoin for " + player.getName() + ": " + e.getMessage());
        }
        return false;
    }

    public void saveInventorySnapshot(Player player) {
        try {
            File f = new File(this.getPlayerFolder(player.getName()), "inventory.yml");
            YamlConfiguration y = new YamlConfiguration();
            PlayerInventory inv = player.getInventory();
            y.set("contents", (Object)inv.getContents());
            y.set("armor", (Object)inv.getArmorContents());
            y.set("extra", (Object)inv.getExtraContents());
            y.set("ender", (Object)player.getEnderChest().getContents());
            y.set("savedAt", (Object)System.currentTimeMillis());
            y.save(f);
        }
        catch (IOException e) {
            this.plugin.getLogger().warning("Failed saving inventory for " + player.getName() + ": " + e.getMessage());
        }
    }

    public void loadInventorySnapshotTo(Player target, String sourcePlayerName) {
        try {
            File f = new File(this.getPlayerFolder(sourcePlayerName), "inventory.yml");
            if (!f.exists()) {
                return;
            }
            YamlConfiguration y = YamlConfiguration.loadConfiguration((File)f);
            List c = (List)y.get("contents");
            List a = (List)y.get("armor");
            List ex = (List)y.get("extra");
            List en = (List)y.get("ender");
            ItemStack[] contents = c == null ? new ItemStack[]{} : c.toArray(new ItemStack[0]);
            ItemStack[] armor = a == null ? new ItemStack[]{} : a.toArray(new ItemStack[0]);
            ItemStack[] extra = ex == null ? new ItemStack[]{} : ex.toArray(new ItemStack[0]);
            ItemStack[] ender = en == null ? new ItemStack[]{} : en.toArray(new ItemStack[0]);
            target.getInventory().setContents(contents);
            target.getInventory().setArmorContents(armor);
            target.getInventory().setExtraContents(extra);
            target.getEnderChest().setContents(ender);
            target.updateInventory();
        }
        catch (Exception e) {
            this.plugin.getLogger().warning("Failed loading inventory for " + sourcePlayerName + " into " + target.getName() + ": " + e.getMessage());
        }
    }

    public void clearAllOf(Player p) {
        try {
            p.getInventory().clear();
            p.getInventory().setArmorContents(new ItemStack[4]);
            p.getInventory().setExtraContents(new ItemStack[0]);
            p.getEnderChest().clear();
            p.updateInventory();
        }
        catch (Exception e) {
            this.plugin.getLogger().warning("Failed to clear inventory for " + p.getName() + ": " + e.getMessage());
        }
    }

    public void mirrorInventories(Player a, Player b) {
        long now = System.currentTimeMillis();
        if (now - this.lastSync.getOrDefault(a.getUniqueId(), 0L) < this.plugin.getDebounceMs()) {
            return;
        }
        if (now - this.lastSync.getOrDefault(b.getUniqueId(), 0L) < this.plugin.getDebounceMs()) {
            return;
        }
        try {
            ItemStack[] contents = a.getInventory().getContents();
            ItemStack[] armor = a.getInventory().getArmorContents();
            ItemStack[] extra = a.getInventory().getExtraContents();
            ItemStack[] ender = a.getEnderChest().getContents();
            b.getInventory().setContents(contents);
            b.getInventory().setArmorContents(armor);
            b.getInventory().setExtraContents(extra);
            b.getEnderChest().setContents(ender);
            b.updateInventory();
            this.saveInventorySnapshot(a);
            this.saveInventorySnapshot(b);
            this.lastSync.put(a.getUniqueId(), now);
            this.lastSync.put(b.getUniqueId(), now);
        }
        catch (Exception e) {
            this.plugin.getLogger().warning("Mirror failed: " + e.getMessage());
        }
    }

    public void flushAll() {
        for (Player p : Bukkit.getOnlinePlayers()) {
            this.saveInventorySnapshot(p);
        }
    }

    private File getPlayerFolder(String name) {
        File dir = new File(this.plugin.getDataFolder(), "playerdata" + File.separator + name);
        if (!dir.exists()) {
            dir.mkdirs();
        }
        return dir;
    }
}

