/*
 * Decompiled with CFR 0.152.
 */
package com.github.Doulor.ElytraFlip;

import com.github.Doulor.ElytraFlip.ElytraFlip;
import com.github.Doulor.ElytraFlip.MessageManager;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;

public class ElytraCommand
implements CommandExecutor {
    private final ElytraFlip plugin;
    private final MessageManager messageManager;
    private static final Material ELYTRA_MATERIAL;
    private static final boolean IS_V1_13;
    private static final boolean IS_V1_14_TO_1_18;
    private static final boolean IS_V1_19_TO_1_20;
    private static final boolean IS_V1_21_PLUS;

    private static int parseVersionNumber(String version) {
        try {
            String[] parts = version.split("\\.");
            int major = Integer.parseInt(parts[0]);
            int minor = Integer.parseInt(parts[1]);
            return major * 100 + minor;
        }
        catch (Exception e) {
            return 121;
        }
    }

    public ElytraCommand(ElytraFlip plugin, MessageManager messageManager) {
        this.plugin = plugin;
        this.messageManager = messageManager;
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (ELYTRA_MATERIAL == null) {
            sender.sendMessage("\u00a7c\u6b64\u670d\u52a1\u5668\u7248\u672c\u4e0d\u652f\u6301\u9798\u7fc5\uff08\u9700\u89811.9\u53ca\u4ee5\u4e0a\u7248\u672c\uff09");
            return true;
        }
        if (args.length > 0 && args[0].equalsIgnoreCase("reload")) {
            this.handleReload(sender);
            return true;
        }
        this.handleElytraToggle(sender);
        return true;
    }

    private void handleReload(CommandSender sender) {
        if (!sender.hasPermission("elytra.reload")) {
            String message = sender instanceof Player ? this.messageManager.getMessage((Player)sender, "no_reload_permission") : this.messageManager.getMessage("no_reload_permission");
            sender.sendMessage(message);
            return;
        }
        try {
            this.messageManager.reloadConfigs();
            String message = sender instanceof Player ? this.messageManager.getMessage((Player)sender, "reload_success") : this.messageManager.getMessage("reload_success");
            sender.sendMessage(message);
        }
        catch (Exception e) {
            sender.sendMessage("\u00a7c\u914d\u7f6e\u91cd\u8f7d\u5931\u8d25\uff1a" + e.getMessage());
            this.plugin.getLogger().warning("\u914d\u7f6e\u91cd\u8f7d\u5931\u8d25\uff1a" + e.getMessage());
        }
    }

    private void handleElytraToggle(CommandSender sender) {
        if (!(sender instanceof Player)) {
            sender.sendMessage(this.messageManager.getMessage("only_player"));
            return;
        }
        Player player = (Player)sender;
        if (!player.hasPermission("elytra.flip")) {
            player.sendMessage(this.messageManager.getMessage(player, "no_permission"));
            return;
        }
        ItemStack chestplate = player.getInventory().getChestplate();
        if (chestplate != null && chestplate.getType() == ELYTRA_MATERIAL) {
            this.removeElytra(player);
            player.sendMessage(this.messageManager.getMessage(player, "unequip_success"));
        } else {
            this.equipElytra(player);
            player.sendMessage(this.messageManager.getMessage(player, "equip_success"));
        }
    }

    private void equipElytra(Player player) {
        ItemStack elytra = new ItemStack(ELYTRA_MATERIAL);
        if (IS_V1_13) {
            elytra.setAmount(1);
            player.getInventory().setChestplate(elytra);
            player.updateInventory();
        } else if (IS_V1_14_TO_1_18) {
            player.getInventory().setChestplate(elytra);
            Bukkit.getScheduler().runTaskLater((Plugin)this.plugin, () -> ((Player)player).updateInventory(), 1L);
        } else if (IS_V1_19_TO_1_20) {
            player.getInventory().setChestplate(elytra);
        } else if (IS_V1_21_PLUS) {
            player.getInventory().setItem(38, elytra);
        }
    }

    private void removeElytra(Player player) {
        if (IS_V1_13) {
            player.getInventory().setChestplate(new ItemStack(Material.AIR));
            player.updateInventory();
        } else if (IS_V1_14_TO_1_18) {
            player.getInventory().setChestplate(null);
            Bukkit.getScheduler().runTaskLater((Plugin)this.plugin, () -> ((Player)player).updateInventory(), 1L);
        } else if (IS_V1_19_TO_1_20) {
            player.getInventory().setChestplate(null);
        } else if (IS_V1_21_PLUS) {
            player.getInventory().setItem(38, null);
        }
    }

    static {
        Material elytra = null;
        try {
            elytra = Material.valueOf((String)"ELYTRA");
        }
        catch (IllegalArgumentException e) {
            elytra = null;
        }
        ELYTRA_MATERIAL = elytra;
        String version = Bukkit.getBukkitVersion().split("-")[0];
        int versionNum = ElytraCommand.parseVersionNumber(version);
        IS_V1_13 = versionNum == 113;
        IS_V1_14_TO_1_18 = versionNum >= 114 && versionNum <= 118;
        IS_V1_19_TO_1_20 = versionNum >= 119 && versionNum <= 120;
        IS_V1_21_PLUS = versionNum >= 121;
    }
}

