/*
 * Decompiled with CFR 0.152.
 */
package com.github.Doulor.ElytraFlip;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import org.bukkit.configuration.Configuration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.plugin.java.JavaPlugin;

public class MessageManager {
    private final JavaPlugin plugin;
    private YamlConfiguration messagesConfig;
    private File messagesFile;
    private String defaultLanguage = "zh_CN";

    public MessageManager(JavaPlugin plugin) {
        this.plugin = plugin;
        this.loadDefaultLanguage();
    }

    private void loadDefaultLanguage() {
        YamlConfiguration config;
        String lang;
        File configFile = new File(this.plugin.getDataFolder(), "config.yml");
        if (configFile.exists() && (lang = (config = YamlConfiguration.loadConfiguration((File)configFile)).getString("default_language")) != null && !lang.isEmpty()) {
            this.defaultLanguage = lang;
        }
    }

    public void loadConfigs() {
        this.messagesFile = new File(this.plugin.getDataFolder(), "messages.yml");
        if (!this.messagesFile.exists()) {
            this.plugin.saveResource("messages.yml", false);
        }
        this.messagesConfig = YamlConfiguration.loadConfiguration((File)this.messagesFile);
        try (InputStream defaultStream = this.plugin.getResource("messages.yml");
             InputStreamReader defaultReader = new InputStreamReader(defaultStream);){
            YamlConfiguration defaultConfig = YamlConfiguration.loadConfiguration((Reader)defaultReader);
            this.messagesConfig.setDefaults((Configuration)defaultConfig);
        }
        catch (IOException e) {
            this.plugin.getLogger().warning("\u52a0\u8f7d\u9ed8\u8ba4\u6d88\u606f\u914d\u7f6e\u5931\u8d25\uff1a" + e.getMessage());
        }
    }

    public void reloadConfigs() throws IOException {
        if (this.messagesFile == null) {
            this.messagesFile = new File(this.plugin.getDataFolder(), "messages.yml");
        }
        this.messagesConfig = YamlConfiguration.loadConfiguration((File)this.messagesFile);
        try (InputStream defaultStream = this.plugin.getResource("messages.yml");
             InputStreamReader defaultReader = new InputStreamReader(defaultStream);){
            YamlConfiguration defaultConfig = YamlConfiguration.loadConfiguration((Reader)defaultReader);
            this.messagesConfig.setDefaults((Configuration)defaultConfig);
            this.messagesConfig.save(this.messagesFile);
        }
        catch (IOException e) {
            this.plugin.getLogger().warning("\u91cd\u8f7d\u9ed8\u8ba4\u6d88\u606f\u914d\u7f6e\u5931\u8d25\uff1a" + e.getMessage());
            throw e;
        }
        this.loadDefaultLanguage();
    }

    public String getMessage(Player player, String key) {
        String locale = player.getLocale();
        String fullKey = locale + "." + key;
        String message = this.messagesConfig.getString(fullKey);
        if (message == null) {
            message = this.messagesConfig.getString(this.defaultLanguage + "." + key);
        }
        return message != null ? message.replace("&", "\u00a7") : this.getDefaultMessage(key);
    }

    public String getMessage(String key) {
        String message = this.messagesConfig.getString(this.defaultLanguage + "." + key);
        return message != null ? message.replace("&", "\u00a7") : this.getDefaultMessage(key);
    }

    public String getDefaultMessage(String key) {
        switch (key) {
            case "no_permission": {
                return "\u00a7c\u4f60\u6ca1\u6709\u6743\u9650\u4f7f\u7528\u6b64\u6307\u4ee4\uff01";
            }
            case "only_player": {
                return "\u00a7c\u53ea\u6709\u73a9\u5bb6\u53ef\u4ee5\u4f7f\u7528\u6b64\u6307\u4ee4\uff01";
            }
            case "equip_success": {
                return "\u00a7a\u9798\u7fc5\u5df2\u88c5\u5907\uff01";
            }
            case "unequip_success": {
                return "\u00a7a\u9798\u7fc5\u5df2\u5378\u4e0b\uff01";
            }
            case "reload_success": {
                return "\u00a7a\u914d\u7f6e\u5df2\u91cd\u8f7d\uff01";
            }
            case "no_reload_permission": {
                return "\u00a7c\u4f60\u6ca1\u6709\u6743\u9650\u91cd\u8f7d\u914d\u7f6e\uff01";
            }
        }
        return "\u00a7c\u672a\u77e5\u6d88\u606f\uff1a" + key;
    }
}

