/*
 * Decompiled with CFR 0.152.
 */
package net.papierkorb2292.multiscoreboard;

import com.google.common.collect.ImmutableMap;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import net.fabricmc.fabric.api.networking.v1.PacketSender;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_10741;
import net.minecraft.class_1297;
import net.minecraft.class_18;
import net.minecraft.class_1937;
import net.minecraft.class_2105;
import net.minecraft.class_2203;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2960;
import net.minecraft.class_3162;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_4844;
import net.minecraft.class_5321;
import net.minecraft.class_5699;
import net.minecraft.class_7225;
import net.minecraft.class_7924;
import net.minecraft.class_8710;
import net.minecraft.server.MinecraftServer;
import net.papierkorb2292.multiscoreboard.RemoveNbtSidebarS2CPacket;
import net.papierkorb2292.multiscoreboard.SetNbtSidebarS2CPacket;
import net.papierkorb2292.multiscoreboard.mixin.BlockDataObjectAccessor;
import net.papierkorb2292.multiscoreboard.mixin.EntityDataObjectAccessor;
import net.papierkorb2292.multiscoreboard.mixin.StorageDataObjectAccessor;
import org.jetbrains.annotations.Nullable;

public class ServerNbtSidebarManager
extends class_18 {
    private static final String ENTITY_DATA_OBJECT_TYPE = "entity";
    private static final String BLOCK_DATA_OBJECT_TYPE = "block";
    private static final String STORAGE_DATA_OBJECT_TYPE = "storage";
    public static final class_2203.class_2209 ROOT_PATH;
    private static final Codec<Map<String, Entry>> ENTRY_MAP_CODEC;
    private static final DynamicCommandExceptionType INVALID_DATA_SOURCE_EXCEPTION;
    private final MinecraftServer server;
    private final Map<String, Entry> entries;

    public ServerNbtSidebarManager(MinecraftServer server) {
        this(server, new HashMap<String, Entry>());
    }

    public ServerNbtSidebarManager(MinecraftServer server, Map<String, Entry> entries) {
        this.server = server;
        this.entries = new HashMap<String, Entry>(entries);
        this.tick();
    }

    public void tick() {
        for (Map.Entry<String, Entry> entry : this.entries.entrySet()) {
            entry.getValue().updateNbt(entry.getKey(), this);
        }
    }

    public String addEntry(@Nullable String name, class_3162 dataObject, class_2203.class_2209 path) throws CommandSyntaxException {
        Record sidebarNBTProvider;
        if (dataObject instanceof EntityDataObjectAccessor) {
            EntityDataObjectAccessor entityDataObjectAccessor = (EntityDataObjectAccessor)dataObject;
            UUID uuid = entityDataObjectAccessor.getEntity().method_5667();
            sidebarNBTProvider = new EntitySidebarNbtProvider(uuid);
        } else if (dataObject instanceof BlockDataObjectAccessor) {
            BlockDataObjectAccessor blockDataObjectAccessor = (BlockDataObjectAccessor)dataObject;
            class_2338 pos = blockDataObjectAccessor.getPos();
            class_5321 worldKey = Objects.requireNonNull(blockDataObjectAccessor.getBlockEntity().method_10997()).method_27983();
            sidebarNBTProvider = new BlockSidebarNbtProvider(pos, (class_5321<class_1937>)worldKey);
        } else if (dataObject instanceof StorageDataObjectAccessor) {
            StorageDataObjectAccessor storageDataObjectAccessor = (StorageDataObjectAccessor)dataObject;
            class_2960 id = storageDataObjectAccessor.getId();
            sidebarNBTProvider = new StorageSidebarNbtProvider(id);
        } else {
            throw INVALID_DATA_SOURCE_EXCEPTION.create((Object)dataObject.getClass().getName());
        }
        if (name == null) {
            name = sidebarNBTProvider.getDefaultNamePrefix() + (String)(path.toString().isEmpty() ? "" : "_" + String.valueOf(path));
        }
        this.addEntry((String)name, (SidebarNBTProvider)((Object)sidebarNBTProvider), path);
        return name;
    }

    private void addEntry(String name, SidebarNBTProvider sidebarNBTProvider, class_2203.class_2209 path) {
        this.method_80();
        Entry entry = new Entry(sidebarNBTProvider, path);
        this.entries.put(name, entry);
        entry.updateNbt(name, this);
    }

    public boolean removeEntry(String name) {
        this.method_80();
        RemoveNbtSidebarS2CPacket removedPacket = new RemoveNbtSidebarS2CPacket(name);
        for (class_3222 player : this.server.method_3760().method_14571()) {
            ServerPlayNetworking.send((class_3222)player, (class_8710)removedPacket);
        }
        return this.entries.remove(name) != null;
    }

    public int removeEntriesOfDataObject(class_3162 dataObject) {
        int entryCount = this.entries.size();
        this.entries.entrySet().removeIf(entry -> {
            boolean remove = ((Entry)entry.getValue()).nbtProvider.isDataObject(dataObject);
            if (remove) {
                RemoveNbtSidebarS2CPacket removedPacket = new RemoveNbtSidebarS2CPacket((String)entry.getKey());
                for (class_3222 player : this.server.method_3760().method_14571()) {
                    ServerPlayNetworking.send((class_3222)player, (class_8710)removedPacket);
                }
            }
            return remove;
        });
        if (entryCount != this.entries.size()) {
            this.method_80();
        }
        return entryCount - this.entries.size();
    }

    public int removeAllEntries() {
        int count = this.entries.size();
        for (String name : this.entries.keySet()) {
            RemoveNbtSidebarS2CPacket removedPacket = new RemoveNbtSidebarS2CPacket(name);
            for (class_3222 player : this.server.method_3760().method_14571()) {
                ServerPlayNetworking.send((class_3222)player, (class_8710)removedPacket);
            }
        }
        this.entries.clear();
        this.method_80();
        return count;
    }

    public String getEntryNameIfMatches(String name, class_3162 dataObject, class_2203.class_2209 path) {
        if (name == null) {
            for (Map.Entry<String, Entry> entry : this.entries.entrySet()) {
                if (!entry.getValue().nbtProvider.isDataObject(dataObject) || !entry.getValue().path.toString().equals(path.toString())) continue;
                return entry.getKey();
            }
            return null;
        }
        Entry entry = this.entries.get(name);
        if (entry != null && entry.nbtProvider.isDataObject(dataObject) && entry.path.toString().equals(path.toString())) {
            return name;
        }
        return null;
    }

    public Set<String> getNames() {
        return this.entries.keySet();
    }

    public void onPlayerJoin(PacketSender packetSender) {
        for (Map.Entry<String, Entry> entry : this.entries.entrySet()) {
            SetNbtSidebarS2CPacket packet = new SetNbtSidebarS2CPacket(entry.getKey(), entry.getValue().getLastSentNbt());
            packetSender.sendPacket((class_8710)packet);
        }
    }

    public static class_10741<ServerNbtSidebarManager> getPersistentStateType(MinecraftServer server) {
        return new class_10741("multiscoreboard_nbt", () -> new ServerNbtSidebarManager(server), ENTRY_MAP_CODEC.fieldOf("entries").codec().xmap(entries -> new ServerNbtSidebarManager(server, (Map<String, Entry>)entries), manager -> manager.entries), null);
    }

    static {
        ENTRY_MAP_CODEC = Codec.unboundedMap((Codec)Codec.STRING, Entry.CODEC);
        try {
            ROOT_PATH = new class_2203().method_9362(new StringReader(""));
        }
        catch (CommandSyntaxException e) {
            throw new RuntimeException(e);
        }
        INVALID_DATA_SOURCE_EXCEPTION = new DynamicCommandExceptionType(arg -> class_2561.method_30163((String)("Unknown data source: " + String.valueOf(arg))));
    }

    public static final class Entry {
        public static final Codec<Entry> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)SidebarNBTProvider.CODEC.fieldOf("nbtProvider").forGetter(Entry::getNbtProvider), (App)class_5699.method_42114((Codec)Codec.STRING.flatXmap(string -> {
            try {
                return DataResult.success((Object)class_2203.method_9360().method_9362(new StringReader(string)));
            }
            catch (CommandSyntaxException e) {
                return DataResult.error(() -> ((CommandSyntaxException)e).getMessage());
            }
        }, path -> DataResult.success((Object)path.toString()))).fieldOf("path").forGetter(Entry::getPath)).apply((Applicative)instance, Entry::new));
        private final SidebarNBTProvider nbtProvider;
        private final class_2203.class_2209 path;
        private List<class_2520> lastSentNbt = null;

        public Entry(SidebarNBTProvider nbtProvider, class_2203.class_2209 path) {
            this.nbtProvider = nbtProvider;
            this.path = path;
        }

        public SidebarNBTProvider getNbtProvider() {
            return this.nbtProvider;
        }

        public class_2203.class_2209 getPath() {
            return this.path;
        }

        public List<class_2520> getLastSentNbt() {
            return this.lastSentNbt;
        }

        private void updateNbt(String name, ServerNbtSidebarManager manager) {
            List<class_2520> newNBT;
            try {
                class_2487 fullNbt = this.nbtProvider.getNbt((class_7225.class_7874)manager.server.method_30611(), manager);
                newNBT = fullNbt == null ? Collections.emptyList() : this.path.method_9366((class_2520)fullNbt);
            }
            catch (CommandSyntaxException e) {
                newNBT = Collections.emptyList();
            }
            if (!newNBT.equals(this.lastSentNbt)) {
                this.lastSentNbt = newNBT.stream().map(class_2520::method_10707).toList();
                SetNbtSidebarS2CPacket packet = new SetNbtSidebarS2CPacket(name, newNBT);
                for (class_3222 player : manager.server.method_3760().method_14571()) {
                    ServerPlayNetworking.send((class_3222)player, (class_8710)packet);
                }
            }
        }

        public int hashCode() {
            return Objects.hash(this.nbtProvider, this.path);
        }
    }

    public record EntitySidebarNbtProvider(UUID uuid) implements SidebarNBTProvider
    {
        public static final MapCodec<EntitySidebarNbtProvider> CODEC = class_4844.field_40825.xmap(EntitySidebarNbtProvider::new, EntitySidebarNbtProvider::uuid).fieldOf("uuid");

        @Override
        public class_2487 getNbt(class_7225.class_7874 registryLookup, ServerNbtSidebarManager manager) {
            for (class_3218 world : manager.server.method_3738()) {
                class_1297 entity = world.method_66347(this.uuid);
                if (entity == null) continue;
                return class_2105.method_9076((class_1297)entity);
            }
            return null;
        }

        @Override
        public boolean isDataObject(class_3162 dataObject) {
            EntityDataObjectAccessor entityDataObjectAccessor;
            return dataObject instanceof EntityDataObjectAccessor && (entityDataObjectAccessor = (EntityDataObjectAccessor)dataObject).getEntity().method_5667().equals(this.uuid);
        }

        @Override
        public String getDefaultNamePrefix() {
            return this.uuid.toString();
        }

        @Override
        public String getProviderTypeName() {
            return ServerNbtSidebarManager.ENTITY_DATA_OBJECT_TYPE;
        }
    }

    public record BlockSidebarNbtProvider(class_2338 pos, class_5321<class_1937> worldKey) implements SidebarNBTProvider
    {
        public static final MapCodec<BlockSidebarNbtProvider> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)class_2338.field_25064.fieldOf("pos").forGetter(BlockSidebarNbtProvider::pos), (App)class_2960.field_25139.xmap(id -> class_5321.method_29179((class_5321)class_7924.field_41223, (class_2960)id), class_5321::method_29177).fieldOf("world").forGetter(BlockSidebarNbtProvider::worldKey)).apply((Applicative)instance, BlockSidebarNbtProvider::new));

        @Override
        public class_2487 getNbt(class_7225.class_7874 registryLookup, ServerNbtSidebarManager manager) {
            class_3218 world = manager.server.method_3847(this.worldKey);
            if (world == null) {
                return null;
            }
            class_2586 blockEntity = world.method_8500(this.pos).method_8321(this.pos);
            return blockEntity == null ? null : blockEntity.method_38244(registryLookup);
        }

        @Override
        public boolean isDataObject(class_3162 dataObject) {
            if (dataObject instanceof BlockDataObjectAccessor) {
                BlockDataObjectAccessor blockDataObjectAccessor = (BlockDataObjectAccessor)dataObject;
                class_2338 pos = blockDataObjectAccessor.getPos();
                class_5321 worldKey = Objects.requireNonNull(blockDataObjectAccessor.getBlockEntity().method_10997()).method_27983();
                return pos.equals((Object)this.pos) && worldKey.equals(this.worldKey);
            }
            return false;
        }

        @Override
        public String getDefaultNamePrefix() {
            return "[%d;%d;%d]-%s".formatted(this.pos.method_10263(), this.pos.method_10264(), this.pos.method_10260(), this.worldKey.method_29177().toString());
        }

        @Override
        public String getProviderTypeName() {
            return ServerNbtSidebarManager.BLOCK_DATA_OBJECT_TYPE;
        }
    }

    public record StorageSidebarNbtProvider(class_2960 id) implements SidebarNBTProvider
    {
        private static final MapCodec<StorageSidebarNbtProvider> CODEC = class_2960.field_25139.xmap(StorageSidebarNbtProvider::new, StorageSidebarNbtProvider::id).fieldOf("id");

        @Override
        public class_2487 getNbt(class_7225.class_7874 registryLookup, ServerNbtSidebarManager manager) {
            try {
                return manager.server.method_22827().method_22546(this.id);
            }
            catch (NullPointerException e) {
                return null;
            }
        }

        @Override
        public boolean isDataObject(class_3162 dataObject) {
            StorageDataObjectAccessor storageDataObjectAccessor;
            return dataObject instanceof StorageDataObjectAccessor && (storageDataObjectAccessor = (StorageDataObjectAccessor)dataObject).getId().equals((Object)this.id);
        }

        @Override
        public String getDefaultNamePrefix() {
            return this.id.toString();
        }

        @Override
        public String getProviderTypeName() {
            return ServerNbtSidebarManager.STORAGE_DATA_OBJECT_TYPE;
        }
    }

    public static interface SidebarNBTProvider {
        public static final Map<String, MapCodec<? extends SidebarNBTProvider>> IMPLEMENTATION_CODECS = ImmutableMap.builder().put((Object)"entity", EntitySidebarNbtProvider.CODEC).put((Object)"block", BlockSidebarNbtProvider.CODEC).put((Object)"storage", StorageSidebarNbtProvider.CODEC).build();
        public static final MapCodec<SidebarNBTProvider> CODEC = Codec.STRING.dispatchMap("type", SidebarNBTProvider::getProviderTypeName, IMPLEMENTATION_CODECS::get);

        @Nullable
        public class_2487 getNbt(class_7225.class_7874 var1, ServerNbtSidebarManager var2);

        public boolean isDataObject(class_3162 var1);

        public String getDefaultNamePrefix();

        public String getProviderTypeName();
    }
}

