/*
 * Decompiled with CFR 0.152.
 */
package net.papierkorb2292.multiscoreboard.client;

import com.mojang.datafixers.util.Pair;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Stream;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientTickEvents;
import net.fabricmc.fabric.api.client.keybinding.v1.KeyBindingHelper;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayConnectionEvents;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.minecraft.class_1041;
import net.minecraft.class_124;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_266;
import net.minecraft.class_268;
import net.minecraft.class_269;
import net.minecraft.class_2960;
import net.minecraft.class_304;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_3675;
import net.minecraft.class_746;
import net.minecraft.class_8646;
import net.papierkorb2292.multiscoreboard.MultiScoreboardSidebarInterface;
import net.papierkorb2292.multiscoreboard.RemoveNbtSidebarS2CPacket;
import net.papierkorb2292.multiscoreboard.SetNbtSidebarS2CPacket;
import net.papierkorb2292.multiscoreboard.SetUseMultiScoreboardS2CPacket;
import net.papierkorb2292.multiscoreboard.ToggleSingleScoreSidebarS2CPacket;
import net.papierkorb2292.multiscoreboard.client.SidebarNbtRenderable;
import net.papierkorb2292.multiscoreboard.client.SidebarObjectiveRenderable;
import net.papierkorb2292.multiscoreboard.client.SidebarRenderable;
import net.papierkorb2292.multiscoreboard.client.SidebarSingleScoresRenderable;

@Environment(value=EnvType.CLIENT)
public class MultiScoreboardClient
implements ClientModInitializer {
    private static boolean useMultiScoreboard = false;
    private static final Map<String, List<class_2520>> nbtSidebars = new HashMap<String, List<class_2520>>();
    private static int sidebarScrollTranslation = 0;
    private static final int scrollAmount = 10;
    private static final int maxTranslationBoundary = 10;
    private static class_304 scrollUpKeyBinding;
    private static class_304 scrollDownKeyBinding;
    public static final int sidebarGap = 11;
    public static final class_2561 NO_DATA_TEXT;

    public void onInitializeClient() {
        ClientPlayNetworking.registerGlobalReceiver(SetUseMultiScoreboardS2CPacket.ID, (packet, context) -> {
            useMultiScoreboard = packet.useMultiScoreboard();
        });
        ClientPlayNetworking.registerGlobalReceiver(SetNbtSidebarS2CPacket.ID, (packet, context) -> nbtSidebars.put(packet.nbtSidebarName(), packet.nbt()));
        ClientPlayNetworking.registerGlobalReceiver(RemoveNbtSidebarS2CPacket.ID, (packet, context) -> {
            nbtSidebars.remove(packet.nbtSidebarName());
            MultiScoreboardClient.clampScrollTranslation();
        });
        ClientPlayNetworking.registerGlobalReceiver(ToggleSingleScoreSidebarS2CPacket.ID, (packet, context) -> {
            class_269 scoreboard = context.player().method_73183().method_8428();
            class_266 objective = scoreboard.method_1170(packet.objective());
            if (objective == null) {
                return;
            }
            ((MultiScoreboardSidebarInterface)scoreboard).multiScoreboard$toggleSingleScoreSidebar(objective, packet.score());
        });
        ClientPlayConnectionEvents.DISCONNECT.register((handler, client) -> {
            useMultiScoreboard = false;
            nbtSidebars.clear();
        });
        class_304.class_11900 keybindCategory = class_304.class_11900.method_74698((class_2960)class_2960.method_60655((String)"multiscoreboard", (String)"generic"));
        scrollUpKeyBinding = KeyBindingHelper.registerKeyBinding((class_304)new class_304("key.multiscoreboard.scroll_up", class_3675.class_307.field_1668, 265, keybindCategory));
        scrollDownKeyBinding = KeyBindingHelper.registerKeyBinding((class_304)new class_304("key.multiscoreboard.scroll_down", class_3675.class_307.field_1668, 264, keybindCategory));
        ClientTickEvents.END_CLIENT_TICK.register(client -> {
            class_8646 scoreboardDisplaySlot;
            boolean wasUpPressed = scrollUpKeyBinding.method_1436();
            boolean wasDownPressed = scrollDownKeyBinding.method_1436();
            boolean isUpPressed = scrollUpKeyBinding.method_1434();
            boolean isDownPressed = scrollDownKeyBinding.method_1434();
            if (wasUpPressed == wasDownPressed && isUpPressed == isDownPressed) {
                return;
            }
            class_269 scoreboard = Objects.requireNonNull(client.field_1687).method_8428();
            class_268 team = scoreboard.method_1164(Objects.requireNonNull(class_310.method_1551().field_1724).method_5820());
            class_266 teamObjective = null;
            if (team != null && (scoreboardDisplaySlot = class_8646.method_52622((class_124)team.method_1202())) != null) {
                teamObjective = scoreboard.method_1189(scoreboardDisplaySlot);
            }
            Pair<Integer, Map<SidebarRenderable, Integer>> calculatedHeights = MultiScoreboardClient.calculateSidebarHeights(scoreboard, teamObjective);
            Integer totalHeight = (Integer)calculatedHeights.getFirst();
            Map scoreboardHeights = (Map)calculatedHeights.getSecond();
            List<Map.Entry> sortedObjectives = scoreboardHeights.entrySet().stream().sorted(Comparator.comparing(renderable -> ((SidebarRenderable)renderable.getKey()).getSortName())).toList();
            int maxTranslation = (totalHeight - client.method_22683().method_4502()) / 2 + 10;
            if (maxTranslation < 0) {
                sidebarScrollTranslation = 0;
                return;
            }
            boolean shouldJumpScoreboard = class_3675.method_15987((class_1041)client.method_22683(), (int)341);
            if (shouldJumpScoreboard) {
                if (wasUpPressed) {
                    block0: do {
                        int accumulatedLength = sidebarScrollTranslation;
                        for (Map.Entry entry : sortedObjectives) {
                            int newLength = (Integer)entry.getValue() + 11;
                            if ((accumulatedLength += newLength) < maxTranslation) continue;
                            sidebarScrollTranslation += newLength - (accumulatedLength - maxTranslation);
                            continue block0;
                        }
                    } while (scrollUpKeyBinding.method_1436());
                    return;
                }
                if (wasDownPressed) {
                    block2: do {
                        int accumulatedLength = -sidebarScrollTranslation;
                        for (int i = sortedObjectives.size() - 1; i >= 0; --i) {
                            Map.Entry entry = sortedObjectives.get(i);
                            int newLength = (Integer)entry.getValue() + 11;
                            if ((accumulatedLength += newLength) < maxTranslation) continue;
                            sidebarScrollTranslation -= newLength - (accumulatedLength - maxTranslation);
                            continue block2;
                        }
                    } while (scrollDownKeyBinding.method_1436());
                    return;
                }
                return;
            }
            if (isUpPressed) {
                sidebarScrollTranslation = Math.min(sidebarScrollTranslation + 10, maxTranslation);
                return;
            }
            if (isDownPressed) {
                sidebarScrollTranslation = Math.max(sidebarScrollTranslation - 10, -maxTranslation);
            }
        });
    }

    public static void clampScrollTranslation() {
        Pair<Integer, Map<SidebarRenderable, Integer>> calculatedHeights;
        Integer totalHeight;
        int maxTranslation;
        class_8646 scoreboardDisplaySlot;
        class_746 player = Objects.requireNonNull(class_310.method_1551().field_1724);
        class_269 scoreboard = player.method_73183().method_8428();
        class_268 team = scoreboard.method_1164(player.method_5820());
        class_266 teamObjective = null;
        if (team != null && (scoreboardDisplaySlot = class_8646.method_52622((class_124)team.method_1202())) != null) {
            teamObjective = scoreboard.method_1189(scoreboardDisplaySlot);
        }
        if ((maxTranslation = ((totalHeight = (Integer)(calculatedHeights = MultiScoreboardClient.calculateSidebarHeights(scoreboard, teamObjective)).getFirst()) - class_310.method_1551().method_22683().method_4502()) / 2 + 10) < 0) {
            sidebarScrollTranslation = 0;
            return;
        }
        sidebarScrollTranslation = class_3532.method_15340((int)sidebarScrollTranslation, (int)(-maxTranslation), (int)maxTranslation);
    }

    public static boolean useMultiScoreboard() {
        return useMultiScoreboard;
    }

    public static int getSidebarScrollTranslation() {
        return sidebarScrollTranslation;
    }

    public static Pair<Integer, Map<SidebarRenderable, Integer>> calculateSidebarHeights(class_269 scoreboard, class_266 teamObjective) {
        HashMap<SidebarObjectiveRenderable, Integer> scoreboardHeights = new HashMap<SidebarObjectiveRenderable, Integer>();
        Set<class_266> sidebarObjectives = ((MultiScoreboardSidebarInterface)scoreboard).multiScoreboard$getSidebarObjectives();
        Map<class_266, Set<String>> singleScoreSidebars = ((MultiScoreboardSidebarInterface)scoreboard).multiScoreboard$getSingleScoreSidebars();
        Map<String, List<class_2520>> sidebarNbt = MultiScoreboardClient.getNbtSidebars();
        Stream<SidebarRenderable> renderablesStream = sidebarObjectives.stream().map(SidebarObjectiveRenderable::new);
        renderablesStream = Stream.concat(renderablesStream, sidebarNbt.entrySet().stream().map(entry -> new SidebarNbtRenderable((String)entry.getKey(), (List)entry.getValue())));
        renderablesStream = Stream.concat(renderablesStream, singleScoreSidebars.keySet().stream().filter(key -> !sidebarObjectives.contains(key)).map(SidebarSingleScoresRenderable::new));
        int totalHeight = renderablesStream.mapToInt(renderable -> {
            int height = renderable.calculateHeight();
            scoreboardHeights.put((SidebarObjectiveRenderable)renderable, height);
            return height;
        }).sum() + (scoreboardHeights.size() - 1) * 11;
        if (teamObjective != null) {
            SidebarObjectiveRenderable teamObjectiveRenderable = new SidebarObjectiveRenderable(teamObjective, false);
            int teamObjectiveHeight = teamObjectiveRenderable.calculateHeight();
            scoreboardHeights.put(teamObjectiveRenderable, teamObjectiveHeight);
            totalHeight += teamObjectiveHeight + 11;
        }
        return Pair.of((Object)totalHeight, scoreboardHeights);
    }

    public static Map<String, List<class_2520>> getNbtSidebars() {
        return nbtSidebars;
    }

    static {
        NO_DATA_TEXT = class_2561.method_43471((String)"multiScoreboard.sidebarNbt.noData").method_27694(style -> style.method_36139(-65536));
    }
}

