/*
 * Decompiled with CFR 0.152.
 */
package net.papierkorb2292.multiscoreboard.client;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.regex.Pattern;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_124;
import net.minecraft.class_2479;
import net.minecraft.class_2481;
import net.minecraft.class_2483;
import net.minecraft.class_2487;
import net.minecraft.class_2489;
import net.minecraft.class_2491;
import net.minecraft.class_2494;
import net.minecraft.class_2495;
import net.minecraft.class_2497;
import net.minecraft.class_2499;
import net.minecraft.class_2501;
import net.minecraft.class_2503;
import net.minecraft.class_2516;
import net.minecraft.class_2519;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_329;
import net.minecraft.class_332;
import net.minecraft.class_5250;
import net.minecraft.class_5348;
import net.minecraft.class_5627;
import net.papierkorb2292.multiscoreboard.client.MultiScoreboardClient;
import net.papierkorb2292.multiscoreboard.client.SidebarRenderable;
import org.jetbrains.annotations.Nullable;

@Environment(value=EnvType.CLIENT)
public class SidebarNbtRenderable
implements SidebarRenderable {
    private static final int MAX_ENTRIES = 15;
    private static final int KEY_VALUE_DISTANCE = 10;
    private static final class_124 TAG_FORMATTING = class_124.field_1075;
    private static final class_124 STRING_FORMATTING = class_124.field_1060;
    private static final class_124 NUMBER_FORMATTING = class_124.field_1065;
    private static final class_124 TYPE_SUFFIX_FORMATTING = class_124.field_1061;
    private final String nbtSidebarName;
    private final List<class_2520> nbt;
    private static Pattern TAG_QUOTATION_UNNECESSARY_PATTERN = Pattern.compile("[A-Za-z._]+[A-Za-z0-9._+-]*");

    public SidebarNbtRenderable(String nbtSidebarName, List<class_2520> nbt) {
        this.nbtSidebarName = nbtSidebarName;
        this.nbt = nbt;
    }

    @Override
    public String getSortName() {
        return this.nbtSidebarName;
    }

    @Override
    public void render(class_332 context, class_329 inGameHud) {
        class_327 textRenderer = class_310.method_1551().field_1772;
        class_2561 title = class_2561.method_30163((String)this.nbtSidebarName);
        ArrayList<List<TopLevelNbtVisitor.Entry>> entries = new ArrayList<List<TopLevelNbtVisitor.Entry>>();
        if (!this.nbt.isEmpty()) {
            TopLevelNbtVisitor content = new TopLevelNbtVisitor(this.buildEntryDistribution(), entries);
            for (class_2520 element : this.nbt) {
                element.method_32289((class_5627)content);
            }
        } else {
            entries.add(List.of(new TopLevelNbtVisitor.Entry(null, MultiScoreboardClient.NO_DATA_TEXT)));
        }
        int entryCount = this.getTotalEntriesCount();
        int titleWidth = textRenderer.method_27525((class_5348)title);
        Objects.requireNonNull(textRenderer);
        int entriesHeight = entryCount * 9;
        int maxWidth = titleWidth;
        for (List<TopLevelNbtVisitor.Entry> section : entries) {
            for (TopLevelNbtVisitor.Entry entry : section) {
                int width = textRenderer.method_27525((class_5348)entry.value);
                if (entry.key != null) {
                    width += textRenderer.method_27525((class_5348)entry.key) + 10;
                }
                maxWidth = Math.max(maxWidth, width);
            }
        }
        int lowerY = context.method_51443() / 2 + entriesHeight;
        int border = 3;
        int leftX = context.method_51421() - maxWidth - border;
        int rightX = context.method_51421() - border + 2;
        int entryBackgroundColor = class_310.method_1551().field_1690.method_19345(0.3f);
        int titleBackgroundColor = class_310.method_1551().field_1690.method_19345(0.4f);
        int titleLowerY = lowerY - entriesHeight;
        Objects.requireNonNull(textRenderer);
        context.method_25294(leftX - 2, titleLowerY - 9 - 1, rightX, titleLowerY - 1, titleBackgroundColor);
        context.method_25294(leftX - 2, titleLowerY - 1, rightX, lowerY, entryBackgroundColor);
        int n = leftX + maxWidth / 2 - titleWidth / 2;
        Objects.requireNonNull(textRenderer);
        context.method_51439(textRenderer, title, n, titleLowerY - 9, -1, false);
        int i = 0;
        for (List<TopLevelNbtVisitor.Entry> section : entries) {
            for (TopLevelNbtVisitor.Entry entry : section) {
                int n2 = entryCount - i++;
                Objects.requireNonNull(textRenderer);
                int entryY = lowerY - n2 * 9;
                int valueWidth = textRenderer.method_27525((class_5348)entry.value);
                if (entry.key == null) {
                    context.method_51439(textRenderer, entry.value, leftX + maxWidth / 2 - valueWidth / 2, entryY, -1, false);
                    continue;
                }
                context.method_51439(textRenderer, entry.key, leftX, entryY, -1, false);
                context.method_51439(textRenderer, entry.value, leftX + maxWidth - valueWidth, entryY, -1, false);
            }
            if (i == entryCount) continue;
            Objects.requireNonNull(textRenderer);
            int separationY = lowerY - (entryCount - i) * 9;
            context.method_25294(leftX - 2, separationY - 1, rightX, separationY, -1436129690);
        }
    }

    private int countElements(class_2520 element) {
        if (element instanceof class_2483) {
            class_2483 list = (class_2483)element;
            return list.size();
        }
        if (element instanceof class_2487) {
            class_2487 compound = (class_2487)element;
            return compound.method_10541().size();
        }
        return 1;
    }

    private int getTotalEntriesCount() {
        if (this.nbt.isEmpty()) {
            return 1;
        }
        return Math.min(this.nbt.stream().mapToInt(this::countElements).sum(), 15);
    }

    private int[] buildEntryDistribution() {
        int[] result = new int[this.nbt.size()];
        int remainingEntries = this.getTotalEntriesCount();
        block0: while (remainingEntries > 0) {
            for (int i = 0; i < result.length; ++i) {
                if (result[i] >= this.countElements(this.nbt.get(i))) continue;
                int n = i;
                result[n] = result[n] + 1;
                if (--remainingEntries < 1) continue block0;
            }
        }
        return result;
    }

    @Override
    public int calculateHeight() {
        int n = 1 + this.getTotalEntriesCount();
        Objects.requireNonNull(class_310.method_1551().field_1772);
        return n * 9;
    }

    private static class_5250 getIndexText(int index) {
        return class_2561.method_43470((String)String.valueOf(index)).method_27694(style -> style.method_27706(TAG_FORMATTING));
    }

    private static class_5250 getTagText(String tag) {
        if (!TAG_QUOTATION_UNNECESSARY_PATTERN.matcher(tag).matches()) {
            tag = class_2519.method_10706((String)tag);
        }
        return class_2561.method_43470((String)tag).method_27694(style -> style.method_27706(TAG_FORMATTING));
    }

    @Environment(value=EnvType.CLIENT)
    private static class TopLevelNbtVisitor
    implements class_5627 {
        public final int[] visitorEntryCount;
        public List<List<Entry>> entries;
        public int currentVisitorIndex = 0;

        public TopLevelNbtVisitor(int[] visitorEntryCount, List<List<Entry>> entries) {
            this.visitorEntryCount = visitorEntryCount;
            this.entries = entries;
        }

        public void method_32302(class_2519 element) {
            int allowedEntries = this.getNextEntryCount();
            if (allowedEntries == 0) {
                return;
            }
            NestedNbtVisitor nestedVisitor = new NestedNbtVisitor();
            nestedVisitor.method_32302(element);
            this.entries.add(List.of(new Entry(null, (class_2561)nestedVisitor.text)));
        }

        public void method_32291(class_2481 element) {
            int allowedEntries = this.getNextEntryCount();
            if (allowedEntries == 0) {
                return;
            }
            NestedNbtVisitor nestedVisitor = new NestedNbtVisitor();
            nestedVisitor.method_32291(element);
            this.entries.add(List.of(new Entry(null, (class_2561)nestedVisitor.text)));
        }

        public void method_32301(class_2516 element) {
            int allowedEntries = this.getNextEntryCount();
            if (allowedEntries == 0) {
                return;
            }
            NestedNbtVisitor nestedVisitor = new NestedNbtVisitor();
            nestedVisitor.method_32301(element);
            this.entries.add(List.of(new Entry(null, (class_2561)nestedVisitor.text)));
        }

        public void method_32297(class_2497 element) {
            int allowedEntries = this.getNextEntryCount();
            if (allowedEntries == 0) {
                return;
            }
            NestedNbtVisitor nestedVisitor = new NestedNbtVisitor();
            nestedVisitor.method_32297(element);
            this.entries.add(List.of(new Entry(null, (class_2561)nestedVisitor.text)));
        }

        public void method_32300(class_2503 element) {
            int allowedEntries = this.getNextEntryCount();
            if (allowedEntries == 0) {
                return;
            }
            NestedNbtVisitor nestedVisitor = new NestedNbtVisitor();
            nestedVisitor.method_32300(element);
            this.entries.add(List.of(new Entry(null, (class_2561)nestedVisitor.text)));
        }

        public void method_32295(class_2494 element) {
            int allowedEntries = this.getNextEntryCount();
            if (allowedEntries == 0) {
                return;
            }
            NestedNbtVisitor nestedVisitor = new NestedNbtVisitor();
            nestedVisitor.method_32295(element);
            this.entries.add(List.of(new Entry(null, (class_2561)nestedVisitor.text)));
        }

        public void method_32293(class_2489 element) {
            int allowedEntries = this.getNextEntryCount();
            if (allowedEntries == 0) {
                return;
            }
            NestedNbtVisitor nestedVisitor = new NestedNbtVisitor();
            nestedVisitor.method_32293(element);
            this.entries.add(List.of(new Entry(null, (class_2561)nestedVisitor.text)));
        }

        public void method_32290(class_2479 element) {
            this.visitAbstractList((class_2483)element);
        }

        public void method_32296(class_2495 element) {
            this.visitAbstractList((class_2483)element);
        }

        public void method_32299(class_2501 element) {
            this.visitAbstractList((class_2483)element);
        }

        public void method_32298(class_2499 element) {
            this.visitAbstractList((class_2483)element);
        }

        private void visitAbstractList(class_2483 element) {
            ArrayList<Entry> arrayEntries = new ArrayList<Entry>();
            int endIndex = Math.min(element.size(), this.getNextEntryCount());
            for (int i = 0; i < endIndex; ++i) {
                NestedNbtVisitor nestedVisitor = new NestedNbtVisitor();
                element.method_10534(i).method_32289((class_5627)nestedVisitor);
                arrayEntries.add(new Entry((class_2561)SidebarNbtRenderable.getIndexText(i), (class_2561)nestedVisitor.text));
            }
            this.entries.add(arrayEntries);
        }

        public void method_32292(class_2487 compound) {
            ArrayList arrayEntries = new ArrayList();
            compound.method_10541().stream().sorted().limit(this.getNextEntryCount()).forEach(key -> {
                NestedNbtVisitor nestedVisitor = new NestedNbtVisitor();
                Objects.requireNonNull(compound.method_10580(key)).method_32289((class_5627)nestedVisitor);
                arrayEntries.add(new Entry((class_2561)SidebarNbtRenderable.getTagText(key), (class_2561)nestedVisitor.text));
            });
            this.entries.add(arrayEntries);
        }

        public void method_32294(class_2491 element) {
        }

        private int getNextEntryCount() {
            return this.visitorEntryCount[this.currentVisitorIndex++];
        }

        @Environment(value=EnvType.CLIENT)
        private record Entry(@Nullable class_2561 key, class_2561 value) {
        }
    }

    @Environment(value=EnvType.CLIENT)
    private static class NestedNbtVisitor
    implements class_5627 {
        private int entriesLeft = 3;
        public class_5250 text = class_2561.method_43470((String)"");

        private NestedNbtVisitor() {
        }

        public void method_32302(class_2519 element) {
            this.text.method_10852((class_2561)class_2561.method_43470((String)element.toString()).method_27694(style -> style.method_27706(STRING_FORMATTING)));
        }

        public void method_32291(class_2481 element) {
            this.text.method_10852((class_2561)class_2561.method_43470((String)String.valueOf(element.method_10698())).method_27694(style -> style.method_27706(NUMBER_FORMATTING)).method_10852((class_2561)class_2561.method_43470((String)"b").method_27694(style -> style.method_27706(TYPE_SUFFIX_FORMATTING))));
        }

        public void method_32301(class_2516 element) {
            this.text.method_10852((class_2561)class_2561.method_43470((String)String.valueOf(element.method_10696())).method_27694(style -> style.method_27706(NUMBER_FORMATTING)).method_10852((class_2561)class_2561.method_43470((String)"s").method_27694(style -> style.method_27706(TYPE_SUFFIX_FORMATTING))));
        }

        public void method_32297(class_2497 element) {
            this.text.method_10852((class_2561)class_2561.method_43470((String)String.valueOf(element.method_10701())).method_27694(style -> style.method_27706(NUMBER_FORMATTING)));
        }

        public void method_32300(class_2503 element) {
            this.text.method_10852((class_2561)class_2561.method_43470((String)String.valueOf(element.method_10699())).method_27694(style -> style.method_27706(NUMBER_FORMATTING)).method_10852((class_2561)class_2561.method_43470((String)"l").method_27694(style -> style.method_27706(TYPE_SUFFIX_FORMATTING))));
        }

        public void method_32295(class_2494 element) {
            this.text.method_10852((class_2561)class_2561.method_43470((String)String.format("%.2f", Float.valueOf(element.method_10700()))).method_27694(style -> style.method_27706(NUMBER_FORMATTING)).method_10852((class_2561)class_2561.method_43470((String)"f").method_27694(style -> style.method_27706(TYPE_SUFFIX_FORMATTING))));
        }

        public void method_32293(class_2489 element) {
            this.text.method_10852((class_2561)class_2561.method_43470((String)String.format("%.2f", element.method_10697())).method_27694(style -> style.method_27706(NUMBER_FORMATTING)).method_10852((class_2561)class_2561.method_43470((String)"d").method_27694(style -> style.method_27706(TYPE_SUFFIX_FORMATTING))));
        }

        public void method_32290(class_2479 element) {
            this.visitAbstractList((class_2483)element, "B");
        }

        public void method_32296(class_2495 element) {
            this.visitAbstractList((class_2483)element, "I");
        }

        public void method_32299(class_2501 element) {
            this.visitAbstractList((class_2483)element, "L");
        }

        public void method_32298(class_2499 element) {
            this.visitAbstractList((class_2483)element, null);
        }

        private void visitAbstractList(class_2483 element, @Nullable String typePrefix) {
            this.text.method_10852((class_2561)class_2561.method_43470((String)"["));
            if (typePrefix != null) {
                this.text.method_10852((class_2561)class_2561.method_43470((String)typePrefix).method_27694(style -> style.method_27706(TYPE_SUFFIX_FORMATTING))).method_10852((class_2561)class_2561.method_43470((String)"; "));
            }
            for (int i = 0; i < element.size(); ++i) {
                if (this.entriesLeft <= 0) {
                    this.text.method_10852((class_2561)class_2561.method_43470((String)"...]"));
                    return;
                }
                element.method_10534(i).method_32289((class_5627)this);
                --this.entriesLeft;
                if (i >= element.size() - 1) continue;
                this.text.method_10852((class_2561)class_2561.method_43470((String)", "));
            }
            this.text.method_10852((class_2561)class_2561.method_43470((String)"]"));
        }

        public void method_32292(class_2487 compound) {
            this.text.method_10852((class_2561)class_2561.method_43470((String)"{"));
            int i = 0;
            Iterator keys = compound.method_10541().stream().sorted().iterator();
            while (keys.hasNext()) {
                String key = (String)keys.next();
                if (this.entriesLeft <= 0) {
                    this.text.method_10852((class_2561)class_2561.method_43470((String)"...}"));
                    return;
                }
                this.text.method_10852((class_2561)SidebarNbtRenderable.getTagText(key).method_10852(class_2561.method_30163((String)": ")));
                Objects.requireNonNull(compound.method_10580(key)).method_32289((class_5627)this);
                --this.entriesLeft;
                if (i++ >= compound.method_10541().size() - 1) continue;
                this.text.method_10852((class_2561)class_2561.method_43470((String)", "));
            }
            this.text.method_10852((class_2561)class_2561.method_43470((String)"}"));
        }

        public void method_32294(class_2491 element) {
        }
    }
}

