/*
 * Decompiled with CFR 0.152.
 */
package net.papierkorb2292.multiscoreboard.client;

import java.util.List;
import java.util.Objects;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_266;
import net.minecraft.class_310;
import net.minecraft.class_329;
import net.minecraft.class_332;
import net.papierkorb2292.multiscoreboard.client.SidebarRenderable;
import net.papierkorb2292.multiscoreboard.client.SidebarSingleScoresRenderable;
import net.papierkorb2292.multiscoreboard.mixin.client.InGameHudAccessor;

@Environment(value=EnvType.CLIENT)
public class SidebarObjectiveRenderable
implements SidebarRenderable {
    public static final ThreadLocal<Integer> CURRENT_MAX_WIDTH = new ThreadLocal();
    private final class_266 objective;
    private final SidebarSingleScoresRenderable singleScoresRenderable;
    private final boolean showSingleScores;

    public SidebarObjectiveRenderable(class_266 objective, boolean showSingleScores) {
        this.objective = objective;
        this.singleScoresRenderable = new SidebarSingleScoresRenderable(objective);
        this.showSingleScores = showSingleScores;
    }

    public SidebarObjectiveRenderable(class_266 objective) {
        this(objective, true);
    }

    @Override
    public String getSortName() {
        return this.objective.method_1113();
    }

    @Override
    public void render(class_332 context, class_329 inGameHud) {
        List<SidebarSingleScoresRenderable.Entry> singleScoresEntries = this.singleScoresRenderable.buildEntries();
        CURRENT_MAX_WIDTH.set(this.singleScoresRenderable.getMaxEntryWidth(singleScoresEntries));
        ((InGameHudAccessor)inGameHud).callRenderScoreboardSidebar(context, this.objective);
        if (this.showSingleScores) {
            context.method_51448().pushMatrix();
            context.method_51448().translate(0.0f, (float)this.calculateVanillaEntriesHeight());
            this.singleScoresRenderable.renderEntries(context, singleScoresEntries, CURRENT_MAX_WIDTH.get());
            context.method_51448().popMatrix();
        }
        CURRENT_MAX_WIDTH.remove();
    }

    private int calculateVanillaEntriesHeight() {
        int n = Math.min(15, this.objective.method_1117().method_1184(this.objective).size());
        Objects.requireNonNull(class_310.method_1551().field_1772);
        return n * 9;
    }

    @Override
    public int calculateHeight() {
        Objects.requireNonNull(class_310.method_1551().field_1772);
        int vanillaHeight = 9 + this.calculateVanillaEntriesHeight();
        if (!this.showSingleScores) {
            return vanillaHeight;
        }
        return vanillaHeight + this.singleScoresRenderable.getEntriesHeight();
    }
}

