/*
 * Decompiled with CFR 0.152.
 */
package net.papierkorb2292.multiscoreboard.client;

import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2561;
import net.minecraft.class_266;
import net.minecraft.class_268;
import net.minecraft.class_270;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_329;
import net.minecraft.class_332;
import net.minecraft.class_5250;
import net.minecraft.class_5348;
import net.minecraft.class_9013;
import net.minecraft.class_9015;
import net.minecraft.class_9025;
import net.papierkorb2292.multiscoreboard.MultiScoreboardSidebarInterface;
import net.papierkorb2292.multiscoreboard.client.MultiScoreboardClient;
import net.papierkorb2292.multiscoreboard.client.SidebarRenderable;
import org.jetbrains.annotations.Nullable;

@Environment(value=EnvType.CLIENT)
public class SidebarSingleScoresRenderable
implements SidebarRenderable {
    private static final int SCORE_GAP = 2;
    private final class_266 objective;

    public SidebarSingleScoresRenderable(class_266 objective) {
        this.objective = objective;
    }

    @Override
    public String getSortName() {
        return this.objective.method_1113();
    }

    @Override
    public void render(class_332 context, class_329 inGameHud) {
        class_327 textRenderer = class_310.method_1551().field_1772;
        class_2561 title = this.objective.method_1114();
        List<Entry> entries = this.buildEntries();
        int titleWidth = textRenderer.method_27525((class_5348)title);
        int maxWidth = Math.max(titleWidth, this.getMaxEntryWidth(entries));
        int titleLowerY = context.method_51443() / 2;
        int border = 3;
        int leftX = context.method_51421() - maxWidth - border;
        int rightX = context.method_51421() - border + 2;
        int titleBackgroundColor = class_310.method_1551().field_1690.method_19345(0.4f);
        Objects.requireNonNull(textRenderer);
        context.method_25294(leftX - 2, titleLowerY - 9 - 1, rightX, titleLowerY, titleBackgroundColor);
        int n = leftX + maxWidth / 2 - titleWidth / 2;
        Objects.requireNonNull(textRenderer);
        context.method_51439(textRenderer, title, n, titleLowerY - 9, -1, false);
        this.renderEntries(context, entries, maxWidth);
    }

    public void renderEntries(class_332 context, List<Entry> entries, int maxWidth) {
        class_327 textRenderer = class_310.method_1551().field_1772;
        int upperY = class_310.method_1551().method_22683().method_4502() / 2;
        int border = 3;
        int leftX = class_310.method_1551().method_22683().method_4486() - maxWidth - border;
        int rightX = class_310.method_1551().method_22683().method_4486() - border + 2;
        int entryBackgroundColor = class_310.method_1551().field_1690.method_19345(0.3f);
        for (int i = 0; i < entries.size(); ++i) {
            Entry entry = entries.get(i);
            Objects.requireNonNull(class_310.method_1551().field_1772);
            int entryUpperY = upperY + i * 9 + (i + 1) * 2;
            Objects.requireNonNull(class_310.method_1551().field_1772);
            context.method_25294(leftX - 2, entryUpperY - 1, rightX, entryUpperY + 9, entryBackgroundColor);
            context.method_51439(textRenderer, entry.name, leftX, entryUpperY, -1, false);
            context.method_51439(textRenderer, entry.value, rightX - textRenderer.method_27525((class_5348)entry.value), entryUpperY, -1, false);
        }
    }

    public List<Entry> buildEntries() {
        Set<String> scoreNames = this.getSingleScores();
        if (scoreNames == null) {
            return List.of();
        }
        return scoreNames.stream().map(name -> {
            class_268 team = this.objective.method_1117().method_1164(name);
            class_5250 nameText = class_268.method_1142((class_270)team, (class_2561)class_2561.method_43470((String)name));
            class_9013 score = this.objective.method_1117().method_55430(class_9015.method_55422((String)name), this.objective);
            if (score == null) {
                return new Entry((class_2561)nameText, MultiScoreboardClient.NO_DATA_TEXT);
            }
            int scoreValue = score.method_55397();
            return new Entry((class_2561)nameText, (class_2561)class_9025.field_47567.method_55457(scoreValue));
        }).sorted(Comparator.comparing(entry -> entry.name.getString())).toList();
    }

    public int getMaxEntryWidth(List<Entry> entries) {
        int entryGap = class_310.method_1551().field_1772.method_1727(": ");
        return entries.stream().mapToInt(entry -> class_310.method_1551().field_1772.method_27525((class_5348)entry.name) + class_310.method_1551().field_1772.method_27525((class_5348)entry.value) + entryGap).max().orElse(0);
    }

    @Override
    public int calculateHeight() {
        int n = this.getEntriesHeight();
        Objects.requireNonNull(class_310.method_1551().field_1772);
        return n + 9;
    }

    public int getEntriesHeight() {
        int n;
        Set<String> singleScores = this.getSingleScores();
        if (singleScores == null) {
            n = 0;
        } else {
            Objects.requireNonNull(class_310.method_1551().field_1772);
            n = (9 + 2) * singleScores.size();
        }
        return n;
    }

    @Nullable
    private Set<String> getSingleScores() {
        return ((MultiScoreboardSidebarInterface)this.objective.method_1117()).multiScoreboard$getSingleScoreSidebars().get(this.objective);
    }

    @Environment(value=EnvType.CLIENT)
    public record Entry(class_2561 name, class_2561 value) {
    }
}

