/*
 * Decompiled with CFR 0.152.
 */
package fuzs.strawstatues.client.entity;

import fuzs.strawstatues.StrawStatues;
import fuzs.strawstatues.client.gui.screens.StrawStatueModelPartsScreen;
import fuzs.strawstatues.world.entity.decoration.StrawStatue;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import net.minecraft.class_11786;
import net.minecraft.class_11901;
import net.minecraft.class_11902;
import net.minecraft.class_1299;
import net.minecraft.class_1453;
import net.minecraft.class_1531;
import net.minecraft.class_1937;
import net.minecraft.class_2379;
import net.minecraft.class_2561;
import net.minecraft.class_2940;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_437;
import net.minecraft.class_8685;
import net.minecraft.class_9296;
import org.jetbrains.annotations.Nullable;

public class ClientStrawStatue
extends StrawStatue
implements class_11901 {
    private final class_11902 avatarState = new class_11902();
    @Nullable
    private CompletableFuture<Optional<class_8685>> skinLookup;
    private class_8685 skin = DEFAULT_SKIN;
    private boolean showExtraEars;
    private final class_11786 skinRenderCache;
    private float oldScale = 1.0f;
    private class_2379 oldEntityPose = DEFAULT_ENTITY_POSE;
    private class_2379 oldHeadPose = class_1531.field_7113;
    private class_2379 oldBodyPose = class_1531.field_7119;
    private class_2379 oldLeftArmPose = class_1531.field_7124;
    private class_2379 oldRightArmPose = class_1531.field_7115;
    private class_2379 oldLeftLegPose = class_1531.field_7121;
    private class_2379 oldRightLegPose = class_1531.field_7117;

    public ClientStrawStatue(class_1299<? extends StrawStatue> entityType, class_1937 level, class_11786 playerSkinRenderCache) {
        super(entityType, level);
        this.skinRenderCache = playerSkinRenderCache;
    }

    @Override
    public void method_5773() {
        super.method_5773();
        if (this.method_73183().method_8608()) {
            this.oldScale = this.method_55693();
            this.oldEntityPose = this.getEntityPose();
            this.oldHeadPose = this.getHeadPose();
            this.oldBodyPose = this.getBodyPose();
            this.oldLeftArmPose = this.getLeftArmPose();
            this.oldRightArmPose = this.getRightArmPose();
            this.oldLeftLegPose = this.getLeftLegPose();
            this.oldRightLegPose = this.getRightLegPose();
            this.avatarState.method_74198(this.method_73189(), this.method_18798());
            this.lookupSkin();
        }
    }

    private void lookupSkin() {
        if (this.skinLookup != null && this.skinLookup.isDone()) {
            try {
                this.skinLookup.get().ifPresent(this::setSkin);
                this.skinLookup = null;
            }
            catch (Exception exception) {
                StrawStatues.LOGGER.error("Error when trying to look up skin", (Throwable)exception);
            }
        }
    }

    @Override
    public void method_5674(class_2940<?> dataAccessor) {
        super.method_5674(dataAccessor);
        if (this.method_73183().method_8608() && (Objects.equals(dataAccessor, field_62516) || Objects.equals(dataAccessor, DATA_DYNAMIC_PROFILE))) {
            this.updateProfile();
        }
    }

    private void updateProfile() {
        this.updateSkin();
        class_437 class_4372 = class_310.method_1551().field_1755;
        if (class_4372 instanceof StrawStatueModelPartsScreen) {
            StrawStatueModelPartsScreen screen = (StrawStatueModelPartsScreen)class_4372;
            screen.applyNameValue();
        }
    }

    private void updateSkin() {
        if (this.skinLookup != null) {
            CompletableFuture<Optional<class_8685>> completableFuture = this.skinLookup;
            this.skinLookup = null;
            completableFuture.cancel(false);
        }
        if (Objects.equals(this.method_74104(), field_62519)) {
            this.setSkin(DEFAULT_SKIN);
        } else {
            this.skinLookup = this.skinRenderCache.method_74320(this.getSkinProfile()).thenApply(optional -> optional.map(class_11786.class_11787::method_73503));
            this.showExtraEars = Objects.equals("deadmau5", this.getProfileName());
        }
    }

    private class_9296 getSkinProfile() {
        return this.isDynamicProfile() ? class_9296.method_74889((String)this.getProfileName()) : this.method_74104();
    }

    public float getScale(float partialTick) {
        return class_3532.method_16439((float)partialTick, (float)this.oldScale, (float)this.method_55693());
    }

    public float getPoseX(float partialTick) {
        return class_3532.method_17821((float)partialTick, (float)this.oldEntityPose.comp_3776(), (float)this.getEntityPose().comp_3776());
    }

    public float getPoseZ(float partialTick) {
        return class_3532.method_17821((float)partialTick, (float)this.oldEntityPose.comp_3778(), (float)this.getEntityPose().comp_3778());
    }

    public class_2379 getHeadPose(float partialTick) {
        return ClientStrawStatue.lerpRotations(partialTick, this.oldHeadPose, this.getHeadPose());
    }

    public class_2379 getBodyPose(float partialTick) {
        return ClientStrawStatue.lerpRotations(partialTick, this.oldBodyPose, this.getBodyPose());
    }

    public class_2379 getLeftArmPose(float partialTick) {
        return ClientStrawStatue.lerpRotations(partialTick, this.oldLeftArmPose, this.getLeftArmPose());
    }

    public class_2379 getRightArmPose(float partialTick) {
        return ClientStrawStatue.lerpRotations(partialTick, this.oldRightArmPose, this.getRightArmPose());
    }

    public class_2379 getLeftLegPose(float partialTick) {
        return ClientStrawStatue.lerpRotations(partialTick, this.oldLeftLegPose, this.getLeftLegPose());
    }

    public class_2379 getRightLegPose(float partialTick) {
        return ClientStrawStatue.lerpRotations(partialTick, this.oldRightLegPose, this.getRightLegPose());
    }

    private static class_2379 lerpRotations(float partialTick, class_2379 oldRotations, class_2379 newRotations) {
        float x = class_3532.method_17821((float)partialTick, (float)oldRotations.comp_3776(), (float)newRotations.comp_3776());
        float y = class_3532.method_17821((float)partialTick, (float)oldRotations.comp_3777(), (float)newRotations.comp_3777());
        float z = class_3532.method_17821((float)partialTick, (float)oldRotations.comp_3778(), (float)newRotations.comp_3778());
        return new class_2379(x, y, z);
    }

    public class_11902 method_74192() {
        return this.avatarState;
    }

    public class_8685 method_52814() {
        return this.skin.method_74883(this.getSkinPatch());
    }

    private void setSkin(class_8685 skin) {
        this.skin = skin;
    }

    @Nullable
    public class_2561 method_74193() {
        return this.method_74880();
    }

    @Nullable
    public class_1453.class_7989 method_74191(boolean left) {
        return null;
    }

    public boolean method_74194() {
        return this.showExtraEars;
    }
}

