/*
 * Decompiled with CFR 0.152.
 */
package fuzs.strawstatues.client.gui.screens;

import fuzs.puzzleslib.api.client.gui.v2.components.SpritelessImageButton;
import fuzs.puzzleslib.api.network.v4.MessageSender;
import fuzs.puzzleslib.api.network.v4.message.Message;
import fuzs.statuemenus.api.v1.client.gui.screens.AbstractStatueScreen;
import fuzs.statuemenus.api.v1.client.gui.screens.StatuePositionScreen;
import fuzs.statuemenus.api.v1.client.gui.screens.StatueWidgetsScreen;
import fuzs.statuemenus.api.v1.network.client.data.DataSyncHandler;
import fuzs.statuemenus.api.v1.world.inventory.StatueHolder;
import fuzs.statuemenus.api.v1.world.inventory.data.StatueScreenType;
import fuzs.strawstatues.network.client.ServerboundStrawStatueScaleMessage;
import fuzs.strawstatues.network.client.ServerboundStrawStatueSkinPatchMessage;
import fuzs.strawstatues.world.entity.decoration.StrawStatue;
import fuzs.strawstatues.world.inventory.data.StrawStatueScreenTypes;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalDouble;
import net.minecraft.class_11908;
import net.minecraft.class_12079;
import net.minecraft.class_124;
import net.minecraft.class_1309;
import net.minecraft.class_1661;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_339;
import net.minecraft.class_342;
import net.minecraft.class_364;
import net.minecraft.class_7919;
import net.minecraft.class_8685;
import net.minecraft.class_9848;

public class StrawStatueTexturesScreen
extends StatuePositionScreen {
    public static final class_2561 SKIN_TEXTURE_COMPONENT = class_2561.method_43471((String)StrawStatueScreenTypes.TEXTURES.id().method_48747("screen", "texture.skin"));
    public static final class_2561 CAPE_TEXTURE_COMPONENT = class_2561.method_43471((String)StrawStatueScreenTypes.TEXTURES.id().method_48747("screen", "texture.cape"));
    public static final class_2561 ELYTRA_TEXTURE_COMPONENT = class_2561.method_43471((String)StrawStatueScreenTypes.TEXTURES.id().method_48747("screen", "texture.elytra"));
    public static final class_2561 ROTATION_X_COMPONENT = class_2561.method_43471((String)StrawStatueScreenTypes.TEXTURES.id().method_48747("screen", "rotation.x"));
    public static final class_2561 ROTATION_Y_COMPONENT = class_2561.method_43471((String)StrawStatueScreenTypes.TEXTURES.id().method_48747("screen", "rotation.y"));
    public static final class_2561 ROTATION_Z_COMPONENT = class_2561.method_43471((String)StrawStatueScreenTypes.TEXTURES.id().method_48747("screen", "rotation.z"));
    protected static final StatueWidgetsScreen.ArmorStandWidgetFactory<StrawStatueTexturesScreen> SKIN_TEXTURE_WIDGET_FACTORY = (screen, livingEntity) -> {
        StrawStatueTexturesScreen strawStatueTexturesScreen = screen;
        Objects.requireNonNull(strawStatueTexturesScreen);
        return strawStatueTexturesScreen.new TextureWidget(SKIN_TEXTURE_COMPONENT, ServerboundStrawStatueSkinPatchMessage.DataType.SKIN);
    };
    protected static final StatueWidgetsScreen.ArmorStandWidgetFactory<StrawStatueTexturesScreen> CAPE_TEXTURE_WIDGET_FACTORY = (screen, livingEntity) -> {
        StrawStatueTexturesScreen strawStatueTexturesScreen = screen;
        Objects.requireNonNull(strawStatueTexturesScreen);
        return strawStatueTexturesScreen.new TextureWidget(CAPE_TEXTURE_COMPONENT, ServerboundStrawStatueSkinPatchMessage.DataType.CAPE);
    };
    protected static final StatueWidgetsScreen.ArmorStandWidgetFactory<StrawStatueTexturesScreen> ELYTRA_TEXTURE_WIDGET_FACTORY = (screen, livingEntity) -> {
        StrawStatueTexturesScreen strawStatueTexturesScreen = screen;
        Objects.requireNonNull(strawStatueTexturesScreen);
        return strawStatueTexturesScreen.new TextureWidget(ELYTRA_TEXTURE_COMPONENT, ServerboundStrawStatueSkinPatchMessage.DataType.ELYTRA);
    };
    protected static final StatueWidgetsScreen.ArmorStandWidgetFactory<StrawStatueTexturesScreen> ROTATION_X_WIDGET_FACTORY = (screen, livingEntity) -> {
        StrawStatueTexturesScreen strawStatueTexturesScreen = screen;
        Objects.requireNonNull(strawStatueTexturesScreen);
        return new CustomRotationWidget(strawStatueTexturesScreen, ROTATION_X_COMPONENT, (StrawStatue)((Object)livingEntity), ServerboundStrawStatueScaleMessage.ValueAccessor.ROTATION_X);
    };
    protected static final StatueWidgetsScreen.ArmorStandWidgetFactory<StrawStatueTexturesScreen> ROTATION_Y_WIDGET_FACTORY = (screen, livingEntity) -> {
        StrawStatueTexturesScreen strawStatueTexturesScreen = screen;
        Objects.requireNonNull(strawStatueTexturesScreen);
        return new StatuePositionScreen.RotationWidget((StatuePositionScreen)strawStatueTexturesScreen, ROTATION_Y_COMPONENT, () -> ((class_1309)livingEntity).method_36454(), arg_0 -> ((DataSyncHandler)screen.dataSyncHandler).sendRotation(arg_0));
    };
    protected static final StatueWidgetsScreen.ArmorStandWidgetFactory<StrawStatueTexturesScreen> ROTATION_Z_WIDGET_FACTORY = (screen, livingEntity) -> {
        StrawStatueTexturesScreen strawStatueTexturesScreen = screen;
        Objects.requireNonNull(strawStatueTexturesScreen);
        return new CustomRotationWidget(strawStatueTexturesScreen, ROTATION_Z_COMPONENT, (StrawStatue)((Object)livingEntity), ServerboundStrawStatueScaleMessage.ValueAccessor.ROTATION_Z);
    };

    public StrawStatueTexturesScreen(StatueHolder statueHolder, class_1661 inventory, class_2561 component, DataSyncHandler dataSyncHandler) {
        super(statueHolder, inventory, component, dataSyncHandler);
    }

    protected List<StatueWidgetsScreen.ArmorStandWidget> buildWidgets(class_1309 livingEntity) {
        return StrawStatueTexturesScreen.buildWidgets((StatueWidgetsScreen)this, (class_1309)livingEntity, List.of(ROTATION_X_WIDGET_FACTORY, ROTATION_Y_WIDGET_FACTORY, ROTATION_Z_WIDGET_FACTORY, SKIN_TEXTURE_WIDGET_FACTORY, CAPE_TEXTURE_WIDGET_FACTORY, ELYTRA_TEXTURE_WIDGET_FACTORY));
    }

    public StatueScreenType getScreenType() {
        return StrawStatueScreenTypes.TEXTURES;
    }

    protected class CustomRotationWidget
    extends StatuePositionScreen.RotationWidget {
        private final ServerboundStrawStatueScaleMessage.ValueAccessor valueAccessor;

        public CustomRotationWidget(StrawStatueTexturesScreen this$0, class_2561 title, StrawStatue strawStatue, ServerboundStrawStatueScaleMessage.ValueAccessor valueAccessor) {
            super((StatuePositionScreen)this$0, title, () -> valueAccessor.getRotationsComponent(strawStatue.getEntityPose()), value -> strawStatue.setEntityPose(valueAccessor.setRotationsComponent(strawStatue.getEntityPose(), value.floatValue())));
            this.valueAccessor = valueAccessor;
        }

        protected OptionalDouble getDefaultValue() {
            return OptionalDouble.of(this.valueAccessor.getRotationsComponent(StrawStatue.DEFAULT_ENTITY_POSE) / 360.0f);
        }

        protected double getCurrentValue() {
            return this.valueGetter.getAsDouble() / 360.0;
        }

        protected void setNewValue(double newValue) {
            this.valueSetter.accept(Float.valueOf((float)(newValue * 360.0)));
        }

        protected void applyClientValue(double newValue) {
            MessageSender.broadcast((Message)new ServerboundStrawStatueScaleMessage(this.valueAccessor, (float)(newValue * 360.0)));
        }
    }

    private class TextureWidget
    extends StatueWidgetsScreen.ArmorStandWidget {
        private final ServerboundStrawStatueSkinPatchMessage.DataType dataType;
        private class_342 editBox;

        public TextureWidget(class_2561 component, ServerboundStrawStatueSkinPatchMessage.DataType dataType) {
            super((StatueWidgetsScreen)StrawStatueTexturesScreen.this, component);
            this.dataType = dataType;
        }

        public void init(int posX, int posY) {
            super.init(posX, posY);
            class_339 checkmarkButton = (class_339)this.addRenderableWidget((class_364)new SpritelessImageButton(posX + 174, posY + 1, 20, 20, 212, 0, AbstractStatueScreen.getArmorStandWidgetsLocation(), button -> {
                class_2960 resourceLocation = class_2960.method_12829((String)this.editBox.method_1882());
                if (resourceLocation != null) {
                    Optional<Object> resourceTexture = resourceLocation.method_12832().isEmpty() ? Optional.empty() : Optional.of(new class_12079.class_10726(resourceLocation));
                    MessageSender.broadcast((Message)new ServerboundStrawStatueSkinPatchMessage(this.dataType, resourceTexture));
                } else {
                    button.field_22763 = false;
                }
            }));
            checkmarkButton.method_47400(class_7919.method_47407((class_2561)StatueWidgetsScreen.SAVE_COMPONENT));
            this.editBox = new class_342(this, StrawStatueTexturesScreen.this.field_22793, posX + 77, posY, 91, 22, StrawStatueTexturesScreen.this.getHolder().getEntity().method_5864().method_5897()){

                public boolean method_25404(class_11908 event) {
                    return super.method_25404(event) || this.method_20315();
                }
            };
            this.editBox.method_1880(256);
            this.editBox.method_1863(string -> {
                class_2960 resourceLocation = class_2960.method_12829((String)string);
                if (resourceLocation != null) {
                    checkmarkButton.field_22763 = true;
                    this.editBox.method_1868(-2039584);
                } else {
                    checkmarkButton.field_22763 = false;
                    this.editBox.method_1868(class_9848.method_61334((int)class_124.field_1061.method_532()));
                }
                if (resourceLocation != null && !resourceLocation.method_12832().isEmpty()) {
                    String texturePath = new class_12079.class_10726(resourceLocation).comp_3627().toString();
                    this.editBox.method_47400(class_7919.method_47407((class_2561)class_2561.method_43470((String)texturePath)));
                } else {
                    this.editBox.method_47400(null);
                }
            });
            class_8685.class_11892 skinPatch = ((StrawStatue)StrawStatueTexturesScreen.this.getHolder().getEntity()).getSkinPatch();
            this.editBox.method_1852(this.dataType.getTexturePath(skinPatch).map(class_12079.class_10726::comp_3626).map(class_2960::toString).orElse(""));
            this.addRenderableWidget((class_364)this.editBox);
        }
    }
}

