/*
 * Decompiled with CFR 0.152.
 */
package fuzs.strawstatues.client.renderer.entity;

import com.google.common.collect.Maps;
import fuzs.strawstatues.client.entity.ClientStrawStatue;
import fuzs.strawstatues.client.model.StrawStatueCapeModel;
import fuzs.strawstatues.client.model.StrawStatueModel;
import fuzs.strawstatues.client.model.geom.ModModelLayers;
import fuzs.strawstatues.client.renderer.entity.state.StrawStatueRenderState;
import java.util.Map;
import net.minecraft.class_10034;
import net.minecraft.class_10042;
import net.minecraft.class_10055;
import net.minecraft.class_1007;
import net.minecraft.class_10602;
import net.minecraft.class_11659;
import net.minecraft.class_11677;
import net.minecraft.class_11890;
import net.minecraft.class_3532;
import net.minecraft.class_3879;
import net.minecraft.class_3883;
import net.minecraft.class_3887;
import net.minecraft.class_4587;
import net.minecraft.class_5599;
import net.minecraft.class_5601;
import net.minecraft.class_5617;
import net.minecraft.class_572;
import net.minecraft.class_591;
import net.minecraft.class_630;
import net.minecraft.class_7833;
import net.minecraft.class_7920;
import net.minecraft.class_970;
import net.minecraft.class_972;
import net.minecraft.class_978;
import org.joml.Quaternionfc;

public abstract class StrawStatueRenderer
extends class_1007<ClientStrawStatue> {
    protected final Map<class_7920, class_10602<StrawStatueModel>> models;

    public StrawStatueRenderer(final class_5617.class_5618 context) {
        super(context, false);
        this.models = StrawStatueRenderer.bakeModels(context);
        this.field_4738.removeIf(renderLayer -> renderLayer instanceof class_970 || renderLayer instanceof class_972 || renderLayer instanceof class_978);
        this.addHumanoidArmorLayer(context, ModModelLayers.STRAW_STATUE_ARMOR, ModModelLayers.STRAW_STATUE_BABY_ARMOR, class_7920.field_41123);
        this.addHumanoidArmorLayer(context, ModModelLayers.STRAW_STATUE_SLIM_ARMOR, ModModelLayers.STRAW_STATUE_BABY_SLIM_ARMOR, class_7920.field_41122);
        this.method_4046((class_3887)new class_978(this, (class_3883)this, context.method_32170()){
            private final class_10602<class_572<class_10055>> models;
            {
                super(renderer, modelSet);
                this.models = new class_10602((class_3879)new StrawStatueModel(context.method_32167(ModModelLayers.STRAW_STATUE_EARS), false), (class_3879)new StrawStatueModel(context.method_32167(ModModelLayers.STRAW_STATUE_BABY_EARS), false));
            }

            public void method_4181(class_4587 poseStack, class_11659 nodeCollector, int packedLight, class_10055 renderState, float yRot, float xRot) {
                this.field_53213 = (class_572)this.models.method_66533(renderState.field_53457);
                super.method_4181(poseStack, nodeCollector, packedLight, renderState, yRot, xRot);
            }
        });
        this.method_4046((class_3887)new class_972(this, (class_3883)this, context.method_32170(), context.method_64071()){
            private final class_10602<class_572<class_10055>> models;
            {
                super(renderer, modelSet, equipmentAssets);
                this.models = new class_10602((class_3879)new StrawStatueCapeModel(context.method_32167(ModModelLayers.STRAW_STATUE_CAPE)), (class_3879)new StrawStatueCapeModel(context.method_32167(ModModelLayers.STRAW_STATUE_BABY_CAPE)));
            }

            public void method_4177(class_4587 poseStack, class_11659 nodeCollector, int packedLight, class_10055 renderState, float yRot, float xRot) {
                this.field_53206 = (class_572)this.models.method_66533(renderState.field_53457);
                super.method_4177(poseStack, nodeCollector, packedLight, renderState, yRot, xRot);
            }
        });
    }

    private static Map<class_7920, class_10602<StrawStatueModel>> bakeModels(class_5617.class_5618 context) {
        return Maps.newEnumMap(Map.of(class_7920.field_41123, new class_10602((class_3879)new StrawStatueModel(context.method_32167(ModModelLayers.STRAW_STATUE), false), (class_3879)new StrawStatueModel(context.method_32167(ModModelLayers.STRAW_STATUE_BABY), false)), class_7920.field_41122, new class_10602((class_3879)new StrawStatueModel(context.method_32167(ModModelLayers.STRAW_STATUE_SLIM), true), (class_3879)new StrawStatueModel(context.method_32167(ModModelLayers.STRAW_STATUE_BABY_SLIM), true))));
    }

    private void addHumanoidArmorLayer(class_5617.class_5618 context, class_11677<class_5601> armorModelSet, class_11677<class_5601> babyArmorModelSet, final class_7920 modelType) {
        this.method_4046((class_3887)new class_970<class_10055, class_591, StrawStatueModel>(this, (class_3883)this, class_11677.method_72961(armorModelSet, (class_5599)context.method_32170(), modelPart -> new StrawStatueModel((class_630)modelPart, modelType == class_7920.field_41122)), class_11677.method_72961(babyArmorModelSet, (class_5599)context.method_32170(), modelPart -> new StrawStatueModel((class_630)modelPart, modelType == class_7920.field_41122)), context.method_64072()){

            public void submit(class_4587 poseStack, class_11659 nodeCollector, int packedLight, class_10055 renderState, float yRot, float xRot) {
                if (renderState.field_53520.comp_1629() == modelType) {
                    super.method_17157(poseStack, nodeCollector, packedLight, (class_10034)renderState, yRot, xRot);
                }
            }
        });
    }

    protected float getShadowRadius(class_10055 renderState) {
        return super.method_55832((class_10042)renderState) * renderState.field_53454;
    }

    public StrawStatueRenderState createRenderState() {
        return new StrawStatueRenderState();
    }

    public void extractRenderState(ClientStrawStatue strawStatue, class_10055 renderState, float partialTick) {
        super.method_62604((class_11890)strawStatue, renderState, partialTick);
        ((StrawStatueRenderState)renderState).rotX = strawStatue.getPoseX(partialTick);
        ((StrawStatueRenderState)renderState).rotZ = strawStatue.getPoseZ(partialTick);
        ((StrawStatueRenderState)renderState).wiggle = (float)(strawStatue.method_73183().method_8510() - strawStatue.lastHit) + partialTick;
        ((StrawStatueRenderState)renderState).headPose = strawStatue.getHeadPose(partialTick);
        ((StrawStatueRenderState)renderState).bodyPose = strawStatue.getBodyPose(partialTick);
        ((StrawStatueRenderState)renderState).leftArmPose = strawStatue.getLeftArmPose(partialTick);
        ((StrawStatueRenderState)renderState).rightArmPose = strawStatue.getRightArmPose(partialTick);
        ((StrawStatueRenderState)renderState).leftLegPose = strawStatue.getLeftLegPose(partialTick);
        ((StrawStatueRenderState)renderState).rightLegPose = strawStatue.getRightLegPose(partialTick);
        renderState.field_53453 = strawStatue.getScale(partialTick);
    }

    protected void method_4212(class_10055 renderState, class_4587 poseStack, float bodyRot, float scale) {
        poseStack.method_22907((Quaternionfc)class_7833.field_40718.rotationDegrees(180.0f - ((StrawStatueRenderState)renderState).rotZ));
        poseStack.method_22907((Quaternionfc)class_7833.field_40716.rotationDegrees(180.0f - bodyRot));
        poseStack.method_22907((Quaternionfc)class_7833.field_40714.rotationDegrees(180.0f - ((StrawStatueRenderState)renderState).rotX));
        float wiggle = ((StrawStatueRenderState)renderState).wiggle;
        if (wiggle < 5.0f) {
            poseStack.method_22907((Quaternionfc)class_7833.field_40716.rotationDegrees(class_3532.method_15374((float)(wiggle / 1.5f * (float)Math.PI)) * 3.0f));
        }
        if (renderState.field_53455) {
            poseStack.method_46416(0.0f, (renderState.field_53330 + 0.1f) / scale, 0.0f);
            poseStack.method_22907((Quaternionfc)class_7833.field_40718.rotationDegrees(180.0f));
        }
    }
}

