/*
 * Decompiled with CFR 0.152.
 */
package fuzs.strawstatues.world.entity.decoration;

import com.mojang.authlib.GameProfile;
import com.mojang.serialization.Codec;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicOps;
import fuzs.puzzleslib.api.util.v1.CommonHelper;
import fuzs.statuemenus.api.v1.helper.ArmorStandInteractHelper;
import fuzs.statuemenus.api.v1.world.entity.decoration.StatueEntity;
import fuzs.statuemenus.api.v1.world.inventory.data.StatueScreenType;
import fuzs.statuemenus.api.v1.world.inventory.data.StatueStyleOption;
import fuzs.strawstatues.StrawStatues;
import fuzs.strawstatues.init.ModRegistry;
import fuzs.strawstatues.world.inventory.data.StrawStatueScreenTypes;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import net.minecraft.class_11368;
import net.minecraft.class_11372;
import net.minecraft.class_11755;
import net.minecraft.class_11891;
import net.minecraft.class_12079;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1531;
import net.minecraft.class_1538;
import net.minecraft.class_1657;
import net.minecraft.class_1664;
import net.minecraft.class_1799;
import net.minecraft.class_1927;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2379;
import net.minecraft.class_2388;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2509;
import net.minecraft.class_2561;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3917;
import net.minecraft.class_4048;
import net.minecraft.class_4050;
import net.minecraft.class_5712;
import net.minecraft.class_6880;
import net.minecraft.class_7920;
import net.minecraft.class_8103;
import net.minecraft.class_8685;
import net.minecraft.class_9267;
import net.minecraft.class_9296;
import net.minecraft.class_9331;
import net.minecraft.class_9334;
import net.minecraft.class_9473;
import org.jetbrains.annotations.Nullable;

public class StrawStatue
extends class_11891
implements StatueEntity {
    public static final class_2960 STRAW_STATUE_LOCATION = StrawStatues.id("entity/straw_statue");
    public static final class_8685 DEFAULT_SKIN = new class_8685((class_12079.class_12081)new class_12079.class_10726(STRAW_STATUE_LOCATION), null, null, class_7920.field_41123, true);
    public static final class_2379 DEFAULT_ENTITY_POSE = new class_2379(180.0f, 0.0f, 180.0f);
    public static final String SMALL_KEY = "Small";
    public static final String PUSHABLE_KEY = "pushable";
    public static final String DYNAMIC_PROFILE_KEY = "dynamic_profile";
    public static final String SEALED_KEY = "sealed";
    public static final String SKIN_PATCH_KEY = "skin_patch";
    public static final String ARMOR_STAND_POSE_KEY = "Pose";
    public static final String CROUCHING_KEY = "Crouching";
    public static final String ENTITY_POSE_KEY = "EntityRotations";
    public static final class_2940<Boolean> DATA_SMALL = class_2945.method_12791(StrawStatue.class, (class_2941)class_2943.field_13323);
    public static final class_2940<Boolean> DATA_PUSHABLE = class_2945.method_12791(StrawStatue.class, (class_2941)class_2943.field_13323);
    public static final class_2940<Boolean> DATA_DYNAMIC_PROFILE = class_2945.method_12791(StrawStatue.class, (class_2941)class_2943.field_13323);
    public static final class_2940<Boolean> DATA_SEALED = class_2945.method_12791(StrawStatue.class, (class_2941)class_2943.field_13323);
    public static final class_2940<class_8685.class_11892> DATA_SKIN_PATCH = class_2945.method_12791(StrawStatue.class, (class_2941)((class_2941)ModRegistry.SKIN_PATCH_ENTITY_DATA_SERIALIZER.comp_349()));
    public static final class_2940<class_2379> DATA_ENTITY_POSE = class_2945.method_12791(StrawStatue.class, (class_2941)class_2943.field_13316);
    public static final class_2940<class_2379> DATA_HEAD_POSE = class_2945.method_12791(StrawStatue.class, (class_2941)class_2943.field_13316);
    public static final class_2940<class_2379> DATA_BODY_POSE = class_2945.method_12791(StrawStatue.class, (class_2941)class_2943.field_13316);
    public static final class_2940<class_2379> DATA_LEFT_ARM_POSE = class_2945.method_12791(StrawStatue.class, (class_2941)class_2943.field_13316);
    public static final class_2940<class_2379> DATA_RIGHT_ARM_POSE = class_2945.method_12791(StrawStatue.class, (class_2941)class_2943.field_13316);
    public static final class_2940<class_2379> DATA_LEFT_LEG_POSE = class_2945.method_12791(StrawStatue.class, (class_2941)class_2943.field_13316);
    public static final class_2940<class_2379> DATA_RIGHT_LEG_POSE = class_2945.method_12791(StrawStatue.class, (class_2941)class_2943.field_13316);
    @Nullable
    private CompletableFuture<GameProfile> profileLookup;
    public long lastHit;

    public StrawStatue(class_1299<? extends StrawStatue> entityType, class_1937 level) {
        super(entityType, level);
        this.method_5875(true);
        this.method_74877(true);
    }

    protected void method_5693(class_2945.class_9222 builder) {
        super.method_5693(builder);
        builder.method_56912(DATA_SMALL, (Object)false);
        builder.method_56912(DATA_PUSHABLE, (Object)false);
        builder.method_56912(DATA_DYNAMIC_PROFILE, (Object)false);
        builder.method_56912(DATA_SEALED, (Object)false);
        builder.method_56912(DATA_SKIN_PATCH, (Object)class_8685.class_11892.field_63029);
        builder.method_56912(DATA_ENTITY_POSE, (Object)DEFAULT_ENTITY_POSE);
        builder.method_56912(DATA_HEAD_POSE, (Object)class_1531.field_7113);
        builder.method_56912(DATA_BODY_POSE, (Object)class_1531.field_7119);
        builder.method_56912(DATA_LEFT_ARM_POSE, (Object)class_1531.field_7124);
        builder.method_56912(DATA_RIGHT_ARM_POSE, (Object)class_1531.field_7115);
        builder.method_56912(DATA_LEFT_LEG_POSE, (Object)class_1531.field_7121);
        builder.method_56912(DATA_RIGHT_LEG_POSE, (Object)class_1531.field_7117);
    }

    public void method_5652(class_11372 valueOutput) {
        super.method_5652(valueOutput);
        valueOutput.method_71472(SMALL_KEY, this.method_6109());
        valueOutput.method_71472(PUSHABLE_KEY, ((Boolean)this.field_6011.method_12789(DATA_PUSHABLE)).booleanValue());
        valueOutput.method_71472(DYNAMIC_PROFILE_KEY, this.isDynamicProfile());
        valueOutput.method_71472(SEALED_KEY, this.isSealed());
        if (!Objects.equals(this.getSkinPatch(), class_8685.class_11892.field_63029)) {
            valueOutput.method_71468(SKIN_PATCH_KEY, class_8685.class_11892.field_62523.codec(), (Object)this.getSkinPatch());
        }
        valueOutput.method_71468(ARMOR_STAND_POSE_KEY, class_1531.class_11346.field_60361, (Object)this.getArmorStandPose());
        valueOutput.method_71472(CROUCHING_KEY, this.method_18276());
        if (!Objects.equals(this.getEntityPose(), DEFAULT_ENTITY_POSE)) {
            valueOutput.method_71468(ENTITY_POSE_KEY, class_2379.field_57040, (Object)this.getEntityPose());
        }
    }

    public void method_5749(class_11368 valueInput) {
        super.method_5749(valueInput);
        this.setBaby(valueInput.method_71433(SMALL_KEY, false));
        this.setPushable(valueInput.method_71433(PUSHABLE_KEY, false));
        this.setDynamicProfile(valueInput.method_71433(DYNAMIC_PROFILE_KEY, false));
        this.setSealed(valueInput.method_71433(SEALED_KEY, false));
        valueInput.method_71426(SKIN_PATCH_KEY, class_8685.class_11892.field_62523.codec()).ifPresent(this::setSkinPatch);
        valueInput.method_71426(ARMOR_STAND_POSE_KEY, class_1531.class_11346.field_60361).ifPresent(arg_0 -> ((StrawStatue)this).setArmorStandPose(arg_0));
        this.setCrouching(valueInput.method_71433(CROUCHING_KEY, false));
        valueInput.method_71426(ENTITY_POSE_KEY, class_2379.field_57040).ifPresent(this::setEntityPose);
        this.readLegacySaveData(valueInput);
    }

    @Deprecated
    private void readLegacySaveData(class_11368 valueInput) {
        byte modelParts = valueInput.method_71421("ModelParts", (byte)0);
        if (modelParts != 0) {
            this.field_6011.method_12778(field_62514, (Object)modelParts);
        }
        valueInput.method_71426("Owner", class_2487.field_25128).map(compoundTag -> class_9267.method_57236((Dynamic)new Dynamic((DynamicOps)class_2509.field_11560, compoundTag))).map(arg_0 -> ((Codec)class_9296.field_49359).parse(arg_0)).flatMap(dataResult -> dataResult.resultOrPartial(string -> StrawStatues.LOGGER.error("Failed to load profile from straw statue: {}", string))).ifPresent(this::method_74098);
    }

    public void method_18382() {
        if (this.method_5810()) {
            super.method_18382();
        } else {
            double x = this.method_23317();
            double y = this.method_23318();
            double z = this.method_23321();
            super.method_18382();
            this.method_5814(x, y, z);
        }
    }

    public boolean method_5810() {
        return (Boolean)this.field_6011.method_12789(DATA_PUSHABLE) != false && super.method_5810();
    }

    public void setPushable(boolean isPushable) {
        this.field_6011.method_12778(DATA_PUSHABLE, (Object)isPushable);
        if (isPushable) {
            this.method_5875(false);
        }
    }

    public void method_5875(boolean noGravity) {
        super.method_5875(noGravity);
        if (noGravity) {
            this.setPushable(false);
        }
    }

    protected void method_6087(class_1297 entity) {
        if (this.method_5810() && !this.method_5740()) {
            super.method_6087(entity);
        }
    }

    protected void method_6070() {
        if (this.method_5810() && !this.method_5740()) {
            for (class_1297 entity : this.method_73183().method_66349((class_1297)this, this.method_5829())) {
                this.method_6087(entity);
            }
        }
    }

    public void method_6091(class_243 travelVector) {
        if (!this.method_5740()) {
            super.method_6091(travelVector);
        }
    }

    public boolean method_6034() {
        return super.method_6034() && !this.method_5740();
    }

    public boolean method_56991(class_1304 slot) {
        return slot.method_5925() == class_1304.class_1305.field_6177 || slot.method_5925() == class_1304.class_1305.field_6178;
    }

    public class_1269 method_5688(class_1657 player, class_1268 interactionHand) {
        class_1269 interactionResult = super.method_5688(player, interactionHand);
        if (interactionResult.method_23665()) {
            return interactionResult;
        }
        return ArmorStandInteractHelper.openStatueMenu((class_1657)player, (class_1937)this.method_73183(), (class_1268)interactionHand, (class_1309)this, (class_3917)((class_3917)ModRegistry.STRAW_STATUE_MENU_TYPE.comp_349()), (StatueEntity)this);
    }

    public class_4048 method_55694(class_4050 pose) {
        return super.method_55694(pose).method_18383(this.method_17825());
    }

    public void method_5773() {
        super.method_5773();
        if (this.method_73183() instanceof class_3218) {
            this.lookupProfile();
        }
    }

    private void lookupProfile() {
        if (this.profileLookup != null && this.profileLookup.isDone()) {
            try {
                this.method_74098(class_9296.method_73307((GameProfile)this.profileLookup.get()));
                this.profileLookup = null;
            }
            catch (Exception exception) {
                StrawStatues.LOGGER.error("Error when trying to look up profile", (Throwable)exception);
            }
        }
    }

    public void method_74098(class_9296 resolvableProfile) {
        GameProfile oldGameProfile = this.method_74104().method_73313();
        super.method_74098(resolvableProfile);
        class_1937 class_19372 = this.method_73183();
        if (class_19372 instanceof class_3218) {
            class_3218 serverLevel = (class_3218)class_19372;
            if (!Objects.equals(resolvableProfile.method_73313(), oldGameProfile)) {
                this.updateProfile(serverLevel, resolvableProfile);
            }
        }
    }

    private void updateProfile(class_3218 serverLevel, class_9296 resolvableProfile) {
        class_11755 profileResolver = serverLevel.method_8503().method_73550().comp_4624();
        if (this.profileLookup != null) {
            CompletableFuture<GameProfile> completableFuture = this.profileLookup;
            this.profileLookup = null;
            completableFuture.cancel(false);
        }
        if (!Objects.equals(resolvableProfile, field_62519)) {
            this.profileLookup = resolvableProfile.method_73306(profileResolver);
        }
    }

    public boolean isDynamicProfile() {
        return (Boolean)this.field_6011.method_12789(DATA_DYNAMIC_PROFILE);
    }

    public void setDynamicProfile(boolean isDynamic) {
        this.field_6011.method_12778(DATA_DYNAMIC_PROFILE, (Object)isDynamic);
    }

    public boolean isSealed() {
        return (Boolean)this.field_6011.method_12789(DATA_SEALED);
    }

    public void setSealed(boolean isSealed) {
        this.field_6011.method_12778(DATA_SEALED, (Object)isSealed);
    }

    public class_8685.class_11892 getSkinPatch() {
        return (class_8685.class_11892)this.field_6011.method_12789(DATA_SKIN_PATCH);
    }

    public void setSkinPatch(class_8685.class_11892 skinPatch) {
        this.field_6011.method_12778(DATA_SKIN_PATCH, (Object)skinPatch);
    }

    public boolean method_6109() {
        return (Boolean)this.method_5841().method_12789(DATA_SMALL);
    }

    public void setBaby(boolean isBaby) {
        this.method_5841().method_12778(DATA_SMALL, (Object)isBaby);
    }

    public void method_5674(class_2940<?> dataAccessor) {
        if (Objects.equals(DATA_SMALL, dataAccessor)) {
            this.method_18382();
        }
        super.method_5674(dataAccessor);
    }

    public void method_5665(@Nullable class_2561 name) {
        super.method_5665(name);
        this.method_5880(name != null);
    }

    public String getProfileName() {
        return this.method_74104().method_73317().orElseGet(() -> ((GameProfile)this.method_74104().method_73313()).name());
    }

    public void setModelPartShown(class_1664 modelPart, boolean value) {
        byte modelParts = (Byte)this.method_5841().method_12789(field_62514);
        this.field_6011.method_12778(field_62514, (Object)StatueStyleOption.setBit((byte)modelParts, (int)modelPart.method_7430(), (boolean)value));
    }

    public void setCrouching(boolean isCrouching) {
        this.method_18380(isCrouching ? class_4050.field_18081 : class_4050.field_18076);
        this.method_5660(isCrouching);
    }

    public class_2379 getEntityPose() {
        return (class_2379)this.field_6011.method_12789(DATA_ENTITY_POSE);
    }

    public void setEntityPose(class_2379 rotations) {
        this.field_6011.method_12778(DATA_ENTITY_POSE, (Object)rotations);
    }

    public boolean method_64397(class_3218 serverLevel, class_1282 damageSource, float damageAmount) {
        if (!this.method_31481()) {
            if (damageSource.method_48789(class_8103.field_42242)) {
                this.method_5768(serverLevel);
                return false;
            }
            if (!this.method_5679(serverLevel, damageSource) && !this.method_5767()) {
                if (damageSource.method_48789(class_8103.field_42249)) {
                    this.brokenByAnything(serverLevel, damageSource);
                    this.method_5768(serverLevel);
                    return false;
                }
                if (damageSource.method_48789(class_8103.field_42258)) {
                    if (this.method_5809()) {
                        this.causeDamage(serverLevel, damageSource, 0.15f);
                    } else {
                        this.method_5639(5.0f);
                    }
                    return false;
                }
                if (damageSource.method_48789(class_8103.field_42259) && this.method_6032() > 0.5f) {
                    this.causeDamage(serverLevel, damageSource, 4.0f);
                    return false;
                }
                boolean bl = damageSource.method_48789(class_8103.field_46230);
                boolean bl2 = damageSource.method_48789(class_8103.field_46211);
                if (!bl && !bl2) {
                    return false;
                }
                if (damageSource.method_5529() instanceof class_1657 && !((class_1657)damageSource.method_5529()).method_31549().field_7476) {
                    return false;
                }
                if (damageSource.method_5530()) {
                    this.playBrokenSound(serverLevel);
                    this.showBreakingParticles(serverLevel);
                    this.method_5768(serverLevel);
                    return true;
                }
                long gameTime = this.method_73183().method_8510();
                if (gameTime - this.lastHit > 5L && !bl2) {
                    this.method_73183().method_8421((class_1297)this, (byte)32);
                    this.method_32875((class_6880)class_5712.field_28736, damageSource.method_5529());
                    this.lastHit = gameTime;
                    this.field_6008 = 20;
                    this.field_6235 = this.field_6254 = 10;
                } else {
                    this.brokenByPlayer(serverLevel, damageSource);
                    this.showBreakingParticles(serverLevel);
                    this.method_5768(serverLevel);
                }
                return true;
            }
            return false;
        }
        return false;
    }

    public void method_5711(byte id) {
        if (id == 32 && this.method_73183().method_8608()) {
            this.method_73183().method_8486(this.method_23317(), this.method_23318(), this.method_23321(), this.method_6011(this.method_48923().method_48830()), this.method_5634(), 0.3f, 1.0f, false);
            this.lastHit = this.method_73183().method_8510();
        }
        super.method_5711(id);
    }

    private void showBreakingParticles(class_3218 serverLevel) {
        serverLevel.method_65096((class_2394)new class_2388(class_2398.field_11217, class_2246.field_10359.method_9564()), this.method_23317(), this.method_23323(0.67), this.method_23321(), 10, (double)(this.method_17681() / 4.0f), (double)(this.method_17682() / 4.0f), (double)(this.method_17681() / 4.0f), 0.05);
    }

    private void causeDamage(class_3218 serverLevel, class_1282 damageSource, float damageAmount) {
        float f = this.method_6032();
        if ((f -= damageAmount) <= 0.5f) {
            this.brokenByAnything(serverLevel, damageSource);
            this.method_5768(serverLevel);
        } else {
            this.method_6033(f);
            this.method_32875((class_6880)class_5712.field_28736, damageSource.method_5529());
        }
    }

    private void brokenByPlayer(class_3218 serverLevel, class_1282 damageSource) {
        class_1799 itemStack = new class_1799(ModRegistry.STRAW_STATUE_ITEM);
        itemStack.method_57379(class_9334.field_49631, (Object)this.method_5797());
        class_2248.method_9577((class_1937)this.method_73183(), (class_2338)this.method_24515(), (class_1799)itemStack);
        this.brokenByAnything(serverLevel, damageSource);
    }

    private void brokenByAnything(class_3218 serverLevel, class_1282 damageSource) {
        this.playBrokenSound(serverLevel);
        this.method_16080(serverLevel, damageSource);
        for (class_1304 equipmentSlot : class_1304.field_54086) {
            class_1799 itemStack = this.field_56535.method_66660(equipmentSlot, class_1799.field_8037);
            if (itemStack.method_7960()) continue;
            class_2248.method_9577((class_1937)this.method_73183(), (class_2338)this.method_24515().method_10084(), (class_1799)itemStack);
        }
    }

    private void playBrokenSound(class_3218 serverLevel) {
        serverLevel.method_43128(null, this.method_23317(), this.method_23318(), this.method_23321(), this.method_6002(), this.method_5634(), 1.0f, 1.0f);
    }

    protected void method_6031(float yBodyRot) {
        this.field_6220 = this.field_5982;
        this.field_6283 = this.method_36454();
    }

    public void method_5636(float yBodyRot) {
        this.field_6220 = this.field_5982 = yBodyRot;
        this.field_6259 = this.field_6241 = yBodyRot;
    }

    public void method_5847(float yHeadRot) {
        this.field_6220 = this.field_5982 = yHeadRot;
        this.field_6259 = this.field_6241 = yHeadRot;
    }

    public void method_5768(class_3218 level) {
        this.method_5650(class_1297.class_5529.field_26998);
        this.method_32876((class_6880)class_5712.field_37676);
    }

    public boolean method_5659(class_1927 explosion) {
        return !explosion.method_61722() || super.method_5659(explosion);
    }

    public void setHeadPose(class_2379 headPose) {
        this.field_6011.method_12778(DATA_HEAD_POSE, (Object)headPose);
    }

    public void setBodyPose(class_2379 bodyPose) {
        this.field_6011.method_12778(DATA_BODY_POSE, (Object)bodyPose);
    }

    public void setLeftArmPose(class_2379 leftArmPose) {
        this.field_6011.method_12778(DATA_LEFT_ARM_POSE, (Object)leftArmPose);
    }

    public void setRightArmPose(class_2379 rightArmPose) {
        this.field_6011.method_12778(DATA_RIGHT_ARM_POSE, (Object)rightArmPose);
    }

    public void setLeftLegPose(class_2379 leftLegPose) {
        this.field_6011.method_12778(DATA_LEFT_LEG_POSE, (Object)leftLegPose);
    }

    public void setRightLegPose(class_2379 rightLegPose) {
        this.field_6011.method_12778(DATA_RIGHT_LEG_POSE, (Object)rightLegPose);
    }

    public class_2379 getHeadPose() {
        return (class_2379)this.field_6011.method_12789(DATA_HEAD_POSE);
    }

    public class_2379 getBodyPose() {
        return (class_2379)this.field_6011.method_12789(DATA_BODY_POSE);
    }

    public class_2379 getLeftArmPose() {
        return (class_2379)this.field_6011.method_12789(DATA_LEFT_ARM_POSE);
    }

    public class_2379 getRightArmPose() {
        return (class_2379)this.field_6011.method_12789(DATA_RIGHT_ARM_POSE);
    }

    public class_2379 getLeftLegPose() {
        return (class_2379)this.field_6011.method_12789(DATA_LEFT_LEG_POSE);
    }

    public class_2379 getRightLegPose() {
        return (class_2379)this.field_6011.method_12789(DATA_RIGHT_LEG_POSE);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean method_5698(class_1297 entity) {
        if (!(entity instanceof class_1657)) return false;
        class_1657 player = (class_1657)entity;
        if (this.method_73183().method_8505((class_1297)player, this.method_24515())) return false;
        return true;
    }

    public class_1309.class_6823 method_39760() {
        return new class_1309.class_6823(class_3417.field_14965, class_3417.field_14965);
    }

    @Nullable
    protected class_3414 method_6011(class_1282 damageSource) {
        return class_3417.field_14720;
    }

    @Nullable
    protected class_3414 method_6002() {
        return class_3417.field_15037;
    }

    public void method_5800(class_3218 serverLevel, class_1538 lightning) {
    }

    public boolean method_6086() {
        return false;
    }

    public boolean method_6102() {
        return false;
    }

    public class_1799 method_31480() {
        class_1799 itemStack = new class_1799(ModRegistry.STRAW_STATUE_ITEM);
        if (CommonHelper.hasControlDown()) {
            if (!Objects.equals(this.method_74104(), field_62519)) {
                itemStack.method_57379(class_9334.field_49617, (Object)this.method_74104());
            }
            if (!Objects.equals(this.getSkinPatch(), class_8685.class_11892.field_63029)) {
                itemStack.method_57379((class_9331)ModRegistry.SKIN_PATCH_DATA_COMPONENT_TYPE.comp_349(), (Object)this.getSkinPatch());
            }
        }
        return itemStack;
    }

    @Nullable
    public <T> T method_58694(class_9331<? extends T> component) {
        if (component == ModRegistry.SKIN_PATCH_DATA_COMPONENT_TYPE.comp_349()) {
            return (T)StrawStatue.method_66651(component, (Object)this.getSkinPatch());
        }
        return (T)super.method_58694(component);
    }

    protected void method_66649(class_9473 componentGetter) {
        this.method_66650(componentGetter, (class_9331)ModRegistry.SKIN_PATCH_DATA_COMPONENT_TYPE.comp_349());
        super.method_66649(componentGetter);
    }

    protected <T> boolean method_66654(class_9331<T> component, T value) {
        if (component == ModRegistry.SKIN_PATCH_DATA_COMPONENT_TYPE.comp_349()) {
            this.setSkinPatch((class_8685.class_11892)StrawStatue.method_66651((class_9331)((class_9331)ModRegistry.SKIN_PATCH_DATA_COMPONENT_TYPE.comp_349()), value));
            return true;
        }
        return super.method_66654(component, value);
    }

    public List<StatueScreenType> getScreenTypes() {
        return StrawStatueScreenTypes.TYPES;
    }

    public StatueScreenType getDefaultScreenType() {
        return StrawStatueScreenTypes.ROTATIONS;
    }

    public Runnable setupInInventoryRendering(class_1309 livingEntity) {
        class_2379 rotations = this.getEntityPose();
        this.setEntityPose(DEFAULT_ENTITY_POSE);
        return () -> this.setEntityPose(rotations);
    }
}

