/*
 * Decompiled with CFR 0.152.
 */
package fuzs.strawstatues;

import fuzs.puzzleslib.api.core.v1.ModConstructor;
import fuzs.puzzleslib.api.core.v1.context.EntityAttributesContext;
import fuzs.puzzleslib.api.core.v1.context.PayloadTypesContext;
import fuzs.puzzleslib.api.core.v1.utility.ResourceLocationHelper;
import fuzs.puzzleslib.api.event.v1.BuildCreativeModeTabContentsCallback;
import fuzs.statuemenus.api.v1.world.entity.decoration.StatueEntity;
import fuzs.statuemenus.api.v1.world.inventory.data.StatuePose;
import fuzs.strawstatues.init.ModRegistry;
import fuzs.strawstatues.network.client.ServerboundStrawStatueModelPartMessage;
import fuzs.strawstatues.network.client.ServerboundStrawStatueProfileMessage;
import fuzs.strawstatues.network.client.ServerboundStrawStatueScaleMessage;
import fuzs.strawstatues.network.client.ServerboundStrawStatueSkinPatchMessage;
import fuzs.strawstatues.world.entity.decoration.StrawStatue;
import fuzs.strawstatues.world.inventory.data.StrawStatueStyleOptions;
import java.util.function.Consumer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.dispenser.BlockSource;
import net.minecraft.core.dispenser.DefaultDispenseItemBehavior;
import net.minecraft.core.dispenser.DispenseItemBehavior;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.decoration.ArmorStand;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.CreativeModeTabs;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.DispenserBlock;
import net.minecraft.world.level.block.state.properties.Property;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StrawStatues
implements ModConstructor {
    public static final String MOD_ID = "strawstatues";
    public static final String MOD_NAME = "Straw Statues";
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"Straw Statues");

    public void onConstructMod() {
        ModRegistry.bootstrap();
        StrawStatues.registerEventHandlers();
    }

    private static void registerEventHandlers() {
        BuildCreativeModeTabContentsCallback.buildCreativeModeTabContents((ResourceKey)CreativeModeTabs.FUNCTIONAL_BLOCKS).register(StrawStatues::onBuildCreativeModeTabContents);
        BuildCreativeModeTabContentsCallback.buildCreativeModeTabContents((ResourceKey)CreativeModeTabs.REDSTONE_BLOCKS).register(StrawStatues::onBuildCreativeModeTabContents);
    }

    private static void onBuildCreativeModeTabContents(CreativeModeTab creativeModeTab, CreativeModeTab.ItemDisplayParameters itemDisplayParameters, CreativeModeTab.Output output) {
        output.accept((ItemLike)ModRegistry.STRAW_STATUE_ITEM.value());
    }

    public void onCommonSetup() {
        StrawStatueStyleOptions.bootstrap();
        DispenserBlock.registerBehavior((ItemLike)((ItemLike)ModRegistry.STRAW_STATUE_ITEM.value()), (DispenseItemBehavior)new DefaultDispenseItemBehavior(this){

            public ItemStack execute(BlockSource blockSource, ItemStack itemStack) {
                Direction direction = (Direction)blockSource.state().getValue((Property)DispenserBlock.FACING);
                BlockPos blockPos = blockSource.pos().relative(direction);
                ServerLevel serverLevel = blockSource.level();
                Consumer consumer = EntityType.appendDefaultStackConfig(strawStatue -> {
                    strawStatue.setYRot(direction.toYRot());
                    StatuePose.randomValue().applyToEntity((StatueEntity)strawStatue);
                }, (Level)serverLevel, (ItemStack)itemStack, null);
                StrawStatue strawStatue2 = (StrawStatue)((EntityType)ModRegistry.STRAW_STATUE_ENTITY_TYPE.value()).spawn(serverLevel, consumer, blockPos, EntitySpawnReason.DISPENSER, false, false);
                if (strawStatue2 != null) {
                    itemStack.shrink(1);
                }
                return itemStack;
            }
        });
    }

    public void onRegisterPayloadTypes(PayloadTypesContext context) {
        context.playToServer(ServerboundStrawStatueModelPartMessage.class, ServerboundStrawStatueModelPartMessage.STREAM_CODEC);
        context.playToServer(ServerboundStrawStatueProfileMessage.class, ServerboundStrawStatueProfileMessage.STREAM_CODEC);
        context.playToServer(ServerboundStrawStatueScaleMessage.class, ServerboundStrawStatueScaleMessage.STREAM_CODEC);
        context.playToServer(ServerboundStrawStatueSkinPatchMessage.class, ServerboundStrawStatueSkinPatchMessage.STREAM_CODEC);
    }

    public void onRegisterEntityAttributes(EntityAttributesContext context) {
        context.registerAttributes((EntityType)ModRegistry.STRAW_STATUE_ENTITY_TYPE.value(), ArmorStand.createAttributes());
    }

    public static ResourceLocation id(String path) {
        return ResourceLocationHelper.fromNamespaceAndPath((String)MOD_ID, (String)path);
    }
}

