/*
 * Decompiled with CFR 0.152.
 */
package fuzs.strawstatues.client;

import fuzs.puzzleslib.api.client.core.v1.ClientModConstructor;
import fuzs.puzzleslib.api.client.core.v1.context.EntityRenderersContext;
import fuzs.puzzleslib.api.client.core.v1.context.LayerDefinitionsContext;
import fuzs.puzzleslib.api.client.core.v1.context.MenuScreensContext;
import fuzs.puzzleslib.api.client.gui.v2.tooltip.ItemTooltipRegistry;
import fuzs.statuemenus.api.v1.client.gui.screens.StatueRotationsScreen;
import fuzs.statuemenus.api.v1.client.gui.screens.StatueScreenFactory;
import fuzs.statuemenus.api.v1.client.gui.screens.StatueStyleScreen;
import fuzs.statuemenus.api.v1.helper.ArmorStandInteractHelper;
import fuzs.statuemenus.api.v1.world.inventory.StatueMenu;
import fuzs.statuemenus.api.v1.world.inventory.data.PosePartMutator;
import fuzs.statuemenus.api.v1.world.inventory.data.StatuePose;
import fuzs.statuemenus.api.v1.world.inventory.data.StatueScreenType;
import fuzs.statuemenus.api.v1.world.inventory.data.StatueStyleOption;
import fuzs.strawstatues.client.entity.ClientStrawStatue;
import fuzs.strawstatues.client.gui.screens.StrawStatueModelPartsScreen;
import fuzs.strawstatues.client.gui.screens.StrawStatuePositionScreen;
import fuzs.strawstatues.client.gui.screens.StrawStatueTexturesScreen;
import fuzs.strawstatues.client.model.geom.ModModelLayers;
import fuzs.strawstatues.init.ModRegistry;
import fuzs.strawstatues.services.ClientAbstractions;
import fuzs.strawstatues.world.entity.decoration.StrawStatue;
import fuzs.strawstatues.world.inventory.data.StrawStatuePosePartMutators;
import fuzs.strawstatues.world.inventory.data.StrawStatueScreenTypes;
import fuzs.strawstatues.world.inventory.data.StrawStatueStyleOptions;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.PlayerCapeModel;
import net.minecraft.client.model.PlayerEarsModel;
import net.minecraft.client.model.PlayerModel;
import net.minecraft.client.model.geom.LayerDefinitions;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.resources.model.EquipmentAssetManager;
import net.minecraft.client.resources.model.EquipmentClientInfo;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.PlayerModelPart;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.equipment.Equippable;

public class StrawStatuesClient
implements ClientModConstructor {
    public void onClientSetup() {
        ItemTooltipRegistry.ITEM.registerItemTooltip((Object)((Item)ModRegistry.STRAW_STATUE_ITEM.value()), ArmorStandInteractHelper.getArmorStandHoverText());
        StatueScreenFactory.register((StatueScreenType)StrawStatueScreenTypes.MODEL_PARTS, StrawStatueModelPartsScreen::new);
        StatueScreenFactory.register((StatueScreenType)StrawStatueScreenTypes.POSITION, StrawStatuePositionScreen::new);
        StatueScreenFactory.register((StatueScreenType)StrawStatueScreenTypes.TEXTURES, StrawStatueTexturesScreen::new);
        StatueScreenFactory.register((StatueScreenType)StrawStatueScreenTypes.ROTATIONS, (holder, inventory, component, dataSyncHandler) -> new StatueRotationsScreen(this, holder, inventory, component, dataSyncHandler){

            public List<PosePartMutator> getPosePartMutators() {
                return StrawStatuePosePartMutators.TYPES;
            }

            protected StatuePose setupRandomPose(StatuePose statuePose) {
                return statuePose;
            }

            protected boolean isPosePartMutatorActive(PosePartMutator posePartMutator, LivingEntity livingEntity) {
                if (posePartMutator == StrawStatuePosePartMutators.CAPE) {
                    ClientStrawStatue strawStatue;
                    if (livingEntity instanceof ClientStrawStatue && (strawStatue = (ClientStrawStatue)livingEntity).isModelPartShown(PlayerModelPart.CAPE) && strawStatue.getSkin().cape() != null) {
                        ItemStack itemStack = livingEntity.getItemBySlot(EquipmentSlot.CHEST);
                        return !this.hasLayer(itemStack, EquipmentClientInfo.LayerType.WINGS);
                    }
                    return false;
                }
                return super.isPosePartMutatorActive(posePartMutator, livingEntity);
            }

            private boolean hasLayer(ItemStack itemStack, EquipmentClientInfo.LayerType layer) {
                Equippable equippable = (Equippable)itemStack.get(DataComponents.EQUIPPABLE);
                if (equippable != null && !equippable.assetId().isEmpty()) {
                    EquipmentAssetManager equipmentAssets = Minecraft.getInstance().getEntityRenderDispatcher().equipmentAssets;
                    EquipmentClientInfo equipmentClientInfo = equipmentAssets.get((ResourceKey)equippable.assetId().get());
                    return !equipmentClientInfo.getLayers(layer).isEmpty();
                }
                return false;
            }

            public StatueScreenType getScreenType() {
                return StrawStatueScreenTypes.ROTATIONS;
            }
        });
        StatueScreenFactory.register((StatueScreenType)StrawStatueScreenTypes.STYLE, (holder, inventory, component, dataSyncHandler) -> new StatueStyleScreen<StrawStatue>(this, holder, inventory, component, dataSyncHandler){

            protected List<StatueStyleOption<? super StrawStatue>> getStyleOptions() {
                return StrawStatueStyleOptions.TYPES;
            }

            public StatueScreenType getScreenType() {
                return StrawStatueScreenTypes.STYLE;
            }
        });
    }

    public void onRegisterMenuScreens(MenuScreensContext context) {
        context.registerMenuScreen((MenuType)ModRegistry.STRAW_STATUE_MENU_TYPE.value(), (menu, inventory, component) -> StatueScreenFactory.createLastScreenType((StatueMenu)menu, (Inventory)inventory, (Component)component));
    }

    public void onRegisterEntityRenderers(EntityRenderersContext context) {
        context.registerEntityRenderer((EntityType)ModRegistry.STRAW_STATUE_ENTITY_TYPE.value(), ClientAbstractions.INSTANCE::createStrawStatueRenderer);
    }

    public void onRegisterLayerDefinitions(LayerDefinitionsContext context) {
        context.registerLayerDefinition(ModModelLayers.STRAW_STATUE, () -> LayerDefinition.create((MeshDefinition)PlayerModel.createMesh((CubeDeformation)CubeDeformation.NONE, (boolean)false), (int)64, (int)64));
        context.registerArmorDefinition(ModModelLayers.STRAW_STATUE_ARMOR, PlayerModel.createArmorMeshSet((CubeDeformation)LayerDefinitions.INNER_ARMOR_DEFORMATION, (CubeDeformation)LayerDefinitions.OUTER_ARMOR_DEFORMATION).map(meshDefinition -> LayerDefinition.create((MeshDefinition)meshDefinition, (int)64, (int)32)));
        context.registerLayerDefinition(ModModelLayers.STRAW_STATUE_SLIM, () -> LayerDefinition.create((MeshDefinition)PlayerModel.createMesh((CubeDeformation)CubeDeformation.NONE, (boolean)true), (int)64, (int)64));
        context.registerArmorDefinition(ModModelLayers.STRAW_STATUE_SLIM_ARMOR, PlayerModel.createArmorMeshSet((CubeDeformation)LayerDefinitions.INNER_ARMOR_DEFORMATION, (CubeDeformation)LayerDefinitions.OUTER_ARMOR_DEFORMATION).map(meshDefinition -> LayerDefinition.create((MeshDefinition)meshDefinition, (int)64, (int)32)));
        context.registerLayerDefinition(ModModelLayers.STRAW_STATUE_CAPE, PlayerCapeModel::createCapeLayer);
        context.registerLayerDefinition(ModModelLayers.STRAW_STATUE_EARS, PlayerEarsModel::createEarsLayer);
        context.registerLayerDefinition(ModModelLayers.STRAW_STATUE_BABY, () -> LayerDefinition.create((MeshDefinition)PlayerModel.createMesh((CubeDeformation)CubeDeformation.NONE, (boolean)false), (int)64, (int)64).apply(HumanoidModel.BABY_TRANSFORMER));
        context.registerArmorDefinition(ModModelLayers.STRAW_STATUE_BABY_ARMOR, PlayerModel.createArmorMeshSet((CubeDeformation)LayerDefinitions.INNER_ARMOR_DEFORMATION, (CubeDeformation)LayerDefinitions.OUTER_ARMOR_DEFORMATION).map(meshDefinition -> LayerDefinition.create((MeshDefinition)meshDefinition, (int)64, (int)32)).map(layerDefinition -> layerDefinition.apply(HumanoidModel.BABY_TRANSFORMER)));
        context.registerLayerDefinition(ModModelLayers.STRAW_STATUE_BABY_SLIM, () -> LayerDefinition.create((MeshDefinition)PlayerModel.createMesh((CubeDeformation)CubeDeformation.NONE, (boolean)true), (int)64, (int)64).apply(HumanoidModel.BABY_TRANSFORMER));
        context.registerArmorDefinition(ModModelLayers.STRAW_STATUE_BABY_SLIM_ARMOR, PlayerModel.createArmorMeshSet((CubeDeformation)LayerDefinitions.INNER_ARMOR_DEFORMATION, (CubeDeformation)LayerDefinitions.OUTER_ARMOR_DEFORMATION).map(meshDefinition -> LayerDefinition.create((MeshDefinition)meshDefinition, (int)64, (int)32)).map(layerDefinition -> layerDefinition.apply(HumanoidModel.BABY_TRANSFORMER)));
        context.registerLayerDefinition(ModModelLayers.STRAW_STATUE_BABY_CAPE, () -> PlayerCapeModel.createCapeLayer().apply(HumanoidModel.BABY_TRANSFORMER));
        context.registerLayerDefinition(ModModelLayers.STRAW_STATUE_BABY_EARS, () -> PlayerEarsModel.createEarsLayer().apply(HumanoidModel.BABY_TRANSFORMER));
    }
}

