/*
 * Decompiled with CFR 0.152.
 */
package fuzs.strawstatues.client.entity;

import fuzs.strawstatues.StrawStatues;
import fuzs.strawstatues.client.gui.screens.StrawStatueModelPartsScreen;
import fuzs.strawstatues.world.entity.decoration.StrawStatue;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.ClientAvatarEntity;
import net.minecraft.client.entity.ClientAvatarState;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.PlayerSkinRenderCache;
import net.minecraft.core.Rotations;
import net.minecraft.network.chat.Component;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.animal.Parrot;
import net.minecraft.world.entity.decoration.ArmorStand;
import net.minecraft.world.entity.player.PlayerSkin;
import net.minecraft.world.item.component.ResolvableProfile;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

public class ClientStrawStatue
extends StrawStatue
implements ClientAvatarEntity {
    private final ClientAvatarState avatarState = new ClientAvatarState();
    @Nullable
    private CompletableFuture<Optional<PlayerSkin>> skinLookup;
    private PlayerSkin skin = DEFAULT_SKIN;
    private boolean showExtraEars;
    private final PlayerSkinRenderCache skinRenderCache;
    private float oldScale = 1.0f;
    private Rotations oldEntityPose = DEFAULT_ENTITY_POSE;
    private Rotations oldHeadPose = ArmorStand.DEFAULT_HEAD_POSE;
    private Rotations oldBodyPose = ArmorStand.DEFAULT_BODY_POSE;
    private Rotations oldLeftArmPose = ArmorStand.DEFAULT_LEFT_ARM_POSE;
    private Rotations oldRightArmPose = ArmorStand.DEFAULT_RIGHT_ARM_POSE;
    private Rotations oldLeftLegPose = ArmorStand.DEFAULT_LEFT_LEG_POSE;
    private Rotations oldRightLegPose = ArmorStand.DEFAULT_RIGHT_LEG_POSE;

    public ClientStrawStatue(EntityType<? extends StrawStatue> entityType, Level level, PlayerSkinRenderCache playerSkinRenderCache) {
        super(entityType, level);
        this.skinRenderCache = playerSkinRenderCache;
    }

    @Override
    public void tick() {
        super.tick();
        if (this.level().isClientSide()) {
            this.oldScale = this.getScale();
            this.oldEntityPose = this.getEntityPose();
            this.oldHeadPose = this.getHeadPose();
            this.oldBodyPose = this.getBodyPose();
            this.oldLeftArmPose = this.getLeftArmPose();
            this.oldRightArmPose = this.getRightArmPose();
            this.oldLeftLegPose = this.getLeftLegPose();
            this.oldRightLegPose = this.getRightLegPose();
            this.avatarState.tick(this.position(), this.getDeltaMovement());
            this.lookupSkin();
        }
    }

    private void lookupSkin() {
        if (this.skinLookup != null && this.skinLookup.isDone()) {
            try {
                this.skinLookup.get().ifPresent(this::setSkin);
                this.skinLookup = null;
            }
            catch (Exception exception) {
                StrawStatues.LOGGER.error("Error when trying to look up skin", (Throwable)exception);
            }
        }
    }

    @Override
    public void onSyncedDataUpdated(EntityDataAccessor<?> dataAccessor) {
        super.onSyncedDataUpdated(dataAccessor);
        if (this.level().isClientSide() && (Objects.equals(dataAccessor, DATA_PROFILE) || Objects.equals(dataAccessor, DATA_DYNAMIC_PROFILE))) {
            this.updateProfile();
        }
    }

    private void updateProfile() {
        this.updateSkin();
        Screen screen = Minecraft.getInstance().screen;
        if (screen instanceof StrawStatueModelPartsScreen) {
            StrawStatueModelPartsScreen screen2 = (StrawStatueModelPartsScreen)screen;
            screen2.applyNameValue();
        }
    }

    private void updateSkin() {
        if (this.skinLookup != null) {
            CompletableFuture<Optional<PlayerSkin>> completableFuture = this.skinLookup;
            this.skinLookup = null;
            completableFuture.cancel(false);
        }
        if (Objects.equals(this.getProfile(), DEFAULT_PROFILE)) {
            this.setSkin(DEFAULT_SKIN);
        } else {
            this.skinLookup = this.skinRenderCache.lookup(this.getSkinProfile()).thenApply(optional -> optional.map(PlayerSkinRenderCache.RenderInfo::playerSkin));
            this.showExtraEars = Objects.equals("deadmau5", this.getProfileName());
        }
    }

    private ResolvableProfile getSkinProfile() {
        return this.isDynamicProfile() ? ResolvableProfile.createUnresolved((String)this.getProfileName()) : this.getProfile();
    }

    public float getScale(float partialTick) {
        return Mth.lerp((float)partialTick, (float)this.oldScale, (float)this.getScale());
    }

    public float getPoseX(float partialTick) {
        return Mth.rotLerp((float)partialTick, (float)this.oldEntityPose.x(), (float)this.getEntityPose().x());
    }

    public float getPoseZ(float partialTick) {
        return Mth.rotLerp((float)partialTick, (float)this.oldEntityPose.z(), (float)this.getEntityPose().z());
    }

    public Rotations getHeadPose(float partialTick) {
        return ClientStrawStatue.lerpRotations(partialTick, this.oldHeadPose, this.getHeadPose());
    }

    public Rotations getBodyPose(float partialTick) {
        return ClientStrawStatue.lerpRotations(partialTick, this.oldBodyPose, this.getBodyPose());
    }

    public Rotations getLeftArmPose(float partialTick) {
        return ClientStrawStatue.lerpRotations(partialTick, this.oldLeftArmPose, this.getLeftArmPose());
    }

    public Rotations getRightArmPose(float partialTick) {
        return ClientStrawStatue.lerpRotations(partialTick, this.oldRightArmPose, this.getRightArmPose());
    }

    public Rotations getLeftLegPose(float partialTick) {
        return ClientStrawStatue.lerpRotations(partialTick, this.oldLeftLegPose, this.getLeftLegPose());
    }

    public Rotations getRightLegPose(float partialTick) {
        return ClientStrawStatue.lerpRotations(partialTick, this.oldRightLegPose, this.getRightLegPose());
    }

    private static Rotations lerpRotations(float partialTick, Rotations oldRotations, Rotations newRotations) {
        float x = Mth.rotLerp((float)partialTick, (float)oldRotations.x(), (float)newRotations.x());
        float y = Mth.rotLerp((float)partialTick, (float)oldRotations.y(), (float)newRotations.y());
        float z = Mth.rotLerp((float)partialTick, (float)oldRotations.z(), (float)newRotations.z());
        return new Rotations(x, y, z);
    }

    public ClientAvatarState avatarState() {
        return this.avatarState;
    }

    public PlayerSkin getSkin() {
        return this.skin.with(this.getSkinPatch());
    }

    private void setSkin(PlayerSkin skin) {
        this.skin = skin;
    }

    @Nullable
    public Component belowNameDisplay() {
        return this.getDescription();
    }

    @Nullable
    public Parrot.Variant getParrotVariantOnShoulder(boolean left) {
        return null;
    }

    public boolean showExtraEars() {
        return this.showExtraEars;
    }
}

