/*
 * Decompiled with CFR 0.152.
 */
package fuzs.strawstatues.client.gui.screens;

import fuzs.puzzleslib.api.client.gui.v2.components.SpritelessImageButton;
import fuzs.puzzleslib.api.network.v4.MessageSender;
import fuzs.puzzleslib.api.network.v4.message.Message;
import fuzs.statuemenus.api.v1.client.gui.screens.AbstractStatueScreen;
import fuzs.statuemenus.api.v1.client.gui.screens.StatuePositionScreen;
import fuzs.statuemenus.api.v1.client.gui.screens.StatueWidgetsScreen;
import fuzs.statuemenus.api.v1.network.client.data.DataSyncHandler;
import fuzs.statuemenus.api.v1.world.inventory.StatueHolder;
import fuzs.statuemenus.api.v1.world.inventory.data.StatueScreenType;
import fuzs.strawstatues.network.client.ServerboundStrawStatueScaleMessage;
import fuzs.strawstatues.network.client.ServerboundStrawStatueSkinPatchMessage;
import fuzs.strawstatues.world.entity.decoration.StrawStatue;
import fuzs.strawstatues.world.inventory.data.StrawStatueScreenTypes;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalDouble;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.input.KeyEvent;
import net.minecraft.core.ClientAsset;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.ARGB;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.PlayerSkin;

public class StrawStatueTexturesScreen
extends StatuePositionScreen {
    public static final Component SKIN_TEXTURE_COMPONENT = Component.translatable((String)StrawStatueScreenTypes.TEXTURES.id().toLanguageKey("screen", "texture.skin"));
    public static final Component CAPE_TEXTURE_COMPONENT = Component.translatable((String)StrawStatueScreenTypes.TEXTURES.id().toLanguageKey("screen", "texture.cape"));
    public static final Component ELYTRA_TEXTURE_COMPONENT = Component.translatable((String)StrawStatueScreenTypes.TEXTURES.id().toLanguageKey("screen", "texture.elytra"));
    public static final Component ROTATION_X_COMPONENT = Component.translatable((String)StrawStatueScreenTypes.TEXTURES.id().toLanguageKey("screen", "rotation.x"));
    public static final Component ROTATION_Y_COMPONENT = Component.translatable((String)StrawStatueScreenTypes.TEXTURES.id().toLanguageKey("screen", "rotation.y"));
    public static final Component ROTATION_Z_COMPONENT = Component.translatable((String)StrawStatueScreenTypes.TEXTURES.id().toLanguageKey("screen", "rotation.z"));
    protected static final StatueWidgetsScreen.ArmorStandWidgetFactory<StrawStatueTexturesScreen> SKIN_TEXTURE_WIDGET_FACTORY = (screen, livingEntity) -> {
        StrawStatueTexturesScreen strawStatueTexturesScreen = screen;
        Objects.requireNonNull(strawStatueTexturesScreen);
        return strawStatueTexturesScreen.new TextureWidget(SKIN_TEXTURE_COMPONENT, ServerboundStrawStatueSkinPatchMessage.DataType.SKIN);
    };
    protected static final StatueWidgetsScreen.ArmorStandWidgetFactory<StrawStatueTexturesScreen> CAPE_TEXTURE_WIDGET_FACTORY = (screen, livingEntity) -> {
        StrawStatueTexturesScreen strawStatueTexturesScreen = screen;
        Objects.requireNonNull(strawStatueTexturesScreen);
        return strawStatueTexturesScreen.new TextureWidget(CAPE_TEXTURE_COMPONENT, ServerboundStrawStatueSkinPatchMessage.DataType.CAPE);
    };
    protected static final StatueWidgetsScreen.ArmorStandWidgetFactory<StrawStatueTexturesScreen> ELYTRA_TEXTURE_WIDGET_FACTORY = (screen, livingEntity) -> {
        StrawStatueTexturesScreen strawStatueTexturesScreen = screen;
        Objects.requireNonNull(strawStatueTexturesScreen);
        return strawStatueTexturesScreen.new TextureWidget(ELYTRA_TEXTURE_COMPONENT, ServerboundStrawStatueSkinPatchMessage.DataType.ELYTRA);
    };
    protected static final StatueWidgetsScreen.ArmorStandWidgetFactory<StrawStatueTexturesScreen> ROTATION_X_WIDGET_FACTORY = (screen, livingEntity) -> {
        StrawStatueTexturesScreen strawStatueTexturesScreen = screen;
        Objects.requireNonNull(strawStatueTexturesScreen);
        return new CustomRotationWidget(strawStatueTexturesScreen, ROTATION_X_COMPONENT, (StrawStatue)((Object)livingEntity), ServerboundStrawStatueScaleMessage.ValueAccessor.ROTATION_X);
    };
    protected static final StatueWidgetsScreen.ArmorStandWidgetFactory<StrawStatueTexturesScreen> ROTATION_Y_WIDGET_FACTORY = (screen, livingEntity) -> {
        StrawStatueTexturesScreen strawStatueTexturesScreen = screen;
        Objects.requireNonNull(strawStatueTexturesScreen);
        return new StatuePositionScreen.RotationWidget((StatuePositionScreen)strawStatueTexturesScreen, ROTATION_Y_COMPONENT, () -> ((LivingEntity)livingEntity).getYRot(), arg_0 -> ((DataSyncHandler)screen.dataSyncHandler).sendRotation(arg_0));
    };
    protected static final StatueWidgetsScreen.ArmorStandWidgetFactory<StrawStatueTexturesScreen> ROTATION_Z_WIDGET_FACTORY = (screen, livingEntity) -> {
        StrawStatueTexturesScreen strawStatueTexturesScreen = screen;
        Objects.requireNonNull(strawStatueTexturesScreen);
        return new CustomRotationWidget(strawStatueTexturesScreen, ROTATION_Z_COMPONENT, (StrawStatue)((Object)livingEntity), ServerboundStrawStatueScaleMessage.ValueAccessor.ROTATION_Z);
    };

    public StrawStatueTexturesScreen(StatueHolder statueHolder, Inventory inventory, Component component, DataSyncHandler dataSyncHandler) {
        super(statueHolder, inventory, component, dataSyncHandler);
    }

    protected List<StatueWidgetsScreen.ArmorStandWidget> buildWidgets(LivingEntity livingEntity) {
        return StrawStatueTexturesScreen.buildWidgets((StatueWidgetsScreen)this, (LivingEntity)livingEntity, List.of(ROTATION_X_WIDGET_FACTORY, ROTATION_Y_WIDGET_FACTORY, ROTATION_Z_WIDGET_FACTORY, SKIN_TEXTURE_WIDGET_FACTORY, CAPE_TEXTURE_WIDGET_FACTORY, ELYTRA_TEXTURE_WIDGET_FACTORY));
    }

    public StatueScreenType getScreenType() {
        return StrawStatueScreenTypes.TEXTURES;
    }

    protected class CustomRotationWidget
    extends StatuePositionScreen.RotationWidget {
        private final ServerboundStrawStatueScaleMessage.ValueAccessor valueAccessor;

        public CustomRotationWidget(StrawStatueTexturesScreen this$0, Component title, StrawStatue strawStatue, ServerboundStrawStatueScaleMessage.ValueAccessor valueAccessor) {
            super((StatuePositionScreen)this$0, title, () -> valueAccessor.getRotationsComponent(strawStatue.getEntityPose()), value -> strawStatue.setEntityPose(valueAccessor.setRotationsComponent(strawStatue.getEntityPose(), value.floatValue())));
            this.valueAccessor = valueAccessor;
        }

        protected OptionalDouble getDefaultValue() {
            return OptionalDouble.of(this.valueAccessor.getRotationsComponent(StrawStatue.DEFAULT_ENTITY_POSE) / 360.0f);
        }

        protected double getCurrentValue() {
            return this.valueGetter.getAsDouble() / 360.0;
        }

        protected void setNewValue(double newValue) {
            this.valueSetter.accept(Float.valueOf((float)(newValue * 360.0)));
        }

        protected void applyClientValue(double newValue) {
            MessageSender.broadcast((Message)new ServerboundStrawStatueScaleMessage(this.valueAccessor, (float)(newValue * 360.0)));
        }
    }

    private class TextureWidget
    extends StatueWidgetsScreen.ArmorStandWidget {
        private final ServerboundStrawStatueSkinPatchMessage.DataType dataType;
        private EditBox editBox;

        public TextureWidget(Component component, ServerboundStrawStatueSkinPatchMessage.DataType dataType) {
            super((StatueWidgetsScreen)StrawStatueTexturesScreen.this, component);
            this.dataType = dataType;
        }

        public void init(int posX, int posY) {
            super.init(posX, posY);
            AbstractWidget checkmarkButton = (AbstractWidget)this.addRenderableWidget((GuiEventListener)new SpritelessImageButton(posX + 174, posY + 1, 20, 20, 212, 0, AbstractStatueScreen.getArmorStandWidgetsLocation(), button -> {
                ResourceLocation resourceLocation = ResourceLocation.tryParse((String)this.editBox.getValue());
                if (resourceLocation != null) {
                    Optional<Object> resourceTexture = resourceLocation.getPath().isEmpty() ? Optional.empty() : Optional.of(new ClientAsset.ResourceTexture(resourceLocation));
                    MessageSender.broadcast((Message)new ServerboundStrawStatueSkinPatchMessage(this.dataType, resourceTexture));
                } else {
                    button.active = false;
                }
            }));
            checkmarkButton.setTooltip(Tooltip.create((Component)StatueWidgetsScreen.SAVE_COMPONENT));
            this.editBox = new EditBox(this, StrawStatueTexturesScreen.this.font, posX + 77, posY, 91, 22, StrawStatueTexturesScreen.this.getHolder().getEntity().getType().getDescription()){

                public boolean keyPressed(KeyEvent event) {
                    return super.keyPressed(event) || this.canConsumeInput();
                }
            };
            this.editBox.setMaxLength(256);
            this.editBox.setResponder(string -> {
                ResourceLocation resourceLocation = ResourceLocation.tryParse((String)string);
                if (resourceLocation != null) {
                    checkmarkButton.active = true;
                    this.editBox.setTextColor(-2039584);
                } else {
                    checkmarkButton.active = false;
                    this.editBox.setTextColor(ARGB.opaque((int)ChatFormatting.RED.getColor()));
                }
                if (resourceLocation != null && !resourceLocation.getPath().isEmpty()) {
                    String texturePath = new ClientAsset.ResourceTexture(resourceLocation).texturePath().toString();
                    this.editBox.setTooltip(Tooltip.create((Component)Component.literal((String)texturePath)));
                } else {
                    this.editBox.setTooltip(null);
                }
            });
            PlayerSkin.Patch skinPatch = ((StrawStatue)StrawStatueTexturesScreen.this.getHolder().getEntity()).getSkinPatch();
            this.editBox.setValue(this.dataType.getTexturePath(skinPatch).map(ClientAsset.ResourceTexture::id).map(ResourceLocation::toString).orElse(""));
            this.addRenderableWidget((GuiEventListener)this.editBox);
        }
    }
}

