/*
 * Decompiled with CFR 0.152.
 */
package fuzs.strawstatues.client.renderer.entity;

import com.google.common.collect.Maps;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import fuzs.strawstatues.client.entity.ClientStrawStatue;
import fuzs.strawstatues.client.model.StrawStatueCapeModel;
import fuzs.strawstatues.client.model.StrawStatueModel;
import fuzs.strawstatues.client.model.geom.ModModelLayers;
import fuzs.strawstatues.client.renderer.entity.state.StrawStatueRenderState;
import java.util.Map;
import net.minecraft.client.model.AdultAndBabyModelPair;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.Model;
import net.minecraft.client.model.PlayerModel;
import net.minecraft.client.model.geom.EntityModelSet;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.SubmitNodeCollector;
import net.minecraft.client.renderer.entity.ArmorModelSet;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.CapeLayer;
import net.minecraft.client.renderer.entity.layers.Deadmau5EarsLayer;
import net.minecraft.client.renderer.entity.layers.HumanoidArmorLayer;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.entity.player.AvatarRenderer;
import net.minecraft.client.renderer.entity.state.AvatarRenderState;
import net.minecraft.client.renderer.entity.state.HumanoidRenderState;
import net.minecraft.client.renderer.entity.state.LivingEntityRenderState;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Avatar;
import net.minecraft.world.entity.player.PlayerModelType;
import org.joml.Quaternionfc;

public abstract class StrawStatueRenderer
extends AvatarRenderer<ClientStrawStatue> {
    protected final Map<PlayerModelType, AdultAndBabyModelPair<StrawStatueModel>> models;

    public StrawStatueRenderer(final EntityRendererProvider.Context context) {
        super(context, false);
        this.models = StrawStatueRenderer.bakeModels(context);
        this.layers.removeIf(renderLayer -> renderLayer instanceof HumanoidArmorLayer || renderLayer instanceof CapeLayer || renderLayer instanceof Deadmau5EarsLayer);
        this.addHumanoidArmorLayer(context, ModModelLayers.STRAW_STATUE_ARMOR, ModModelLayers.STRAW_STATUE_BABY_ARMOR, PlayerModelType.WIDE);
        this.addHumanoidArmorLayer(context, ModModelLayers.STRAW_STATUE_SLIM_ARMOR, ModModelLayers.STRAW_STATUE_BABY_SLIM_ARMOR, PlayerModelType.SLIM);
        this.addLayer((RenderLayer)new Deadmau5EarsLayer(this, (RenderLayerParent)this, context.getModelSet()){
            private final AdultAndBabyModelPair<HumanoidModel<AvatarRenderState>> models;
            {
                super(renderer, modelSet);
                this.models = new AdultAndBabyModelPair((Model)new StrawStatueModel(context.bakeLayer(ModModelLayers.STRAW_STATUE_EARS), false), (Model)new StrawStatueModel(context.bakeLayer(ModModelLayers.STRAW_STATUE_BABY_EARS), false));
            }

            public void submit(PoseStack poseStack, SubmitNodeCollector nodeCollector, int packedLight, AvatarRenderState renderState, float yRot, float xRot) {
                this.model = (HumanoidModel)this.models.getModel(renderState.isBaby);
                super.submit(poseStack, nodeCollector, packedLight, renderState, yRot, xRot);
            }
        });
        this.addLayer((RenderLayer)new CapeLayer(this, (RenderLayerParent)this, context.getModelSet(), context.getEquipmentAssets()){
            private final AdultAndBabyModelPair<HumanoidModel<AvatarRenderState>> models;
            {
                super(renderer, modelSet, equipmentAssets);
                this.models = new AdultAndBabyModelPair((Model)new StrawStatueCapeModel(context.bakeLayer(ModModelLayers.STRAW_STATUE_CAPE)), (Model)new StrawStatueCapeModel(context.bakeLayer(ModModelLayers.STRAW_STATUE_BABY_CAPE)));
            }

            public void submit(PoseStack poseStack, SubmitNodeCollector nodeCollector, int packedLight, AvatarRenderState renderState, float yRot, float xRot) {
                this.model = (HumanoidModel)this.models.getModel(renderState.isBaby);
                super.submit(poseStack, nodeCollector, packedLight, renderState, yRot, xRot);
            }
        });
    }

    private static Map<PlayerModelType, AdultAndBabyModelPair<StrawStatueModel>> bakeModels(EntityRendererProvider.Context context) {
        return Maps.newEnumMap(Map.of(PlayerModelType.WIDE, new AdultAndBabyModelPair((Model)new StrawStatueModel(context.bakeLayer(ModModelLayers.STRAW_STATUE), false), (Model)new StrawStatueModel(context.bakeLayer(ModModelLayers.STRAW_STATUE_BABY), false)), PlayerModelType.SLIM, new AdultAndBabyModelPair((Model)new StrawStatueModel(context.bakeLayer(ModModelLayers.STRAW_STATUE_SLIM), true), (Model)new StrawStatueModel(context.bakeLayer(ModModelLayers.STRAW_STATUE_BABY_SLIM), true))));
    }

    private void addHumanoidArmorLayer(EntityRendererProvider.Context context, ArmorModelSet<ModelLayerLocation> armorModelSet, ArmorModelSet<ModelLayerLocation> babyArmorModelSet, final PlayerModelType modelType) {
        this.addLayer((RenderLayer)new HumanoidArmorLayer<AvatarRenderState, PlayerModel, StrawStatueModel>(this, (RenderLayerParent)this, ArmorModelSet.bake(armorModelSet, (EntityModelSet)context.getModelSet(), modelPart -> new StrawStatueModel((ModelPart)modelPart, modelType == PlayerModelType.SLIM)), ArmorModelSet.bake(babyArmorModelSet, (EntityModelSet)context.getModelSet(), modelPart -> new StrawStatueModel((ModelPart)modelPart, modelType == PlayerModelType.SLIM)), context.getEquipmentRenderer()){

            public void submit(PoseStack poseStack, SubmitNodeCollector nodeCollector, int packedLight, AvatarRenderState renderState, float yRot, float xRot) {
                if (renderState.skin.model() == modelType) {
                    super.submit(poseStack, nodeCollector, packedLight, (HumanoidRenderState)renderState, yRot, xRot);
                }
            }
        });
    }

    protected float getShadowRadius(AvatarRenderState renderState) {
        return super.getShadowRadius((LivingEntityRenderState)renderState) * renderState.ageScale;
    }

    public StrawStatueRenderState createRenderState() {
        return new StrawStatueRenderState();
    }

    public void extractRenderState(ClientStrawStatue strawStatue, AvatarRenderState renderState, float partialTick) {
        super.extractRenderState((Avatar)strawStatue, renderState, partialTick);
        ((StrawStatueRenderState)renderState).rotX = strawStatue.getPoseX(partialTick);
        ((StrawStatueRenderState)renderState).rotZ = strawStatue.getPoseZ(partialTick);
        ((StrawStatueRenderState)renderState).wiggle = (float)(strawStatue.level().getGameTime() - strawStatue.lastHit) + partialTick;
        ((StrawStatueRenderState)renderState).headPose = strawStatue.getHeadPose(partialTick);
        ((StrawStatueRenderState)renderState).bodyPose = strawStatue.getBodyPose(partialTick);
        ((StrawStatueRenderState)renderState).leftArmPose = strawStatue.getLeftArmPose(partialTick);
        ((StrawStatueRenderState)renderState).rightArmPose = strawStatue.getRightArmPose(partialTick);
        ((StrawStatueRenderState)renderState).leftLegPose = strawStatue.getLeftLegPose(partialTick);
        ((StrawStatueRenderState)renderState).rightLegPose = strawStatue.getRightLegPose(partialTick);
        renderState.scale = strawStatue.getScale(partialTick);
    }

    protected void setupRotations(AvatarRenderState renderState, PoseStack poseStack, float bodyRot, float scale) {
        poseStack.mulPose((Quaternionfc)Axis.ZP.rotationDegrees(180.0f - ((StrawStatueRenderState)renderState).rotZ));
        poseStack.mulPose((Quaternionfc)Axis.YP.rotationDegrees(180.0f - bodyRot));
        poseStack.mulPose((Quaternionfc)Axis.XP.rotationDegrees(180.0f - ((StrawStatueRenderState)renderState).rotX));
        float wiggle = ((StrawStatueRenderState)renderState).wiggle;
        if (wiggle < 5.0f) {
            poseStack.mulPose((Quaternionfc)Axis.YP.rotationDegrees(Mth.sin((float)(wiggle / 1.5f * (float)Math.PI)) * 3.0f));
        }
        if (renderState.isUpsideDown) {
            poseStack.translate(0.0f, (renderState.boundingBoxHeight + 0.1f) / scale, 0.0f);
            poseStack.mulPose((Quaternionfc)Axis.ZP.rotationDegrees(180.0f));
        }
    }
}

