/*
 * Decompiled with CFR 0.152.
 */
package fuzs.strawstatues.network.client;

import fuzs.puzzleslib.api.network.v4.MessageSender;
import fuzs.puzzleslib.api.network.v4.codec.ExtraStreamCodecs;
import fuzs.puzzleslib.api.network.v4.message.Message;
import fuzs.puzzleslib.api.network.v4.message.MessageListener;
import fuzs.puzzleslib.api.network.v4.message.play.ServerboundPlayMessage;
import fuzs.statuemenus.api.v1.world.inventory.StatueMenu;
import fuzs.strawstatues.world.entity.decoration.StrawStatue;
import io.netty.buffer.ByteBuf;
import java.util.function.Consumer;
import net.minecraft.core.Rotations;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;

public record ServerboundStrawStatueScaleMessage(ValueAccessor valueAccessor, float value) implements ServerboundPlayMessage
{
    public static final StreamCodec<ByteBuf, ServerboundStrawStatueScaleMessage> STREAM_CODEC = StreamCodec.composite((StreamCodec)ExtraStreamCodecs.fromEnum(ValueAccessor.class), ServerboundStrawStatueScaleMessage::valueAccessor, (StreamCodec)ByteBufCodecs.FLOAT, ServerboundStrawStatueScaleMessage::value, ServerboundStrawStatueScaleMessage::new);

    public static Consumer<Float> getValueSender(ValueAccessor valueAccessor) {
        return value -> MessageSender.broadcast((Message)new ServerboundStrawStatueScaleMessage(valueAccessor, value.floatValue()));
    }

    public MessageListener<ServerboundPlayMessage.Context> getListener() {
        return new MessageListener<ServerboundPlayMessage.Context>(){

            public void accept(ServerboundPlayMessage.Context context) {
                StatueMenu statueMenu;
                AbstractContainerMenu abstractContainerMenu = context.player().containerMenu;
                if (abstractContainerMenu instanceof StatueMenu && (statueMenu = (StatueMenu)abstractContainerMenu).stillValid((Player)context.player())) {
                    StrawStatue strawStatue = (StrawStatue)statueMenu.getEntity();
                    Rotations rotations = ServerboundStrawStatueScaleMessage.this.valueAccessor.setRotationsComponent(strawStatue.getEntityPose(), ServerboundStrawStatueScaleMessage.this.value);
                    strawStatue.setEntityPose(rotations);
                }
            }
        };
    }

    public static enum ValueAccessor {
        ROTATION_X{

            @Override
            public Rotations setRotationsComponent(Rotations rotations, float value) {
                return new Rotations(value, rotations.y(), rotations.z());
            }

            @Override
            public float getRotationsComponent(Rotations rotations) {
                return rotations.x();
            }
        }
        ,
        ROTATION_Z{

            @Override
            public Rotations setRotationsComponent(Rotations rotations, float value) {
                return new Rotations(rotations.x(), rotations.y(), value);
            }

            @Override
            public float getRotationsComponent(Rotations rotations) {
                return rotations.z();
            }
        };


        public abstract Rotations setRotationsComponent(Rotations var1, float var2);

        public abstract float getRotationsComponent(Rotations var1);
    }
}

