/*
 * Decompiled with CFR 0.152.
 */
package fuzs.strawstatues.network.client;

import fuzs.puzzleslib.api.network.v4.codec.ExtraStreamCodecs;
import fuzs.puzzleslib.api.network.v4.message.MessageListener;
import fuzs.puzzleslib.api.network.v4.message.play.ServerboundPlayMessage;
import fuzs.statuemenus.api.v1.world.inventory.StatueMenu;
import fuzs.strawstatues.world.entity.decoration.StrawStatue;
import io.netty.buffer.ByteBuf;
import java.util.Optional;
import net.minecraft.core.ClientAsset;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.player.PlayerSkin;
import net.minecraft.world.inventory.AbstractContainerMenu;

public record ServerboundStrawStatueSkinPatchMessage(DataType dataType, Optional<ClientAsset.ResourceTexture> resourceTexture) implements ServerboundPlayMessage
{
    public static final StreamCodec<ByteBuf, ServerboundStrawStatueSkinPatchMessage> STREAM_CODEC = StreamCodec.composite((StreamCodec)ExtraStreamCodecs.fromEnum(DataType.class), ServerboundStrawStatueSkinPatchMessage::dataType, (StreamCodec)ClientAsset.ResourceTexture.STREAM_CODEC.apply(ByteBufCodecs::optional), ServerboundStrawStatueSkinPatchMessage::resourceTexture, ServerboundStrawStatueSkinPatchMessage::new);

    public MessageListener<ServerboundPlayMessage.Context> getListener() {
        return new MessageListener<ServerboundPlayMessage.Context>(){

            public void accept(ServerboundPlayMessage.Context context) {
                StatueMenu statueMenu;
                AbstractContainerMenu abstractContainerMenu = context.player().containerMenu;
                if (abstractContainerMenu instanceof StatueMenu && (statueMenu = (StatueMenu)abstractContainerMenu).stillValid((Player)context.player())) {
                    StrawStatue strawStatue = (StrawStatue)statueMenu.getEntity();
                    PlayerSkin.Patch skinPatch = ServerboundStrawStatueSkinPatchMessage.this.dataType.createSkinPatch(strawStatue.getSkinPatch(), ServerboundStrawStatueSkinPatchMessage.this.resourceTexture);
                    strawStatue.setSkinPatch(skinPatch);
                }
            }
        };
    }

    public static enum DataType {
        SKIN{

            @Override
            public Optional<ClientAsset.ResourceTexture> getTexturePath(PlayerSkin.Patch patch) {
                return patch.body();
            }

            @Override
            public PlayerSkin.Patch createSkinPatch(PlayerSkin.Patch patch, Optional<ClientAsset.ResourceTexture> resourceTexture) {
                return PlayerSkin.Patch.create(resourceTexture, (Optional)patch.cape(), (Optional)patch.elytra(), (Optional)(resourceTexture.isEmpty() ? Optional.empty() : patch.model()));
            }
        }
        ,
        CAPE{

            @Override
            public Optional<ClientAsset.ResourceTexture> getTexturePath(PlayerSkin.Patch patch) {
                return patch.cape();
            }

            @Override
            public PlayerSkin.Patch createSkinPatch(PlayerSkin.Patch patch, Optional<ClientAsset.ResourceTexture> resourceTexture) {
                return PlayerSkin.Patch.create((Optional)patch.body(), resourceTexture, (Optional)patch.elytra(), (Optional)patch.model());
            }
        }
        ,
        ELYTRA{

            @Override
            public Optional<ClientAsset.ResourceTexture> getTexturePath(PlayerSkin.Patch patch) {
                return patch.elytra();
            }

            @Override
            public PlayerSkin.Patch createSkinPatch(PlayerSkin.Patch patch, Optional<ClientAsset.ResourceTexture> resourceTexture) {
                return PlayerSkin.Patch.create((Optional)patch.body(), (Optional)patch.cape(), resourceTexture, (Optional)patch.model());
            }
        };


        public abstract Optional<ClientAsset.ResourceTexture> getTexturePath(PlayerSkin.Patch var1);

        public abstract PlayerSkin.Patch createSkinPatch(PlayerSkin.Patch var1, Optional<ClientAsset.ResourceTexture> var2);
    }
}

