/*
 * Decompiled with CFR 0.152.
 */
package fuzs.strawstatues.world.entity.decoration;

import com.mojang.authlib.GameProfile;
import com.mojang.serialization.Codec;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicOps;
import fuzs.puzzleslib.api.util.v1.CommonHelper;
import fuzs.statuemenus.api.v1.helper.ArmorStandInteractHelper;
import fuzs.statuemenus.api.v1.world.entity.decoration.StatueEntity;
import fuzs.statuemenus.api.v1.world.inventory.data.StatueScreenType;
import fuzs.statuemenus.api.v1.world.inventory.data.StatueStyleOption;
import fuzs.strawstatues.StrawStatues;
import fuzs.strawstatues.init.ModRegistry;
import fuzs.strawstatues.world.inventory.data.StrawStatueScreenTypes;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import net.minecraft.core.BlockPos;
import net.minecraft.core.ClientAsset;
import net.minecraft.core.Holder;
import net.minecraft.core.Rotations;
import net.minecraft.core.component.DataComponentGetter;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.network.chat.Component;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.players.ProfileResolver;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.util.datafix.fixes.ItemStackComponentizationFix;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LightningBolt;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.decoration.ArmorStand;
import net.minecraft.world.entity.decoration.Mannequin;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.player.PlayerModelPart;
import net.minecraft.world.entity.player.PlayerModelType;
import net.minecraft.world.entity.player.PlayerSkin;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.ResolvableProfile;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class StrawStatue
extends Mannequin
implements StatueEntity {
    public static final ResourceLocation STRAW_STATUE_LOCATION = StrawStatues.id("entity/straw_statue");
    public static final PlayerSkin DEFAULT_SKIN = new PlayerSkin((ClientAsset.Texture)new ClientAsset.ResourceTexture(STRAW_STATUE_LOCATION), null, null, PlayerModelType.WIDE, true);
    public static final Rotations DEFAULT_ENTITY_POSE = new Rotations(180.0f, 0.0f, 180.0f);
    public static final String SMALL_KEY = "Small";
    public static final String PUSHABLE_KEY = "pushable";
    public static final String DYNAMIC_PROFILE_KEY = "dynamic_profile";
    public static final String SEALED_KEY = "sealed";
    public static final String SKIN_PATCH_KEY = "skin_patch";
    public static final String ARMOR_STAND_POSE_KEY = "Pose";
    public static final String CROUCHING_KEY = "Crouching";
    public static final String ENTITY_POSE_KEY = "EntityRotations";
    public static final EntityDataAccessor<Boolean> DATA_SMALL = SynchedEntityData.defineId(StrawStatue.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    public static final EntityDataAccessor<Boolean> DATA_PUSHABLE = SynchedEntityData.defineId(StrawStatue.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    public static final EntityDataAccessor<Boolean> DATA_DYNAMIC_PROFILE = SynchedEntityData.defineId(StrawStatue.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    public static final EntityDataAccessor<Boolean> DATA_SEALED = SynchedEntityData.defineId(StrawStatue.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    public static final EntityDataAccessor<PlayerSkin.Patch> DATA_SKIN_PATCH = SynchedEntityData.defineId(StrawStatue.class, (EntityDataSerializer)((EntityDataSerializer)ModRegistry.SKIN_PATCH_ENTITY_DATA_SERIALIZER.value()));
    public static final EntityDataAccessor<Rotations> DATA_ENTITY_POSE = SynchedEntityData.defineId(StrawStatue.class, (EntityDataSerializer)EntityDataSerializers.ROTATIONS);
    public static final EntityDataAccessor<Rotations> DATA_HEAD_POSE = SynchedEntityData.defineId(StrawStatue.class, (EntityDataSerializer)EntityDataSerializers.ROTATIONS);
    public static final EntityDataAccessor<Rotations> DATA_BODY_POSE = SynchedEntityData.defineId(StrawStatue.class, (EntityDataSerializer)EntityDataSerializers.ROTATIONS);
    public static final EntityDataAccessor<Rotations> DATA_LEFT_ARM_POSE = SynchedEntityData.defineId(StrawStatue.class, (EntityDataSerializer)EntityDataSerializers.ROTATIONS);
    public static final EntityDataAccessor<Rotations> DATA_RIGHT_ARM_POSE = SynchedEntityData.defineId(StrawStatue.class, (EntityDataSerializer)EntityDataSerializers.ROTATIONS);
    public static final EntityDataAccessor<Rotations> DATA_LEFT_LEG_POSE = SynchedEntityData.defineId(StrawStatue.class, (EntityDataSerializer)EntityDataSerializers.ROTATIONS);
    public static final EntityDataAccessor<Rotations> DATA_RIGHT_LEG_POSE = SynchedEntityData.defineId(StrawStatue.class, (EntityDataSerializer)EntityDataSerializers.ROTATIONS);
    @Nullable
    private CompletableFuture<GameProfile> profileLookup;
    public long lastHit;

    public StrawStatue(EntityType<? extends StrawStatue> entityType, Level level) {
        super(entityType, level);
        this.setNoGravity(true);
        this.setHideDescription(true);
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(DATA_SMALL, (Object)false);
        builder.define(DATA_PUSHABLE, (Object)false);
        builder.define(DATA_DYNAMIC_PROFILE, (Object)false);
        builder.define(DATA_SEALED, (Object)false);
        builder.define(DATA_SKIN_PATCH, (Object)PlayerSkin.Patch.EMPTY);
        builder.define(DATA_ENTITY_POSE, (Object)DEFAULT_ENTITY_POSE);
        builder.define(DATA_HEAD_POSE, (Object)ArmorStand.DEFAULT_HEAD_POSE);
        builder.define(DATA_BODY_POSE, (Object)ArmorStand.DEFAULT_BODY_POSE);
        builder.define(DATA_LEFT_ARM_POSE, (Object)ArmorStand.DEFAULT_LEFT_ARM_POSE);
        builder.define(DATA_RIGHT_ARM_POSE, (Object)ArmorStand.DEFAULT_RIGHT_ARM_POSE);
        builder.define(DATA_LEFT_LEG_POSE, (Object)ArmorStand.DEFAULT_LEFT_LEG_POSE);
        builder.define(DATA_RIGHT_LEG_POSE, (Object)ArmorStand.DEFAULT_RIGHT_LEG_POSE);
    }

    public void addAdditionalSaveData(ValueOutput valueOutput) {
        super.addAdditionalSaveData(valueOutput);
        valueOutput.putBoolean(SMALL_KEY, this.isBaby());
        valueOutput.putBoolean(PUSHABLE_KEY, ((Boolean)this.entityData.get(DATA_PUSHABLE)).booleanValue());
        valueOutput.putBoolean(DYNAMIC_PROFILE_KEY, this.isDynamicProfile());
        valueOutput.putBoolean(SEALED_KEY, this.isSealed());
        if (!Objects.equals(this.getSkinPatch(), PlayerSkin.Patch.EMPTY)) {
            valueOutput.store(SKIN_PATCH_KEY, PlayerSkin.Patch.MAP_CODEC.codec(), (Object)this.getSkinPatch());
        }
        valueOutput.store(ARMOR_STAND_POSE_KEY, ArmorStand.ArmorStandPose.CODEC, (Object)this.getArmorStandPose());
        valueOutput.putBoolean(CROUCHING_KEY, this.isCrouching());
        if (!Objects.equals(this.getEntityPose(), DEFAULT_ENTITY_POSE)) {
            valueOutput.store(ENTITY_POSE_KEY, Rotations.CODEC, (Object)this.getEntityPose());
        }
    }

    public void readAdditionalSaveData(ValueInput valueInput) {
        super.readAdditionalSaveData(valueInput);
        this.setBaby(valueInput.getBooleanOr(SMALL_KEY, false));
        this.setPushable(valueInput.getBooleanOr(PUSHABLE_KEY, false));
        this.setDynamicProfile(valueInput.getBooleanOr(DYNAMIC_PROFILE_KEY, false));
        this.setSealed(valueInput.getBooleanOr(SEALED_KEY, false));
        valueInput.read(SKIN_PATCH_KEY, PlayerSkin.Patch.MAP_CODEC.codec()).ifPresent(this::setSkinPatch);
        valueInput.read(ARMOR_STAND_POSE_KEY, ArmorStand.ArmorStandPose.CODEC).ifPresent(arg_0 -> ((StrawStatue)this).setArmorStandPose(arg_0));
        this.setCrouching(valueInput.getBooleanOr(CROUCHING_KEY, false));
        valueInput.read(ENTITY_POSE_KEY, Rotations.CODEC).ifPresent(this::setEntityPose);
        this.readLegacySaveData(valueInput);
    }

    @Deprecated
    private void readLegacySaveData(ValueInput valueInput) {
        byte modelParts = valueInput.getByteOr("ModelParts", (byte)0);
        if (modelParts != 0) {
            this.entityData.set(DATA_PLAYER_MODE_CUSTOMISATION, (Object)modelParts);
        }
        valueInput.read("Owner", CompoundTag.CODEC).map(compoundTag -> ItemStackComponentizationFix.fixProfile((Dynamic)new Dynamic((DynamicOps)NbtOps.INSTANCE, compoundTag))).map(arg_0 -> ((Codec)ResolvableProfile.CODEC).parse(arg_0)).flatMap(dataResult -> dataResult.resultOrPartial(string -> StrawStatues.LOGGER.error("Failed to load profile from straw statue: {}", string))).ifPresent(this::setProfile);
    }

    public void refreshDimensions() {
        if (this.isPushable()) {
            super.refreshDimensions();
        } else {
            double x = this.getX();
            double y = this.getY();
            double z = this.getZ();
            super.refreshDimensions();
            this.setPos(x, y, z);
        }
    }

    public boolean isPushable() {
        return (Boolean)this.entityData.get(DATA_PUSHABLE) != false && super.isPushable();
    }

    public void setPushable(boolean isPushable) {
        this.entityData.set(DATA_PUSHABLE, (Object)isPushable);
        if (isPushable) {
            this.setNoGravity(false);
        }
    }

    public void setNoGravity(boolean noGravity) {
        super.setNoGravity(noGravity);
        if (noGravity) {
            this.setPushable(false);
        }
    }

    protected void doPush(Entity entity) {
        if (this.isPushable() && !this.isNoGravity()) {
            super.doPush(entity);
        }
    }

    protected void pushEntities() {
        if (this.isPushable() && !this.isNoGravity()) {
            for (Entity entity : this.level().getPushableEntities((Entity)this, this.getBoundingBox())) {
                this.doPush(entity);
            }
        }
    }

    public void travel(Vec3 travelVector) {
        if (!this.isNoGravity()) {
            super.travel(travelVector);
        }
    }

    public boolean isEffectiveAi() {
        return super.isEffectiveAi() && !this.isNoGravity();
    }

    public boolean canUseSlot(EquipmentSlot slot) {
        return slot.getType() == EquipmentSlot.Type.HAND || slot.getType() == EquipmentSlot.Type.HUMANOID_ARMOR;
    }

    public InteractionResult interact(Player player, InteractionHand interactionHand) {
        InteractionResult interactionResult = super.interact(player, interactionHand);
        if (interactionResult.consumesAction()) {
            return interactionResult;
        }
        return ArmorStandInteractHelper.openStatueMenu((Player)player, (Level)this.level(), (InteractionHand)interactionHand, (LivingEntity)this, (MenuType)((MenuType)ModRegistry.STRAW_STATUE_MENU_TYPE.value()), (StatueEntity)this);
    }

    public EntityDimensions getDefaultDimensions(Pose pose) {
        return super.getDefaultDimensions(pose).scale(this.getAgeScale());
    }

    public void tick() {
        super.tick();
        if (this.level() instanceof ServerLevel) {
            this.lookupProfile();
        }
    }

    private void lookupProfile() {
        if (this.profileLookup != null && this.profileLookup.isDone()) {
            try {
                this.setProfile(ResolvableProfile.createResolved((GameProfile)this.profileLookup.get()));
                this.profileLookup = null;
            }
            catch (Exception exception) {
                StrawStatues.LOGGER.error("Error when trying to look up profile", (Throwable)exception);
            }
        }
    }

    public void setProfile(ResolvableProfile resolvableProfile) {
        GameProfile oldGameProfile = this.getProfile().partialProfile();
        super.setProfile(resolvableProfile);
        Level level = this.level();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            if (!Objects.equals(resolvableProfile.partialProfile(), oldGameProfile)) {
                this.updateProfile(serverLevel, resolvableProfile);
            }
        }
    }

    private void updateProfile(ServerLevel serverLevel, ResolvableProfile resolvableProfile) {
        ProfileResolver profileResolver = serverLevel.getServer().services().profileResolver();
        if (this.profileLookup != null) {
            CompletableFuture<GameProfile> completableFuture = this.profileLookup;
            this.profileLookup = null;
            completableFuture.cancel(false);
        }
        if (!Objects.equals(resolvableProfile, DEFAULT_PROFILE)) {
            this.profileLookup = resolvableProfile.resolveProfile(profileResolver);
        }
    }

    public boolean isDynamicProfile() {
        return (Boolean)this.entityData.get(DATA_DYNAMIC_PROFILE);
    }

    public void setDynamicProfile(boolean isDynamic) {
        this.entityData.set(DATA_DYNAMIC_PROFILE, (Object)isDynamic);
    }

    public boolean isSealed() {
        return (Boolean)this.entityData.get(DATA_SEALED);
    }

    public void setSealed(boolean isSealed) {
        this.entityData.set(DATA_SEALED, (Object)isSealed);
    }

    public PlayerSkin.Patch getSkinPatch() {
        return (PlayerSkin.Patch)this.entityData.get(DATA_SKIN_PATCH);
    }

    public void setSkinPatch(PlayerSkin.Patch skinPatch) {
        this.entityData.set(DATA_SKIN_PATCH, (Object)skinPatch);
    }

    public boolean isBaby() {
        return (Boolean)this.getEntityData().get(DATA_SMALL);
    }

    public void setBaby(boolean isBaby) {
        this.getEntityData().set(DATA_SMALL, (Object)isBaby);
    }

    public void onSyncedDataUpdated(EntityDataAccessor<?> dataAccessor) {
        if (Objects.equals(DATA_SMALL, dataAccessor)) {
            this.refreshDimensions();
        }
        super.onSyncedDataUpdated(dataAccessor);
    }

    public void setCustomName(@Nullable Component name) {
        super.setCustomName(name);
        this.setCustomNameVisible(name != null);
    }

    public String getProfileName() {
        return this.getProfile().name().orElseGet(() -> ((GameProfile)this.getProfile().partialProfile()).name());
    }

    public void setModelPartShown(PlayerModelPart modelPart, boolean value) {
        byte modelParts = (Byte)this.getEntityData().get(DATA_PLAYER_MODE_CUSTOMISATION);
        this.entityData.set(DATA_PLAYER_MODE_CUSTOMISATION, (Object)StatueStyleOption.setBit((byte)modelParts, (int)modelPart.getMask(), (boolean)value));
    }

    public void setCrouching(boolean isCrouching) {
        this.setPose(isCrouching ? Pose.CROUCHING : Pose.STANDING);
        this.setShiftKeyDown(isCrouching);
    }

    public Rotations getEntityPose() {
        return (Rotations)this.entityData.get(DATA_ENTITY_POSE);
    }

    public void setEntityPose(Rotations rotations) {
        this.entityData.set(DATA_ENTITY_POSE, (Object)rotations);
    }

    public boolean hurtServer(ServerLevel serverLevel, DamageSource damageSource, float damageAmount) {
        if (!this.isRemoved()) {
            if (damageSource.is(DamageTypeTags.BYPASSES_INVULNERABILITY)) {
                this.kill(serverLevel);
                return false;
            }
            if (!this.isInvulnerableTo(serverLevel, damageSource) && !this.isInvisible()) {
                if (damageSource.is(DamageTypeTags.IS_EXPLOSION)) {
                    this.brokenByAnything(serverLevel, damageSource);
                    this.kill(serverLevel);
                    return false;
                }
                if (damageSource.is(DamageTypeTags.IGNITES_ARMOR_STANDS)) {
                    if (this.isOnFire()) {
                        this.causeDamage(serverLevel, damageSource, 0.15f);
                    } else {
                        this.igniteForSeconds(5.0f);
                    }
                    return false;
                }
                if (damageSource.is(DamageTypeTags.BURNS_ARMOR_STANDS) && this.getHealth() > 0.5f) {
                    this.causeDamage(serverLevel, damageSource, 4.0f);
                    return false;
                }
                boolean bl = damageSource.is(DamageTypeTags.CAN_BREAK_ARMOR_STAND);
                boolean bl2 = damageSource.is(DamageTypeTags.ALWAYS_KILLS_ARMOR_STANDS);
                if (!bl && !bl2) {
                    return false;
                }
                if (damageSource.getEntity() instanceof Player && !((Player)damageSource.getEntity()).getAbilities().mayBuild) {
                    return false;
                }
                if (damageSource.isCreativePlayer()) {
                    this.playBrokenSound(serverLevel);
                    this.showBreakingParticles(serverLevel);
                    this.kill(serverLevel);
                    return true;
                }
                long gameTime = this.level().getGameTime();
                if (gameTime - this.lastHit > 5L && !bl2) {
                    this.level().broadcastEntityEvent((Entity)this, (byte)32);
                    this.gameEvent((Holder)GameEvent.ENTITY_DAMAGE, damageSource.getEntity());
                    this.lastHit = gameTime;
                    this.invulnerableTime = 20;
                    this.hurtTime = this.hurtDuration = 10;
                } else {
                    this.brokenByPlayer(serverLevel, damageSource);
                    this.showBreakingParticles(serverLevel);
                    this.kill(serverLevel);
                }
                return true;
            }
            return false;
        }
        return false;
    }

    public void handleEntityEvent(byte id) {
        if (id == 32 && this.level().isClientSide()) {
            this.level().playLocalSound(this.getX(), this.getY(), this.getZ(), this.getHurtSound(this.damageSources().generic()), this.getSoundSource(), 0.3f, 1.0f, false);
            this.lastHit = this.level().getGameTime();
        }
        super.handleEntityEvent(id);
    }

    private void showBreakingParticles(ServerLevel serverLevel) {
        serverLevel.sendParticles((ParticleOptions)new BlockParticleOption(ParticleTypes.BLOCK, Blocks.HAY_BLOCK.defaultBlockState()), this.getX(), this.getY(0.67), this.getZ(), 10, (double)(this.getBbWidth() / 4.0f), (double)(this.getBbHeight() / 4.0f), (double)(this.getBbWidth() / 4.0f), 0.05);
    }

    private void causeDamage(ServerLevel serverLevel, DamageSource damageSource, float damageAmount) {
        float f = this.getHealth();
        if ((f -= damageAmount) <= 0.5f) {
            this.brokenByAnything(serverLevel, damageSource);
            this.kill(serverLevel);
        } else {
            this.setHealth(f);
            this.gameEvent((Holder)GameEvent.ENTITY_DAMAGE, damageSource.getEntity());
        }
    }

    private void brokenByPlayer(ServerLevel serverLevel, DamageSource damageSource) {
        ItemStack itemStack = new ItemStack(ModRegistry.STRAW_STATUE_ITEM);
        itemStack.set(DataComponents.CUSTOM_NAME, (Object)this.getCustomName());
        Block.popResource((Level)this.level(), (BlockPos)this.blockPosition(), (ItemStack)itemStack);
        this.brokenByAnything(serverLevel, damageSource);
    }

    private void brokenByAnything(ServerLevel serverLevel, DamageSource damageSource) {
        this.playBrokenSound(serverLevel);
        this.dropAllDeathLoot(serverLevel, damageSource);
        for (EquipmentSlot equipmentSlot : EquipmentSlot.VALUES) {
            ItemStack itemStack = this.equipment.set(equipmentSlot, ItemStack.EMPTY);
            if (itemStack.isEmpty()) continue;
            Block.popResource((Level)this.level(), (BlockPos)this.blockPosition().above(), (ItemStack)itemStack);
        }
    }

    private void playBrokenSound(ServerLevel serverLevel) {
        serverLevel.playSound(null, this.getX(), this.getY(), this.getZ(), this.getDeathSound(), this.getSoundSource(), 1.0f, 1.0f);
    }

    protected void tickHeadTurn(float yBodyRot) {
        this.yBodyRotO = this.yRotO;
        this.yBodyRot = this.getYRot();
    }

    public void setYBodyRot(float yBodyRot) {
        this.yBodyRotO = this.yRotO = yBodyRot;
        this.yHeadRotO = this.yHeadRot = yBodyRot;
    }

    public void setYHeadRot(float yHeadRot) {
        this.yBodyRotO = this.yRotO = yHeadRot;
        this.yHeadRotO = this.yHeadRot = yHeadRot;
    }

    public void kill(ServerLevel level) {
        this.remove(Entity.RemovalReason.KILLED);
        this.gameEvent((Holder)GameEvent.ENTITY_DIE);
    }

    public boolean ignoreExplosion(Explosion explosion) {
        return !explosion.shouldAffectBlocklikeEntities() || super.ignoreExplosion(explosion);
    }

    public void setHeadPose(Rotations headPose) {
        this.entityData.set(DATA_HEAD_POSE, (Object)headPose);
    }

    public void setBodyPose(Rotations bodyPose) {
        this.entityData.set(DATA_BODY_POSE, (Object)bodyPose);
    }

    public void setLeftArmPose(Rotations leftArmPose) {
        this.entityData.set(DATA_LEFT_ARM_POSE, (Object)leftArmPose);
    }

    public void setRightArmPose(Rotations rightArmPose) {
        this.entityData.set(DATA_RIGHT_ARM_POSE, (Object)rightArmPose);
    }

    public void setLeftLegPose(Rotations leftLegPose) {
        this.entityData.set(DATA_LEFT_LEG_POSE, (Object)leftLegPose);
    }

    public void setRightLegPose(Rotations rightLegPose) {
        this.entityData.set(DATA_RIGHT_LEG_POSE, (Object)rightLegPose);
    }

    public Rotations getHeadPose() {
        return (Rotations)this.entityData.get(DATA_HEAD_POSE);
    }

    public Rotations getBodyPose() {
        return (Rotations)this.entityData.get(DATA_BODY_POSE);
    }

    public Rotations getLeftArmPose() {
        return (Rotations)this.entityData.get(DATA_LEFT_ARM_POSE);
    }

    public Rotations getRightArmPose() {
        return (Rotations)this.entityData.get(DATA_RIGHT_ARM_POSE);
    }

    public Rotations getLeftLegPose() {
        return (Rotations)this.entityData.get(DATA_LEFT_LEG_POSE);
    }

    public Rotations getRightLegPose() {
        return (Rotations)this.entityData.get(DATA_RIGHT_LEG_POSE);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean skipAttackInteraction(Entity entity) {
        if (!(entity instanceof Player)) return false;
        Player player = (Player)entity;
        if (this.level().mayInteract((Entity)player, this.blockPosition())) return false;
        return true;
    }

    public LivingEntity.Fallsounds getFallSounds() {
        return new LivingEntity.Fallsounds(SoundEvents.GRASS_FALL, SoundEvents.GRASS_FALL);
    }

    @Nullable
    protected SoundEvent getHurtSound(DamageSource damageSource) {
        return SoundEvents.GRASS_HIT;
    }

    @Nullable
    protected SoundEvent getDeathSound() {
        return SoundEvents.GRASS_BREAK;
    }

    public void thunderHit(ServerLevel serverLevel, LightningBolt lightning) {
    }

    public boolean isAffectedByPotions() {
        return false;
    }

    public boolean attackable() {
        return false;
    }

    public ItemStack getPickResult() {
        ItemStack itemStack = new ItemStack(ModRegistry.STRAW_STATUE_ITEM);
        if (CommonHelper.hasControlDown()) {
            if (!Objects.equals(this.getProfile(), DEFAULT_PROFILE)) {
                itemStack.set(DataComponents.PROFILE, (Object)this.getProfile());
            }
            if (!Objects.equals(this.getSkinPatch(), PlayerSkin.Patch.EMPTY)) {
                itemStack.set((DataComponentType)ModRegistry.SKIN_PATCH_DATA_COMPONENT_TYPE.value(), (Object)this.getSkinPatch());
            }
        }
        return itemStack;
    }

    @Nullable
    public <T> T get(DataComponentType<? extends T> component) {
        if (component == ModRegistry.SKIN_PATCH_DATA_COMPONENT_TYPE.value()) {
            return (T)StrawStatue.castComponentValue(component, (Object)this.getSkinPatch());
        }
        return (T)super.get(component);
    }

    protected void applyImplicitComponents(DataComponentGetter componentGetter) {
        this.applyImplicitComponentIfPresent(componentGetter, (DataComponentType)ModRegistry.SKIN_PATCH_DATA_COMPONENT_TYPE.value());
        super.applyImplicitComponents(componentGetter);
    }

    protected <T> boolean applyImplicitComponent(DataComponentType<T> component, T value) {
        if (component == ModRegistry.SKIN_PATCH_DATA_COMPONENT_TYPE.value()) {
            this.setSkinPatch((PlayerSkin.Patch)StrawStatue.castComponentValue((DataComponentType)((DataComponentType)ModRegistry.SKIN_PATCH_DATA_COMPONENT_TYPE.value()), value));
            return true;
        }
        return super.applyImplicitComponent(component, value);
    }

    public List<StatueScreenType> getScreenTypes() {
        return StrawStatueScreenTypes.TYPES;
    }

    public StatueScreenType getDefaultScreenType() {
        return StrawStatueScreenTypes.ROTATIONS;
    }

    public Runnable setupInInventoryRendering(LivingEntity livingEntity) {
        Rotations rotations = this.getEntityPose();
        this.setEntityPose(DEFAULT_ENTITY_POSE);
        return () -> this.setEntityPose(rotations);
    }
}

