/*
 * Decompiled with CFR 0.152.
 */
package fuzs.strawstatues.world.item;

import fuzs.puzzleslib.api.util.v1.InteractionResultHelper;
import fuzs.statuemenus.api.v1.world.entity.decoration.StatueEntity;
import fuzs.statuemenus.api.v1.world.inventory.data.StatuePose;
import fuzs.strawstatues.init.ModRegistry;
import fuzs.strawstatues.world.entity.decoration.StrawStatue;
import java.util.function.Consumer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.Vec3i;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.ResolvableProfile;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class StrawStatueItem
extends Item {
    public StrawStatueItem(Item.Properties properties) {
        super(properties);
    }

    public InteractionResult useOn(UseOnContext context) {
        Direction direction = context.getClickedFace();
        if (direction == Direction.DOWN) {
            return InteractionResult.FAIL;
        }
        Level level = context.getLevel();
        BlockPlaceContext blockPlaceContext = new BlockPlaceContext(context);
        BlockPos blockPos = blockPlaceContext.getClickedPos();
        ItemStack itemInHand = context.getItemInHand();
        Vec3 vec3 = Vec3.atBottomCenterOf((Vec3i)blockPos);
        AABB aABB = ((EntityType)ModRegistry.STRAW_STATUE_ENTITY_TYPE.value()).getDimensions().makeBoundingBox(vec3.x(), vec3.y(), vec3.z());
        if (level.noCollision(null, aABB) && level.getEntities(null, aABB).isEmpty()) {
            if (level instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                Player player = context.getPlayer();
                Consumer consumer = EntityType.createDefaultStackConfig((Level)serverLevel, (ItemStack)itemInHand, (LivingEntity)context.getPlayer());
                StrawStatue strawStatue = (StrawStatue)((EntityType)ModRegistry.STRAW_STATUE_ENTITY_TYPE.value()).create(serverLevel, consumer, blockPos, EntitySpawnReason.SPAWN_ITEM_USE, true, true);
                if (strawStatue != null) {
                    float yRot = (float)Mth.floor((float)((Mth.wrapDegrees((float)(context.getRotation() - 180.0f)) + 22.5f) / 45.0f)) * 45.0f;
                    strawStatue.snapTo(strawStatue.getX(), strawStatue.getY(), strawStatue.getZ(), yRot, 0.0f);
                    serverLevel.addFreshEntityWithPassengers((Entity)strawStatue);
                    level.playSound(null, strawStatue.getX(), strawStatue.getY(), strawStatue.getZ(), SoundEvents.GRASS_PLACE, SoundSource.BLOCKS, 0.75f, 0.8f);
                    strawStatue.gameEvent((Holder)GameEvent.ENTITY_PLACE, (Entity)player);
                    if (player != null && !player.isShiftKeyDown()) {
                        StatuePose.randomValue().applyToEntity((StatueEntity)strawStatue);
                    }
                } else {
                    return InteractionResult.FAIL;
                }
            }
            itemInHand.shrink(1);
            return InteractionResultHelper.sidedSuccess((boolean)level.isClientSide());
        }
        return InteractionResult.FAIL;
    }

    public Component getName(ItemStack itemStack) {
        ResolvableProfile resolvableProfile = (ResolvableProfile)itemStack.get(DataComponents.PROFILE);
        return resolvableProfile != null && resolvableProfile.name().isPresent() ? Component.translatable((String)(this.getDescriptionId() + ".named"), (Object[])new Object[]{resolvableProfile.name().get()}) : super.getName(itemStack);
    }
}

