package de.yamayaki.cesium.maintenance.screens;

import de.yamayaki.cesium.maintenance.AbstractTask;
import it.unimi.dsi.fastutil.booleans.BooleanConsumer;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_2561;
import net.minecraft.class_32;
import net.minecraft.class_3286;
import net.minecraft.class_332;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_5244;
import net.minecraft.class_5455;
import net.minecraft.class_6904;
import net.minecraft.class_7843;
import net.minecraft.class_7852;
import net.minecraft.class_8667;
import org.spongepowered.asm.mixin.Unique;

public class CesiumTasksScreen extends class_437 {
    private final class_32.class_5143 levelAccess;
    private final BooleanConsumer callback;

    public CesiumTasksScreen(final class_32.class_5143 levelAccess, final BooleanConsumer callback) {
        super(class_2561.method_43470("Cesium Maintenance"));

        this.levelAccess = levelAccess;
        this.callback = callback;
    }

    public void method_25394(class_332 guiGraphics, int i, int j, float f) {
        super.method_25394(guiGraphics, i, j, f);
        guiGraphics.method_27534(this.field_22793, this.field_22785, this.field_22789 / 2, 15, 16777215);
    }

    @Override
    protected void method_25426() {
        var layout = class_8667.method_52741().method_52735(5);

        layout.method_52736(this.taskButton("Anvil → Cesium", AbstractTask.Task.TO_CESIUM));
        layout.method_52736(this.taskButton("Cesium → Anvil", AbstractTask.Task.TO_ANVIL));

        if(FabricLoader.getInstance().isDevelopmentEnvironment()) {
            layout.method_52736(this.taskButton("Compact Database", AbstractTask.Task.COMPACT));
        }

        layout.method_52736(new class_7852(200, 20));

        layout.method_52736(class_4185.method_46430(class_5244.field_24335, (buttonx) -> this.method_25419()).method_46432(200).method_46431());

        layout.method_48206(this::method_37063);

        layout.method_48222();
        class_7843.method_48634(layout, this.method_48202());
    }

    @Unique
    private class_4185 taskButton(final String text, final AbstractTask.Task task) {
        return class_4185.method_46430(
                class_2561.method_43470(text),
                action -> this.field_22787.method_1507(
                        new CesiumWorkScreen(task, this.levelAccess, this.createRegistry(), this.callback)
                )
        ).method_46432(200).method_46431();
    }

    /*
     * See vanilla code net.minecraft.client.gui.screens.worldselection.OptimizeWorldScreen.create(...);
     */
    @Unique
    private class_5455.class_6890 createRegistry() {
        assert this.field_22787 != null;

        try {
            final var worldOpenFlows = this.field_22787.method_41735();
            final var packRepository = class_3286.method_45285(this.levelAccess);

            try (final class_6904 worldStem = worldOpenFlows.method_54610(levelAccess.method_54545(), false, packRepository)) {
                final var worldData = worldStem.comp_359();
                final var frozen = worldStem.comp_358().method_45926();

                this.levelAccess.method_27425(frozen, worldData);

                return frozen;
            }
        } catch (final Throwable t) {
            throw new RuntimeException("Failed to load datapacks, can't convert world", t);
        }
    }

    @Override
    public void method_25419() {
        this.callback.accept(false);
    }
}
