package de.yamayaki.cesium.maintenance.storage.cesium;

import de.yamayaki.cesium.CesiumMod;
import de.yamayaki.cesium.api.database.ICloseableIterator;
import de.yamayaki.cesium.api.database.IDBInstance;
import de.yamayaki.cesium.common.spec.WorldDatabaseSpecs;
import de.yamayaki.cesium.maintenance.storage.IChunkStorage;
import org.lmdbjava.LmdbException;
import org.slf4j.Logger;

import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_1923;

public class CesiumChunkStorage implements IChunkStorage {
    private final Logger logger;
    private final IDBInstance database;

    public CesiumChunkStorage(final Logger logger, final Path basePath) {
        this.logger = logger;
        this.database = CesiumMod.openWorldDB(basePath);
    }

    @Override
    public List<class_1923> getAllChunks() {
        final List<class_1923> list = new ArrayList<>();

        try (final ICloseableIterator<class_1923> crs = this.database.getDatabase(WorldDatabaseSpecs.CHUNK_DATA).getIterator()) {
            while (crs.hasNext()) {
                list.add(crs.next());
            }
        } catch (final Throwable t) {
            throw new RuntimeException("Could not iterate on cursor.", t);
        }

        return list;
    }

    @Override
    public void flush() {
        try {
            this.database.flushChanges();
        } catch (LmdbException lmdbException) {
            this.logger.error("Failed to flush data", lmdbException);
        }
    }

    @Override
    public void close() {
        this.flush();
        this.database.close();
    }

    @Override
    public void setChunkData(final class_1923 chunkPos, final byte[] bytes) {
        this.database.getTransaction(WorldDatabaseSpecs.CHUNK_DATA).addBytes(chunkPos, bytes);
    }

    @Override
    public byte[] getChunkData(final class_1923 chunkPos) {
        return this.database.getDatabase(WorldDatabaseSpecs.CHUNK_DATA).getBytes(chunkPos);
    }

    @Override
    public void setPOIData(final class_1923 chunkPos, final byte[] bytes) {
        this.database.getTransaction(WorldDatabaseSpecs.POI).addBytes(chunkPos, bytes);
    }

    @Override
    public byte[] getPOIData(final class_1923 chunkPos) {
        return this.database.getDatabase(WorldDatabaseSpecs.POI).getBytes(chunkPos);
    }

    @Override
    public void setEntityData(final class_1923 chunkPos, final byte[] bytes) {
        this.database.getTransaction(WorldDatabaseSpecs.ENTITY).addBytes(chunkPos, bytes);
    }

    @Override
    public byte[] getEntityData(final class_1923 chunkPos) {
        return this.database.getDatabase(WorldDatabaseSpecs.ENTITY).getBytes(chunkPos);
    }
}
