package de.yamayaki.cesium.mixin.core.storage;

import de.yamayaki.cesium.api.accessor.DatabaseActions;
import de.yamayaki.cesium.api.accessor.DatabaseSetter;
import de.yamayaki.cesium.api.accessor.SpecificationSetter;
import de.yamayaki.cesium.api.database.DatabaseSpec;
import de.yamayaki.cesium.api.database.IDBInstance;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Redirect;

import java.io.IOException;
import net.minecraft.class_1923;
import net.minecraft.class_2487;
import net.minecraft.class_2867;
import net.minecraft.class_4698;
import net.minecraft.class_6836;

@Mixin(class_4698.class)
public abstract class MixinIOWorker implements DatabaseSetter, SpecificationSetter, DatabaseActions {
    @Shadow
    @Final
    private class_2867 storage;

    @Unique
    private IDBInstance database;

    @Unique
    private DatabaseSpec<class_1923, class_2487> databaseSpec;

    @Unique
    private boolean isCesium = false;

    /**
     * @author Yamayaki
     * @see class_4698#method_31738(class_1923)
     */
    @Redirect(
            method = "method_27943",
            at = @At(
                    value = "INVOKE",
                    target = "Lnet/minecraft/world/level/chunk/storage/RegionFileStorage;read(Lnet/minecraft/world/level/ChunkPos;)Lnet/minecraft/nbt/CompoundTag;"
            )
    )
    private class_2487 cesium$read(class_2867 instance, class_1923 chunkPos) throws IOException {
        if (this.isCesium) {
            return this.database
                    .getDatabase(this.databaseSpec)
                    .getValue(chunkPos);
        } else {
            return instance.method_17911(chunkPos);
        }
    }

    /**
     * @author Yamayaki
     * @see class_4698#method_39795(class_1923, class_6836)
     */
    @Redirect(
            method = "method_39801",
            at = @At(
                    value = "INVOKE",
                    target = "Lnet/minecraft/world/level/chunk/storage/RegionFileStorage;scanChunk(Lnet/minecraft/world/level/ChunkPos;Lnet/minecraft/nbt/StreamTagVisitor;)V"
            )
    )
    private void cesium$scanChunk(class_2867 instance, class_1923 chunkPos, class_6836 streamTagVisitor) throws IOException {
        if (this.isCesium) {
            this.database
                    .getDatabase(this.databaseSpec)
                    .scan(chunkPos, streamTagVisitor);
        } else {
            instance.method_39802(chunkPos, streamTagVisitor);
        }
    }

    /**
     * @author Yamayaki
     * @see class_4698#method_23698(boolean)
     */
    @Redirect(
            method = "method_27946",
            at = @At(
                    value = "INVOKE",
                    target = "Lnet/minecraft/world/level/chunk/storage/RegionFileStorage;flush()V"
            )
    )
    private void cesium$flush(class_2867 instance) throws IOException {
        if (!this.isCesium) {
            instance.method_26982();
        }
    }

    @Redirect(
            method = "runStore",
            at = @At(
                    value = "INVOKE",
                    target = "Lnet/minecraft/world/level/chunk/storage/RegionFileStorage;write(Lnet/minecraft/world/level/ChunkPos;Lnet/minecraft/nbt/CompoundTag;)V"
            )
    )
    private void cesium$write(class_2867 instance, class_1923 chunkPos, class_2487 compoundTag) throws IOException {
        if (this.isCesium) {
            this.database
                    .getTransaction(this.databaseSpec)
                    .add(chunkPos, compoundTag);
        } else {
            instance.method_23726(chunkPos, compoundTag);
        }
    }

    @Redirect(method = "close", at = @At(value = "INVOKE", target = "Lnet/minecraft/world/level/chunk/storage/RegionFileStorage;close()V"))
    private void cesium$close(class_2867 instance) throws IOException {
        if (!this.isCesium) {
            instance.close();
        }
    }

    public void cesium$flush() {
        this.database.flushChanges();
    }

    public void cesium$close() {
        this.database.close();
    }

    @Override
    public void cesium$setStorage(IDBInstance dbInstance) {
        this.isCesium = true;
        this.database = dbInstance;

        try {
            this.storage.close();
        } catch (IOException ignored) {
        }
    }

    @Override
    @SuppressWarnings("unchecked")
    public void cesium$setSpec(DatabaseSpec<?, ?> databaseSpec) {
        this.databaseSpec = (DatabaseSpec<class_1923, class_2487>) databaseSpec;
    }
}
