package de.yamayaki.cesium.mixin.core.storage;

import de.yamayaki.cesium.api.accessor.RawAccess;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import net.minecraft.class_1923;
import net.minecraft.class_2861;
import net.minecraft.class_2867;

@Mixin(class_2867.class)
public abstract class RegionFileStorageMixin implements RawAccess {
    @Shadow
    protected abstract class_2861 getRegionFile(class_1923 chunkPos) throws IOException;

    @Override
    public byte[] cesium$getBytes(final class_1923 chunkPos) throws IOException {
        final class_2861 regionFile = this.getRegionFile(chunkPos);

        try (final DataInputStream dos = regionFile.method_21873(chunkPos)) {
            if (dos == null) {
                return null;
            }

            return dos.readAllBytes();
        }
    }

    @Override
    public void cesium$putBytes(final class_1923 chunkPos, byte[] bytes) throws IOException {
        final class_2861 regionFile = this.getRegionFile(chunkPos);

        if (bytes == null) {
            regionFile.method_31740(chunkPos);
        } else {
            try (final DataOutputStream dos = regionFile.method_21881(chunkPos)) {
                dos.write(bytes);
            }
        }
    }
}
