package de.yamayaki.cesium.mixin.core.upgrader;

import com.llamalad7.mixinextras.sugar.Local;
import de.yamayaki.cesium.CesiumMod;
import de.yamayaki.cesium.api.accessor.DatabaseActions;
import de.yamayaki.cesium.api.accessor.DatabaseSetter;
import de.yamayaki.cesium.api.accessor.SpecificationSetter;
import de.yamayaki.cesium.api.database.DatabaseSpec;
import de.yamayaki.cesium.api.database.ICloseableIterator;
import de.yamayaki.cesium.api.database.IDBInstance;
import de.yamayaki.cesium.common.spec.WorldDatabaseSpecs;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.class_1257;
import net.minecraft.class_1923;
import net.minecraft.class_1937;
import net.minecraft.class_2487;
import net.minecraft.class_5321;
import net.minecraft.class_9240;

@Mixin(net.minecraft.class_1257.class_9161.class)
public abstract class MixinWorldUpgrader {
    @Shadow
    protected abstract boolean processOnePosition(class_5321<class_1937> resourceKey, AutoCloseable autoCloseable, class_1923 chunkPos);

    @Unique
    private IDBInstance tmpDatabase;

    @Unique
    private DatabaseSpec<class_1923, class_2487> tmpSpec;

    @Unique
    private double chunkCount = 0;

    @Redirect(
            method = "upgrade",
            at = @At(
                    value = "INVOKE",
                    target = "Ljava/lang/AutoCloseable;close()V"
            )
    )
    public void cesiumClose(AutoCloseable instance) throws Exception {
        if (instance instanceof DatabaseActions databaseActions) {
            databaseActions.cesium$close();
        }

        instance.close();
    }

    @Redirect(
            method = "upgrade",
            at = @At(
                    value = "INVOKE",
                    target = "Lnet/minecraft/util/worldupdate/WorldUpgrader$AbstractUpgrader;processOnePosition(Lnet/minecraft/resources/ResourceKey;Ljava/lang/AutoCloseable;Lnet/minecraft/world/level/ChunkPos;)Z"
            )
    )
    public boolean cesiumFlush(class_1257.class_9161<?> instance, class_5321<class_1937> resourceKey, AutoCloseable autoCloseable, class_1923 chunkPos) {
        if (chunkCount % 1024 == 0 && autoCloseable instanceof DatabaseActions databaseActions) {
            databaseActions.cesium$flush();
        }

        chunkCount++;

        return this.processOnePosition(resourceKey, autoCloseable, chunkPos);
    }


    @Inject(
            method = "getDimensionsToUpgrade",
            at = @At(
                    value = "INVOKE",
                    target = "Lnet/minecraft/util/worldupdate/WorldUpgrader$AbstractUpgrader;getFilesToProcess(Lnet/minecraft/world/level/chunk/storage/RegionStorageInfo;Ljava/nio/file/Path;)Ljava/util/ListIterator;",
                    shift = At.Shift.BY
            )
    )
    public <T extends AutoCloseable> void cesiumCreate(CallbackInfoReturnable<List<class_1257.class_9163<T>>> cir, @Local Path path, @Local class_9240 regionStorageInfo, @Local AutoCloseable autoCloseable) {
        IDBInstance dbInstance = CesiumMod.openWorldDB(path.getParent());
        tmpDatabase = dbInstance;

        DatabaseSpec<class_1923, class_2487> databaseSpec = switch (regionStorageInfo.comp_2347()) {
            case "entities" -> WorldDatabaseSpecs.ENTITY;
            case "poi" -> WorldDatabaseSpecs.POI;
            case "chunk" -> WorldDatabaseSpecs.CHUNK_DATA;
            default -> throw new IllegalStateException("Unexpected value: " + regionStorageInfo.comp_2347());
        };
        tmpSpec = databaseSpec;

        ((DatabaseSetter) autoCloseable).cesium$setStorage(dbInstance);
        if (autoCloseable instanceof SpecificationSetter) {
            ((SpecificationSetter) autoCloseable).cesium$setSpec(databaseSpec);
        }
    }

    @Redirect(method = "getFilesToProcess", at = @At(value = "INVOKE", target = "Lnet/minecraft/util/worldupdate/WorldUpgrader$AbstractUpgrader;getAllChunkPositions(Lnet/minecraft/world/level/chunk/storage/RegionStorageInfo;Ljava/nio/file/Path;)Ljava/util/List;"))
    public List<class_1257.class_9165> cesiumGetChunks(class_9240 regionStorageInfo, Path path) {
        final Map<String, List<class_1923>> regionList = new HashMap<>();

        try (final ICloseableIterator<class_1923> crs = tmpDatabase.getDatabase(tmpSpec).getIterator()) {
            while (crs.hasNext()) {
                final class_1923 chunkPos = crs.next();
                final String regionKey = chunkPos.method_17885() + "." + chunkPos.method_17886();

                if (!regionList.containsKey(regionKey)) {
                    regionList.put(regionKey, new ArrayList<>());
                }

                regionList.get(regionKey).add(chunkPos);
            }
        } catch (final Throwable t) {
            throw new RuntimeException("Could not iterate on cursor.", t);
        }

        tmpDatabase = null;
        tmpSpec = null;

        return regionList.values().stream().map(list -> new class_1257.class_9165(null, list)).toList();
    }
}
