package de.yamayaki.cesium.mixin.gui;

import de.yamayaki.cesium.api.accessor.DatabaseSource;
import org.lmdbjava.Stat;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;

import java.util.List;
import net.minecraft.class_11631;
import net.minecraft.class_2960;
import net.minecraft.class_3218;

@Mixin(class_11631.class)
public class MixinDebugScreenEntries {
    @Unique
    private static final class_2960 CESIUM_STATS = class_11631.method_72763(class_2960.method_60655("cesium", "lmdb_stats"), (debugScreenDisplayer, level, levelChunk, levelChunk2) -> {
        if(!(level instanceof class_3218 serverLevel)) {
            return;
        }

        final List<Stat> stats = ((DatabaseSource) serverLevel)
                .cesium$getStorage()
                .getStats();

        final int ms_depth = stats.stream().mapToInt(es -> es.depth).max().orElse(0);
        final long ms_branch_pages = stats.stream().mapToLong(es -> es.branchPages).sum();
        final long ms_leaf_pages = stats.stream().mapToLong(es -> es.leafPages).sum();
        final long ms_entries = stats.stream().mapToLong(es -> es.entries).sum();

        debugScreenDisplayer.method_72747("ms_depth: " + ms_depth);
        debugScreenDisplayer.method_72747("ms_branch_pages: " + ms_branch_pages);
        debugScreenDisplayer.method_72747("ms_leaf_pages: " + ms_leaf_pages);
        debugScreenDisplayer.method_72747("ms_entries: " + ms_entries);
    });
}
