/*
 * Decompiled with CFR 0.152.
 */
package de.yamayaki.cesium;

import com.mojang.logging.LogUtils;
import de.yamayaki.cesium.CesiumConfig;
import de.yamayaki.cesium.FileHelper;
import de.yamayaki.cesium.api.database.DatabaseSpec;
import de.yamayaki.cesium.api.database.IDBInstance;
import de.yamayaki.cesium.common.lmdb.LMDBInstance;
import de.yamayaki.cesium.common.spec.PlayerDatabaseSpecs;
import de.yamayaki.cesium.common.spec.WorldDatabaseSpecs;
import java.nio.file.Path;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.loader.api.FabricLoader;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.spongepowered.asm.mixin.MixinEnvironment;

public class CesiumMod
implements ModInitializer {
    private static final DatabaseSpec<?, ?>[] worldSpecs = new DatabaseSpec[]{WorldDatabaseSpecs.CHUNK_DATA, WorldDatabaseSpecs.POI, WorldDatabaseSpecs.ENTITY};
    private static final DatabaseSpec<?, ?>[] playerSpecs = new DatabaseSpec[]{PlayerDatabaseSpecs.PLAYER_DATA, PlayerDatabaseSpecs.ADVANCEMENTS, PlayerDatabaseSpecs.STATISTICS};
    private static Logger cesiumLogger;
    private static CesiumConfig cesiumConfig;

    public void onInitialize() {
        Path configPath = FabricLoader.getInstance().getConfigDir().resolve("cesium.json");
        cesiumLogger = LogUtils.getLogger();
        cesiumConfig = new CesiumConfig.Loader(configPath).get();
        if (FabricLoader.getInstance().isDevelopmentEnvironment()) {
            MixinEnvironment.getCurrentEnvironment().audit();
        }
    }

    @NotNull
    public static IDBInstance openWorldDB(@NotNull Path dimensionPath) {
        return CesiumMod.openDB(dimensionPath, "chunks", worldSpecs);
    }

    @NotNull
    public static IDBInstance openPlayerDB(@NotNull Path worldPath) {
        return CesiumMod.openDB(worldPath, "players", playerSpecs);
    }

    @NotNull
    private static IDBInstance openDB(@NotNull Path dbBasePath, @NotNull String dbName, @NotNull DatabaseSpec<?, ?>[] dbSpecs) {
        FileHelper.ensureDirectory(dbBasePath);
        return new LMDBInstance(dbBasePath.resolve(dbName + CesiumMod.getFileEnding()), dbSpecs, cesiumLogger, CesiumMod.config());
    }

    public static CesiumConfig config() {
        if (cesiumConfig == null) {
            throw new RuntimeException("Config is not yet available, did you do something silly?");
        }
        return cesiumConfig;
    }

    public static String getFileEnding() {
        return CesiumMod.config().isUncompressed() ? ".uncompressed.db" : ".db";
    }
}

