/*
 * Decompiled with CFR 0.152.
 */
package de.yamayaki.cesium.common.lmdb;

import de.yamayaki.cesium.api.database.IKVTransaction;
import de.yamayaki.cesium.common.lmdb.KVDatabase;
import it.unimi.dsi.fastutil.objects.Object2ReferenceMap;
import it.unimi.dsi.fastutil.objects.Object2ReferenceOpenHashMap;
import java.io.IOException;
import org.lmdbjava.Txn;

public class KVTransaction<K, V>
implements IKVTransaction<K, V> {
    private final KVDatabase<K, V> storage;
    private final Object2ReferenceMap<K, byte[]> pending = new Object2ReferenceOpenHashMap();
    private final Object2ReferenceMap<K, byte[]> snapshot = new Object2ReferenceOpenHashMap();

    public KVTransaction(KVDatabase<K, V> storage) {
        this.storage = storage;
    }

    @Override
    public void add(K key, V value) {
        try {
            byte[] data = null;
            if (value != null) {
                data = this.storage.getValueSerializer().serialize(value);
            }
            this.addBytes(key, data);
        }
        catch (IOException e) {
            throw new RuntimeException("Couldn't serialize value", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addBytes(K key, byte[] value) {
        byte[] data = null;
        if (value != null) {
            data = this.storage.getCompressor().compress(value);
        }
        Object2ReferenceMap<K, byte[]> object2ReferenceMap = this.pending;
        synchronized (object2ReferenceMap) {
            this.pending.put(key, (Object)data);
        }
        this.storage.setDirty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void createSnapshot() {
        Object2ReferenceMap<K, byte[]> object2ReferenceMap = this.pending;
        synchronized (object2ReferenceMap) {
            this.snapshot.putAll(this.pending);
            this.pending.clear();
        }
    }

    void addChanges(Txn<byte[]> txn) {
        for (Object2ReferenceMap.Entry entry : this.snapshot.object2ReferenceEntrySet()) {
            if (entry.getValue() != null) {
                this.storage.putValue(txn, entry.getKey(), (byte[])entry.getValue());
                continue;
            }
            this.storage.delete(txn, entry.getKey());
        }
    }

    void clearSnapshot() {
        this.snapshot.clear();
    }
}

