/*
 * Decompiled with CFR 0.152.
 */
package de.yamayaki.cesium.common.lmdb;

import de.yamayaki.cesium.CesiumConfig;
import de.yamayaki.cesium.api.database.DatabaseSpec;
import de.yamayaki.cesium.api.database.IDBInstance;
import de.yamayaki.cesium.api.database.IKVDatabase;
import de.yamayaki.cesium.api.database.IKVTransaction;
import de.yamayaki.cesium.common.lmdb.KVDatabase;
import de.yamayaki.cesium.common.lmdb.KVTransaction;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import it.unimi.dsi.fastutil.objects.Reference2ObjectMap;
import it.unimi.dsi.fastutil.objects.Reference2ObjectOpenHashMap;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.lmdbjava.BufferProxy;
import org.lmdbjava.ByteArrayProxy;
import org.lmdbjava.CopyFlags;
import org.lmdbjava.Env;
import org.lmdbjava.EnvFlags;
import org.lmdbjava.EnvInfo;
import org.lmdbjava.LmdbException;
import org.lmdbjava.Stat;
import org.lmdbjava.Txn;
import org.slf4j.Logger;

public class LMDBInstance
implements IDBInstance {
    private final Reference2ObjectMap<DatabaseSpec<?, ?>, KVDatabase<?, ?>> databases = new Reference2ObjectOpenHashMap();
    private final Reference2ObjectMap<DatabaseSpec<?, ?>, KVTransaction<?, ?>> transactions = new Reference2ObjectOpenHashMap();
    private final ReentrantReadWriteLock lock = new ReentrantReadWriteLock();
    protected final Logger logger;
    protected final boolean logsMapGrows;
    protected final Env<byte[]> env;
    protected final int MAX_COMMIT_TRIES = 3;
    protected final int resizeStep;
    protected volatile boolean isDirty = false;

    public LMDBInstance(Path databasePath, DatabaseSpec<?, ?>[] databases, Logger logger, CesiumConfig config) {
        this.logger = logger;
        this.logsMapGrows = config.logMapGrows();
        this.env = Env.create((BufferProxy)ByteArrayProxy.PROXY_BA).setMaxDbs(databases.length).open(databasePath.toFile(), new EnvFlags[]{EnvFlags.MDB_NOLOCK, EnvFlags.MDB_NOSUBDIR});
        this.resizeStep = Arrays.stream(databases).mapToInt(DatabaseSpec::getInitialSize).sum();
        EnvInfo info = this.env.info();
        if (info.mapSize < (long)this.resizeStep) {
            this.env.setMapSize((long)this.resizeStep);
        }
        for (DatabaseSpec<?, ?> spec : databases) {
            KVDatabase database = new KVDatabase(this, spec, !config.isUncompressed());
            this.databases.put(spec, database);
            this.transactions.put(spec, new KVTransaction(database));
        }
    }

    @Override
    public <K, V> IKVDatabase<K, V> getDatabase(DatabaseSpec<K, V> spec) {
        KVDatabase database = (KVDatabase)this.databases.get(spec);
        if (database == null) {
            throw new NullPointerException("No database is registered for spec " + String.valueOf(spec));
        }
        return database;
    }

    @Override
    public <K, V> IKVTransaction<K, V> getTransaction(DatabaseSpec<K, V> spec) {
        KVTransaction transaction = (KVTransaction)this.transactions.get(spec);
        if (transaction == null) {
            throw new NullPointerException("No transaction is registered for spec " + String.valueOf(spec));
        }
        return transaction;
    }

    @Override
    public void flushChanges() {
        if (!this.isDirty) {
            return;
        }
        this.lock.writeLock().lock();
        try {
            this.commitTransaction();
            this.isDirty = false;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    private void commitTransaction() {
        this.snapshotCreate();
        for (int tries = 1; tries < 4; ++tries) {
            try (Txn<?> txn = this.prepareTransaction();){
                txn.commit();
                break;
            }
            catch (LmdbException l) {
                if (l instanceof Env.MapFullException) {
                    this.growMap();
                    --tries;
                    continue;
                }
                this.logger.info("Commit of transaction failed; trying again ({}/{}): {}", new Object[]{tries, this.MAX_COMMIT_TRIES, l.getMessage()});
                if (tries != 3) continue;
                throw new RuntimeException("Could not commit transactions!");
            }
        }
        this.snapshotClear();
    }

    private Txn<?> prepareTransaction() throws LmdbException {
        ObjectIterator it = this.transactions.values().iterator();
        Txn txn = this.env.txnWrite();
        try {
            while (it.hasNext()) {
                KVTransaction transaction = (KVTransaction)it.next();
                transaction.addChanges((Txn<byte[]>)txn);
            }
        }
        catch (LmdbException l) {
            txn.abort();
            throw l;
        }
        return txn;
    }

    private void snapshotCreate() {
        for (KVTransaction txn : this.transactions.values()) {
            txn.createSnapshot();
        }
    }

    private void snapshotClear() {
        for (KVTransaction txn : this.transactions.values()) {
            txn.clearSnapshot();
        }
    }

    private void growMap() {
        EnvInfo info = this.env.info();
        long oldSize = info.mapSize;
        long newSize = oldSize + (long)this.resizeStep;
        this.env.setMapSize(newSize);
        if (this.logsMapGrows) {
            this.logger.info("Grew map size from {} to {} MB", (Object)(oldSize / 1024L / 1024L), (Object)(newSize / 1024L / 1024L));
        }
    }

    @Override
    public void createCopy(Path path) {
        this.lock.writeLock().lock();
        try {
            this.env.copy(path.toFile(), new CopyFlags[]{CopyFlags.MDB_CP_COMPACT});
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    @Override
    public List<Stat> getStats() {
        this.lock.readLock().lock();
        try {
            List<Stat> list = this.databases.values().stream().map(KVDatabase::getStats).toList();
            return list;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    @Override
    public ReentrantReadWriteLock getLock() {
        return this.lock;
    }

    @Override
    public boolean closed() {
        return this.env.isClosed();
    }

    @Override
    public void close() {
        this.flushChanges();
        for (KVDatabase database : this.databases.values()) {
            database.close();
        }
        this.env.close();
    }
}

