/*
 * Decompiled with CFR 0.152.
 */
package de.yamayaki.cesium.common.serializer;

import de.yamayaki.cesium.api.io.ISerializer;
import java.util.UUID;

public class UUIDSerializer
implements ISerializer<UUID> {
    @Override
    public byte[] serialize(UUID input) {
        byte[] array = new byte[16];
        long least = input.getLeastSignificantBits();
        for (int i = 7; i >= 0; --i) {
            array[i] = (byte)(least & 0xFFL);
            least >>= 8;
        }
        long most = input.getMostSignificantBits();
        for (int i = 15; i >= 8; --i) {
            array[i] = (byte)(most & 0xFFL);
            most >>= 8;
        }
        return array;
    }

    @Override
    public UUID deserialize(byte[] input) {
        long least = ((long)input[0] & 0xFFL) << 56 | ((long)input[1] & 0xFFL) << 48 | ((long)input[2] & 0xFFL) << 40 | ((long)input[3] & 0xFFL) << 32 | ((long)input[4] & 0xFFL) << 24 | ((long)input[5] & 0xFFL) << 16 | ((long)input[6] & 0xFFL) << 8 | (long)input[7] & 0xFFL;
        long most = ((long)input[8] & 0xFFL) << 56 | ((long)input[9] & 0xFFL) << 48 | ((long)input[10] & 0xFFL) << 40 | ((long)input[11] & 0xFFL) << 32 | ((long)input[12] & 0xFFL) << 24 | ((long)input[13] & 0xFFL) << 16 | ((long)input[14] & 0xFFL) << 8 | (long)input[15] & 0xFFL;
        return new UUID(most, least);
    }
}

