/*
 * Decompiled with CFR 0.152.
 */
package de.yamayaki.cesium.common.zstd;

import com.github.luben.zstd.Zstd;
import com.github.luben.zstd.ZstdCompressCtx;
import com.github.luben.zstd.ZstdDecompressCtx;
import de.yamayaki.cesium.CesiumMod;
import de.yamayaki.cesium.api.io.ICompressor;
import de.yamayaki.cesium.common.zstd.ZSTDContext;
import de.yamayaki.cesium.common.zstd.ZSTDDictionary;
import java.util.Arrays;

public class ZSTDCompressor
implements ICompressor {
    private static final int compressionLevel = CesiumMod.config().compressionLevel();
    private static final boolean usesDictionary = CesiumMod.config().useDictionary();
    private final ZSTDDictionary dictionary = new ZSTDDictionary(compressionLevel);
    private final ThreadLocal<ZSTDContext> ctx = ThreadLocal.withInitial(this::createContext);

    private ZSTDContext createContext() {
        return new ZSTDContext(usesDictionary, compressionLevel, this.dictionary);
    }

    private static long checkError(long rc) {
        if (Zstd.isError((long)rc)) {
            throw new IllegalStateException(Zstd.getErrorName((long)rc));
        }
        return rc;
    }

    @Override
    public byte[] compress(byte[] input) {
        byte[] dst = new byte[(int)Zstd.compressBound((long)input.length)];
        ZstdCompressCtx ctx = this.ctx.get().compress();
        int size = (int)ZSTDCompressor.checkError(ctx.compress(dst, input));
        return Arrays.copyOfRange(dst, 0, size);
    }

    @Override
    public byte[] decompress(byte[] input) {
        byte[] dst = new byte[(int)ZSTDCompressor.checkError(Zstd.getFrameContentSize((byte[])input))];
        long dictId = Zstd.getDictIdFromFrame((byte[])input);
        ZstdDecompressCtx ctx = this.ctx.get().decompress(dictId);
        ZSTDCompressor.checkError(ctx.decompress(dst, input));
        return dst;
    }
}

