/*
 * Decompiled with CFR 0.152.
 */
package de.yamayaki.cesium.common.zstd;

import com.github.luben.zstd.ZstdCompressCtx;
import com.github.luben.zstd.ZstdDecompressCtx;
import de.yamayaki.cesium.common.zstd.ZSTDDictionary;
import it.unimi.dsi.fastutil.longs.Long2ObjectArrayMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import org.jetbrains.annotations.NotNull;

public class ZSTDContext {
    private final ThreadLocal<ZstdCompressCtx> compressCtx = ThreadLocal.withInitial(this::compressCtx);
    private final ThreadLocal<Long2ObjectMap<ZstdDecompressCtx>> decompressCtx = ThreadLocal.withInitial(this::decompressCtx);
    private final boolean usesDictionary;
    private final int compressionLevel;
    private final ZSTDDictionary dictionary;

    public ZSTDContext(boolean usesDictionary, int compressionLevel, ZSTDDictionary dictionary) {
        this.usesDictionary = usesDictionary;
        this.compressionLevel = compressionLevel;
        this.dictionary = dictionary;
    }

    private ZstdCompressCtx compressCtx() {
        ZstdCompressCtx ctx = new ZstdCompressCtx();
        ctx.setLevel(this.compressionLevel);
        if (this.usesDictionary) {
            ctx.loadDict(this.dictionary.compressDictionary());
        }
        return ctx;
    }

    private Long2ObjectMap<ZstdDecompressCtx> decompressCtx() {
        Long2ObjectArrayMap map = new Long2ObjectArrayMap();
        for (long dictId : this.dictionary.dictionaries()) {
            ZstdDecompressCtx ctx = new ZstdDecompressCtx();
            ctx.loadDict(this.dictionary.decompressDictionary(dictId));
            map.put(dictId, (Object)ctx);
        }
        map.put(0L, (Object)new ZstdDecompressCtx());
        return map;
    }

    public ZstdCompressCtx compress() {
        return this.compressCtx.get();
    }

    @NotNull
    public ZstdDecompressCtx decompress(long dictId) {
        Long2ObjectMap<ZstdDecompressCtx> map = this.decompressCtx.get();
        ZstdDecompressCtx ctx = (ZstdDecompressCtx)map.get(dictId);
        if (ctx == null) {
            throw new RuntimeException("Could not find context for dictionary with id " + dictId);
        }
        return ctx;
    }
}

