/*
 * Decompiled with CFR 0.152.
 */
package de.yamayaki.cesium.common.zstd;

import com.github.luben.zstd.Zstd;
import com.github.luben.zstd.ZstdDictCompress;
import com.github.luben.zstd.ZstdDictDecompress;
import de.yamayaki.cesium.CesiumMod;
import it.unimi.dsi.fastutil.longs.Long2ObjectArrayMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import java.io.IOException;
import java.io.InputStream;

public class ZSTDDictionary
implements AutoCloseable {
    private static final String[] DICTIONARIES = new String[]{"1", "2"};
    private final long dictionaryToUse;
    private final Long2ObjectMap<ZstdDictCompress> compressMap = new Long2ObjectArrayMap();
    private final Long2ObjectMap<ZstdDictDecompress> decompressMap = new Long2ObjectArrayMap();

    public ZSTDDictionary(int compressionLevel) {
        this.dictionaryToUse = this.loadDictionaries(compressionLevel);
    }

    private long loadDictionaries(int compressionLevel) {
        long dictionaryId = -1L;
        for (String dictionary : DICTIONARIES) {
            dictionaryId = this.loadDictionary(dictionary, compressionLevel);
        }
        return dictionaryId;
    }

    private long loadDictionary(String name, int compressionLevel) {
        try {
            byte[] dictionary = this.loadFromResources(name);
            long dictionaryId = Zstd.getDictIdFromDict((byte[])dictionary);
            ZstdDictCompress dictCompress = new ZstdDictCompress(dictionary, compressionLevel);
            ZstdDictDecompress dictDecompress = new ZstdDictDecompress(dictionary);
            this.compressMap.put(dictionaryId, (Object)dictCompress);
            this.decompressMap.put(dictionaryId, (Object)dictDecompress);
            return dictionaryId;
        }
        catch (Throwable t) {
            throw new RuntimeException("Could not load dictionaries", t);
        }
    }

    private byte[] loadFromResources(String name) throws IOException {
        try (InputStream inputStream = CesiumMod.class.getResourceAsStream("/dictionaries/" + name + ".zstd.dict");){
            if (inputStream == null) {
                throw new IOException("Dictionary file not available: " + name);
            }
            byte[] byArray = inputStream.readAllBytes();
            return byArray;
        }
    }

    public long[] dictionaries() {
        return this.compressMap.keySet().toLongArray();
    }

    public ZstdDictCompress compressDictionary() {
        return (ZstdDictCompress)this.compressMap.get(this.dictionaryToUse);
    }

    public ZstdDictDecompress decompressDictionary(long id) {
        ZstdDictDecompress dictionary = (ZstdDictDecompress)this.decompressMap.get(id);
        if (dictionary == null) {
            throw new RuntimeException("Could not find dictionary with id " + id);
        }
        return dictionary;
    }

    @Override
    public void close() throws Exception {
        for (ZstdDictCompress value : this.compressMap.values()) {
            value.close();
        }
        this.compressMap.clear();
        for (ZstdDictCompress value : this.decompressMap.values()) {
            value.close();
        }
        this.decompressMap.clear();
    }
}

