/*
 * Decompiled with CFR 0.152.
 */
package de.yamayaki.cesium.maintenance.storage.anvil;

import com.google.common.collect.ImmutableList;
import de.yamayaki.cesium.api.accessor.RawAccess;
import de.yamayaki.cesium.maintenance.storage.IChunkStorage;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.class_1923;
import net.minecraft.class_2867;
import net.minecraft.class_9240;
import org.slf4j.Logger;

public class AnvilChunkStorage
implements IChunkStorage {
    private static final Pattern REGEX = Pattern.compile("^r\\.(-?[0-9]+)\\.(-?[0-9]+)\\.mca$");
    private final Logger logger;
    private final Path basePath;
    private final class_2867 chunkData;
    private final class_2867 poiData;
    private final class_2867 entityData;

    public AnvilChunkStorage(Logger logger, Path basePath) {
        this.logger = logger;
        this.basePath = basePath;
        this.chunkData = new class_2867(new class_9240("cesium", null, "region"), basePath.resolve("region"), false);
        this.poiData = new class_2867(new class_9240("cesium", null, "poi"), basePath.resolve("poi"), false);
        this.entityData = new class_2867(new class_9240("cesium", null, "entities"), basePath.resolve("entities"), false);
    }

    @Override
    public List<class_1923> getAllChunks() {
        File regionsFolder = new File(this.basePath.toFile(), "region");
        File[] files = regionsFolder.listFiles((filex, string) -> string.endsWith(".mca"));
        if (files == null) {
            return ImmutableList.of();
        }
        ArrayList<class_1923> list = new ArrayList<class_1923>();
        for (File region : files) {
            Matcher matcher = REGEX.matcher(region.getName());
            if (!matcher.matches()) continue;
            int regionX = Integer.parseInt(matcher.group(1)) << 5;
            int regionZ = Integer.parseInt(matcher.group(2)) << 5;
            for (int chunkX = 0; chunkX < 32; ++chunkX) {
                for (int chunkY = 0; chunkY < 32; ++chunkY) {
                    list.add(new class_1923(chunkX + regionX, chunkY + regionZ));
                }
            }
        }
        return list;
    }

    @Override
    public void flush() {
        try {
            this.chunkData.method_26982();
            this.poiData.method_26982();
            this.chunkData.method_26982();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void close() {
        this.flush();
        try {
            this.chunkData.close();
            this.poiData.close();
            this.entityData.close();
        }
        catch (IOException exception) {
            this.logger.error("[ANVIL] Failed to close chunk storage", (Throwable)exception);
        }
    }

    @Override
    public synchronized void setChunkData(class_1923 chunkPos, byte[] bytes) {
        try {
            ((RawAccess)this.chunkData).cesium$putBytes(chunkPos, bytes);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public synchronized byte[] getChunkData(class_1923 chunkPos) {
        try {
            return ((RawAccess)this.chunkData).cesium$getBytes(chunkPos);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public synchronized void setPOIData(class_1923 chunkPos, byte[] bytes) {
        try {
            ((RawAccess)this.poiData).cesium$putBytes(chunkPos, bytes);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public synchronized byte[] getPOIData(class_1923 chunkPos) {
        try {
            return ((RawAccess)this.poiData).cesium$getBytes(chunkPos);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public synchronized void setEntityData(class_1923 chunkPos, byte[] bytes) {
        try {
            ((RawAccess)this.entityData).cesium$putBytes(chunkPos, bytes);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public synchronized byte[] getEntityData(class_1923 chunkPos) {
        try {
            return ((RawAccess)this.entityData).cesium$getBytes(chunkPos);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

