/*
 * Decompiled with CFR 0.152.
 */
package de.yamayaki.cesium.maintenance.storage.anvil;

import de.yamayaki.cesium.FileHelper;
import de.yamayaki.cesium.maintenance.storage.IPlayerStorage;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import net.minecraft.class_2487;
import net.minecraft.class_2505;
import net.minecraft.class_2507;
import org.slf4j.Logger;

public class AnvilPlayerStorage
implements IPlayerStorage {
    private final Logger logger;
    private final Path playerData;
    private final Path statsStorage;
    private final Path advancementsStorage;

    public AnvilPlayerStorage(Logger logger, Path basePath) {
        this.logger = logger;
        this.playerData = basePath.resolve("playerdata");
        this.statsStorage = basePath.resolve("stats");
        this.advancementsStorage = basePath.resolve("advancements");
    }

    @Override
    public List<UUID> getAllPlayers() {
        return FileHelper.resolveAllEnding(this.playerData, ".dat").stream().map(file -> {
            try {
                String fileName = file.getName();
                String uuid = fileName.substring(0, fileName.length() - 4);
                if (uuid.length() > 36 || uuid.length() < 32) {
                    this.logger.warn("Found non UUID player file in directory, ignoring ({})", (Object)file.getAbsolutePath());
                    return null;
                }
                return UUID.fromString(uuid);
            }
            catch (Throwable t) {
                this.logger.error("Could not resolve UUID from filename, aborting ({})", (Object)file.getAbsolutePath());
                throw t;
            }
        }).filter(Objects::nonNull).toList();
    }

    @Override
    public void close() {
    }

    @Override
    public void setPlayerNBT(UUID uuid, class_2487 compoundTag) {
        if (compoundTag == null) {
            return;
        }
        try {
            Path savePath = this.playerData.resolve(uuid.toString() + ".dat");
            if (!Files.isDirectory(savePath.getParent(), new LinkOption[0]) || !Files.isRegularFile(savePath, new LinkOption[0])) {
                Files.createDirectories(savePath.getParent(), new FileAttribute[0]);
                Files.createFile(savePath, new FileAttribute[0]);
            }
            class_2507.method_30614((class_2487)compoundTag, (Path)savePath);
        }
        catch (IOException exception) {
            this.logger.warn("[ANVIL] Failed to save player data for {}", (Object)uuid);
        }
    }

    @Override
    public class_2487 getPlayerNBT(UUID uuid) {
        class_2487 compoundTag = null;
        try {
            Path savePath = this.playerData.resolve(uuid.toString() + ".dat");
            if (Files.isRegularFile(savePath, new LinkOption[0])) {
                compoundTag = class_2507.method_30613((Path)savePath, (class_2505)class_2505.method_53898());
            }
        }
        catch (IOException exception) {
            this.logger.warn("[ANVIL] Failed to load player data for {}", (Object)uuid);
        }
        return compoundTag;
    }

    @Override
    public void setPlayerAdvancements(UUID uuid, String advancements) {
        try {
            Path savePath = this.advancementsStorage.resolve(uuid.toString() + ".json");
            Files.writeString(savePath, (CharSequence)advancements, StandardCharsets.UTF_8, new OpenOption[0]);
        }
        catch (IOException exception) {
            this.logger.warn("[ANVIL] Failed to set advancements for {}", (Object)uuid);
        }
    }

    @Override
    public String getPlayerAdvancements(UUID uuid) {
        String advancements = null;
        try {
            Path savePath = this.advancementsStorage.resolve(uuid.toString() + ".json");
            advancements = Files.readString(savePath, StandardCharsets.UTF_8);
        }
        catch (IOException exception) {
            this.logger.warn("[ANVIL] Failed to load advancements for {}", (Object)uuid);
        }
        return advancements;
    }

    @Override
    public void setPlayerStatistics(UUID uuid, String statistics) {
        try {
            Path savePath = this.statsStorage.resolve(uuid.toString() + ".json");
            Files.writeString(savePath, (CharSequence)statistics, StandardCharsets.UTF_8, new OpenOption[0]);
        }
        catch (IOException exception) {
            this.logger.warn("[ANVIL] Failed to save statistics for {}", (Object)uuid);
        }
    }

    @Override
    public String getPlayerStatistics(UUID uuid) {
        String statistics = null;
        try {
            Path savePath = this.statsStorage.resolve(uuid.toString() + ".json");
            statistics = Files.readString(savePath, StandardCharsets.UTF_8);
        }
        catch (IOException exception) {
            this.logger.warn("[ANVIL] Failed to load statistics for {}", (Object)uuid);
        }
        return statistics;
    }
}

