/*
 * Decompiled with CFR 0.152.
 */
package de.yamayaki.cesium.maintenance.storage.cesium;

import de.yamayaki.cesium.CesiumMod;
import de.yamayaki.cesium.api.database.ICloseableIterator;
import de.yamayaki.cesium.api.database.IDBInstance;
import de.yamayaki.cesium.common.spec.PlayerDatabaseSpecs;
import de.yamayaki.cesium.maintenance.storage.IPlayerStorage;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.minecraft.class_2487;
import org.lmdbjava.LmdbException;
import org.slf4j.Logger;

public class CesiumPlayerStorage
implements IPlayerStorage {
    private final Logger logger;
    private final IDBInstance database;

    public CesiumPlayerStorage(Logger logger, Path basePath) {
        this.logger = logger;
        this.database = CesiumMod.openPlayerDB(basePath);
    }

    @Override
    public List<UUID> getAllPlayers() {
        ArrayList<UUID> list = new ArrayList<UUID>();
        try (ICloseableIterator<UUID> crs = this.database.getDatabase(PlayerDatabaseSpecs.STATISTICS).getIterator();){
            while (crs.hasNext()) {
                list.add((UUID)crs.next());
            }
        }
        catch (Throwable t) {
            throw new RuntimeException("Could not iterate on cursor.", t);
        }
        return list;
    }

    @Override
    public void close() {
        try {
            this.database.flushChanges();
        }
        catch (LmdbException lmdbException) {
            this.logger.error("Failed to flush data", (Throwable)lmdbException);
        }
        this.database.close();
    }

    @Override
    public void setPlayerNBT(UUID uuid, class_2487 compoundTag) {
        this.database.getTransaction(PlayerDatabaseSpecs.PLAYER_DATA).add(uuid, compoundTag);
    }

    @Override
    public class_2487 getPlayerNBT(UUID uuid) {
        return this.database.getDatabase(PlayerDatabaseSpecs.PLAYER_DATA).getValue(uuid);
    }

    @Override
    public void setPlayerAdvancements(UUID uuid, String advancements) {
        this.database.getTransaction(PlayerDatabaseSpecs.ADVANCEMENTS).add(uuid, advancements);
    }

    @Override
    public String getPlayerAdvancements(UUID uuid) {
        return this.database.getDatabase(PlayerDatabaseSpecs.ADVANCEMENTS).getValue(uuid);
    }

    @Override
    public void setPlayerStatistics(UUID uuid, String statistics) {
        this.database.getTransaction(PlayerDatabaseSpecs.STATISTICS).add(uuid, statistics);
    }

    @Override
    public String getPlayerStatistics(UUID uuid) {
        return this.database.getDatabase(PlayerDatabaseSpecs.STATISTICS).getValue(uuid);
    }
}

