/*
 * Decompiled with CFR 0.152.
 */
package de.yamayaki.cesium.maintenance.tasks;

import de.yamayaki.cesium.maintenance.AbstractTask;
import de.yamayaki.cesium.maintenance.storage.IChunkStorage;
import de.yamayaki.cesium.maintenance.storage.IPlayerStorage;
import de.yamayaki.cesium.maintenance.storage.anvil.AnvilChunkStorage;
import de.yamayaki.cesium.maintenance.storage.anvil.AnvilPlayerStorage;
import de.yamayaki.cesium.maintenance.storage.cesium.CesiumChunkStorage;
import de.yamayaki.cesium.maintenance.storage.cesium.CesiumPlayerStorage;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import net.minecraft.class_156;
import net.minecraft.class_1923;
import net.minecraft.class_1937;
import net.minecraft.class_32;
import net.minecraft.class_5321;
import net.minecraft.class_5455;
import org.jetbrains.annotations.NotNull;

public class DatabaseConvert
extends AbstractTask {
    private final AbstractTask.Task task;

    public DatabaseConvert(AbstractTask.Task task, class_32.class_5143 levelStorageAccess, class_5455 registryAccess) {
        super("Convert", levelStorageAccess, registryAccess);
        this.task = task;
    }

    @Override
    protected void runTasks() {
        this.copyPlayerData();
        for (class_5321 levelResourceKey : this.levels) {
            this.copyLevelData((class_5321<class_1937>)levelResourceKey);
        }
        this.running.set(false);
    }

    private void copyPlayerData() {
        this.status.set("Copying player data \u2026");
        Path playerDataPath = this.levelAccess.method_27424(class_1937.field_25179);
        try (IPlayerStorage _old = this.pStorage(playerDataPath, true);
             IPlayerStorage _new = this.pStorage(playerDataPath, false);){
            List<UUID> playerList = _old.getAllPlayers();
            this.logger.info("Converting {} player profiles", (Object)playerList.size());
            Iterator<UUID> iterator = playerList.iterator();
            this.totalElements.set(playerList.size());
            this.currentElement.set(0);
            while (this.running.get() && iterator.hasNext()) {
                this.currentElement.incrementAndGet();
                DatabaseConvert.copyPlayer(iterator.next(), _old, _new);
            }
        }
        catch (Throwable t) {
            throw new RuntimeException("Could not copy all player data.", t);
        }
    }

    private static void copyPlayer(UUID uuid, IPlayerStorage _old, IPlayerStorage _new) {
        _new.setPlayerNBT(uuid, _old.getPlayerNBT(uuid));
        _new.setPlayerAdvancements(uuid, _old.getPlayerAdvancements(uuid));
        _new.setPlayerStatistics(uuid, _old.getPlayerStatistics(uuid));
    }

    private void copyLevelData(class_5321<class_1937> level) {
        this.status.set("Copying level data \u2026");
        this.currentLevel.set(level);
        Path dimensionPath = this.levelAccess.method_27424(level);
        try (IChunkStorage _old = this.cStorage(dimensionPath, true);
             IChunkStorage _new = this.cStorage(dimensionPath, false);){
            List<class_1923> chunkList = _old.getAllChunks();
            Iterator<class_1923> iterator = chunkList.iterator();
            this.totalElements.set(chunkList.size());
            this.currentElement.set(0);
            int taskCount = Math.min(Math.max(Runtime.getRuntime().availableProcessors() * 2, 8), 32);
            ArrayList<CompletableFuture<Void>> copyTasks = new ArrayList<CompletableFuture<Void>>(taskCount);
            while (this.running.get() && iterator.hasNext()) {
                int currentChunk = this.currentElement.incrementAndGet();
                copyTasks.add(this.copyChunkData(iterator.next(), _old, _new));
                if (currentChunk % taskCount != 0) continue;
                CompletableFuture.allOf((CompletableFuture[])copyTasks.toArray(CompletableFuture[]::new)).join();
                _new.flush();
                copyTasks.clear();
            }
            CompletableFuture.allOf((CompletableFuture[])copyTasks.toArray(CompletableFuture[]::new)).join();
        }
        catch (Throwable t) {
            throw new RuntimeException("Could not copy all level data.", t);
        }
    }

    private CompletableFuture<Void> copyChunkData(class_1923 chunkPos, IChunkStorage _old, IChunkStorage _new) {
        return CompletableFuture.runAsync(() -> {
            _new.setChunkData(chunkPos, _old.getChunkData(chunkPos));
            _new.setPOIData(chunkPos, _old.getPOIData(chunkPos));
            _new.setEntityData(chunkPos, _old.getEntityData(chunkPos));
        }, (Executor)class_156.method_18349()).exceptionally(throwable -> {
            this.logger.error("Could not copy chunk into new storage.", throwable);
            return null;
        });
    }

    @NotNull
    private IChunkStorage cStorage(Path path, boolean old) {
        if (!old) {
            return this.task == AbstractTask.Task.TO_ANVIL ? new AnvilChunkStorage(this.logger, path) : new CesiumChunkStorage(this.logger, path);
        }
        return this.task == AbstractTask.Task.TO_ANVIL ? new CesiumChunkStorage(this.logger, path) : new AnvilChunkStorage(this.logger, path);
    }

    @NotNull
    private IPlayerStorage pStorage(Path path, boolean old) {
        if (!old) {
            return this.task == AbstractTask.Task.TO_ANVIL ? new AnvilPlayerStorage(this.logger, path) : new CesiumPlayerStorage(this.logger, path);
        }
        return this.task == AbstractTask.Task.TO_ANVIL ? new CesiumPlayerStorage(this.logger, path) : new AnvilPlayerStorage(this.logger, path);
    }
}

