/*
 * Decompiled with CFR 0.152.
 */
package de.yamayaki.cesium.mixin.core.players;

import com.google.gson.JsonParseException;
import com.mojang.datafixers.DataFixer;
import de.yamayaki.cesium.api.accessor.DatabaseSetter;
import de.yamayaki.cesium.api.database.IDBInstance;
import de.yamayaki.cesium.common.spec.PlayerDatabaseSpecs;
import java.io.File;
import java.util.UUID;
import net.minecraft.class_3442;
import net.minecraft.class_3469;
import net.minecraft.server.MinecraftServer;
import org.slf4j.Logger;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Redirect;

@Mixin(value={class_3442.class})
public abstract class MixinServerStatsCounter
extends class_3469
implements DatabaseSetter {
    @Shadow
    @Final
    private static Logger field_15309;
    @Shadow
    @Final
    private File field_15305;
    @Shadow
    @Final
    private MinecraftServer field_15308;
    @Unique
    private IDBInstance database;

    @Shadow
    public abstract void method_14906(DataFixer var1, String var2);

    @Redirect(method={"<init>"}, at=@At(value="INVOKE", target="Ljava/io/File;isFile()Z"))
    public boolean killInitialLoad(File file) {
        return false;
    }

    @Unique
    private UUID getUuid() {
        return UUID.fromString(this.field_15305.getName().replace(".json", ""));
    }

    @Override
    public void cesium$setStorage(IDBInstance storage) {
        this.database = storage;
        String json = this.database.getDatabase(PlayerDatabaseSpecs.STATISTICS).getValue(this.getUuid());
        if (json == null) {
            return;
        }
        try {
            this.method_14906(this.field_15308.method_3855(), json);
        }
        catch (JsonParseException var5) {
            field_15309.error("Couldn't parse statistics for player {}", (Object)this.getUuid(), (Object)var5);
        }
        catch (Exception var4) {
            field_15309.error("Couldn't read statistics for player {}", (Object)this.getUuid(), (Object)var4);
        }
    }

    @Redirect(method={"save"}, at=@At(value="INVOKE", target="Lorg/apache/commons/io/FileUtils;writeStringToFile(Ljava/io/File;Ljava/lang/String;)V", remap=false))
    public void redirectWrite(File file, String data) {
        this.database.getTransaction(PlayerDatabaseSpecs.STATISTICS).add(this.getUuid(), data);
    }
}

