/*
 * Decompiled with CFR 0.152.
 */
package de.yamayaki.cesium.mixin.core.upgrader;

import com.llamalad7.mixinextras.sugar.Local;
import de.yamayaki.cesium.CesiumMod;
import de.yamayaki.cesium.api.accessor.DatabaseActions;
import de.yamayaki.cesium.api.accessor.DatabaseSetter;
import de.yamayaki.cesium.api.accessor.SpecificationSetter;
import de.yamayaki.cesium.api.database.DatabaseSpec;
import de.yamayaki.cesium.api.database.ICloseableIterator;
import de.yamayaki.cesium.api.database.IDBInstance;
import de.yamayaki.cesium.common.spec.WorldDatabaseSpecs;
import java.lang.invoke.CallSite;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import net.minecraft.class_1257;
import net.minecraft.class_1923;
import net.minecraft.class_1937;
import net.minecraft.class_2487;
import net.minecraft.class_5321;
import net.minecraft.class_9240;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={class_1257.class_9161.class})
public abstract class MixinWorldUpgrader {
    @Unique
    private IDBInstance tmpDatabase;
    @Unique
    private DatabaseSpec<class_1923, class_2487> tmpSpec;
    @Unique
    private double chunkCount = 0.0;

    @Shadow
    protected abstract boolean method_56538(class_5321<class_1937> var1, AutoCloseable var2, class_1923 var3);

    @Redirect(method={"upgrade"}, at=@At(value="INVOKE", target="Ljava/lang/AutoCloseable;close()V"))
    public void cesiumClose(AutoCloseable instance) throws Exception {
        if (instance instanceof DatabaseActions) {
            DatabaseActions databaseActions = (DatabaseActions)((Object)instance);
            databaseActions.cesium$close();
        }
        instance.close();
    }

    @Redirect(method={"upgrade"}, at=@At(value="INVOKE", target="Lnet/minecraft/util/worldupdate/WorldUpgrader$AbstractUpgrader;processOnePosition(Lnet/minecraft/resources/ResourceKey;Ljava/lang/AutoCloseable;Lnet/minecraft/world/level/ChunkPos;)Z"))
    public boolean cesiumFlush(class_1257.class_9161<?> instance, class_5321<class_1937> resourceKey, AutoCloseable autoCloseable, class_1923 chunkPos) {
        if (this.chunkCount % 1024.0 == 0.0 && autoCloseable instanceof DatabaseActions) {
            DatabaseActions databaseActions = (DatabaseActions)((Object)autoCloseable);
            databaseActions.cesium$flush();
        }
        this.chunkCount += 1.0;
        return this.method_56538(resourceKey, autoCloseable, chunkPos);
    }

    @Inject(method={"getDimensionsToUpgrade"}, at={@At(value="INVOKE", target="Lnet/minecraft/util/worldupdate/WorldUpgrader$AbstractUpgrader;getFilesToProcess(Lnet/minecraft/world/level/chunk/storage/RegionStorageInfo;Ljava/nio/file/Path;)Ljava/util/ListIterator;", shift=At.Shift.BY)})
    public <T extends AutoCloseable> void cesiumCreate(CallbackInfoReturnable<List<class_1257.class_9163<T>>> cir, @Local Path path, @Local class_9240 regionStorageInfo, @Local AutoCloseable autoCloseable) {
        IDBInstance dbInstance;
        this.tmpDatabase = dbInstance = CesiumMod.openWorldDB(path.getParent());
        DatabaseSpec<class_1923, class_2487> databaseSpec = switch (regionStorageInfo.comp_2347()) {
            case "entities" -> WorldDatabaseSpecs.ENTITY;
            case "poi" -> WorldDatabaseSpecs.POI;
            case "chunk" -> WorldDatabaseSpecs.CHUNK_DATA;
            default -> throw new IllegalStateException("Unexpected value: " + regionStorageInfo.comp_2347());
        };
        this.tmpSpec = databaseSpec;
        ((DatabaseSetter)((Object)autoCloseable)).cesium$setStorage(dbInstance);
        if (autoCloseable instanceof SpecificationSetter) {
            ((SpecificationSetter)((Object)autoCloseable)).cesium$setSpec(databaseSpec);
        }
    }

    @Redirect(method={"getFilesToProcess"}, at=@At(value="INVOKE", target="Lnet/minecraft/util/worldupdate/WorldUpgrader$AbstractUpgrader;getAllChunkPositions(Lnet/minecraft/world/level/chunk/storage/RegionStorageInfo;Ljava/nio/file/Path;)Ljava/util/List;"))
    public List<class_1257.class_9165> cesiumGetChunks(class_9240 regionStorageInfo, Path path) {
        HashMap regionList = new HashMap();
        try (ICloseableIterator<class_1923> crs = this.tmpDatabase.getDatabase(this.tmpSpec).getIterator();){
            while (crs.hasNext()) {
                class_1923 chunkPos = (class_1923)crs.next();
                String regionKey = chunkPos.method_17885() + "." + chunkPos.method_17886();
                if (!regionList.containsKey(regionKey)) {
                    regionList.put((CallSite)((Object)regionKey), new ArrayList());
                }
                ((List)regionList.get(regionKey)).add(chunkPos);
            }
        }
        catch (Throwable t) {
            throw new RuntimeException("Could not iterate on cursor.", t);
        }
        this.tmpDatabase = null;
        this.tmpSpec = null;
        return regionList.values().stream().map(list -> new class_1257.class_9165(null, list)).toList();
    }
}

