package de.yamayaki.cesium.maintenance;

import com.mojang.logging.LogUtils;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;

import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import net.minecraft.class_1937;
import net.minecraft.class_32;
import net.minecraft.class_5321;
import net.minecraft.class_5455;
import net.minecraft.class_7924;

public abstract class AbstractTask {
    protected final Logger logger = LogUtils.getLogger();

    protected final class_32.class_5143 levelAccess;
    protected final List<class_5321<class_1937>> levels;

    protected final Thread workerThread;
    protected final AtomicBoolean running = new AtomicBoolean(true);

    protected final AtomicReference<String> status = new AtomicReference<>();

    protected final AtomicInteger totalElements = new AtomicInteger(0);
    protected final AtomicInteger currentElement = new AtomicInteger(0);
    protected final AtomicReference<class_5321<class_1937>> currentLevel = new AtomicReference<>(null);

    public AbstractTask(final String task, final class_32.class_5143 levelAccess, final class_5455 registryAccess) {
        this.levelAccess = levelAccess;

        this.levels = registryAccess
                .method_30530(class_7924.field_41224)
                .method_42021()
                .stream().map(class_7924::method_47516)
                .toList();

        this.status.set("Loading required data into memory ...");

        this.workerThread = this.createWorkerThread(task);
        this.workerThread.start();
    }

    public @NotNull Thread createWorkerThread(final String task) {
        final Thread workerThread = new Thread(this::runTasks, "Cesium-" + task + "-Database");
        workerThread.setDaemon(true);
        workerThread.setUncaughtExceptionHandler((thread, throwable) -> {
            this.logger.error("Uncaught exception while {} world!", task, throwable);
            this.running.set(false);
        });

        return workerThread;
    }

    protected abstract void runTasks();

    public void cancelTask() {
        this.running.set(false);

        try {
            this.workerThread.join();
        } catch (InterruptedException ignored) {
        }
    }

    public boolean running() {
        return this.running.get();
    }

    public String levelName() {
        final class_5321<class_1937> curLevel = this.currentLevel.get();
        return curLevel == null ? "<unnamed>" : curLevel.toString();
    }

    public String status() {
        return this.status.get();
    }

    public int totalElements() {
        return this.totalElements.get();
    }

    public int currentElement() {
        return this.currentElement.get();
    }

    public double percentage() {
        return this.currentElement() / (double) Math.max(this.totalElements(), 1);
    }

    public Logger logger() {
        return this.logger;
    }

    public enum Task {
        TO_ANVIL,
        TO_CESIUM,
        COMPACT
    }
}
