package de.yamayaki.cesium.maintenance.screens;

import de.yamayaki.cesium.maintenance.AbstractTask;
import de.yamayaki.cesium.maintenance.tasks.DatabaseCompact;
import de.yamayaki.cesium.maintenance.tasks.DatabaseConvert;
import it.unimi.dsi.fastutil.booleans.BooleanConsumer;
import net.minecraft.class_2561;
import net.minecraft.class_32;
import net.minecraft.class_332;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_5244;
import net.minecraft.class_5455;
import net.minecraft.class_8012;

public class CesiumWorkScreen extends class_437 {
    private final BooleanConsumer callback;
    private final AbstractTask cesiumTask;

    public CesiumWorkScreen(AbstractTask.Task task, class_32.class_5143 levelAccess, class_5455 registryAccess, BooleanConsumer callback) {
        super(class_2561.method_43470("Working on Cesium task"));

        this.callback = callback;
        this.cesiumTask = switch (task) {
            case TO_ANVIL, TO_CESIUM -> new DatabaseConvert(task, levelAccess, registryAccess);
            case COMPACT -> new DatabaseCompact(levelAccess, registryAccess);
        };
    }

    @Override
    protected void method_25426() {
        super.method_25426();
        this.method_37063(class_4185.method_46430(class_5244.field_24335, button -> {
            this.cesiumTask.cancelTask();
            this.callback.accept(false);
        }).method_46434(this.field_22789 / 2 - 100, this.field_22790 / 4 + 150, 200, 20).method_46431());
    }

    @Override
    public void method_25393() {
        if (!this.cesiumTask.running()) {
            this.callback.accept(true);
        }
    }

    @Override
    public void method_25419() {
        this.callback.accept(false);
    }

    @Override
    public void method_25432() {
        this.cesiumTask.cancelTask();
    }

    @Override
    public void method_25394(class_332 guiGraphics, int i, int j, float f) {
        super.method_25394(guiGraphics, i, j, f);

        final int textColor = class_8012.field_42973;
        final int textOffset = 14;

        final int offsetX = this.field_22789 / 2;
        final int startX = offsetX - 150;
        final int endX = offsetX + 150;

        guiGraphics.method_27534(this.field_22793, this.field_22785, offsetX, 20, textColor);

        final class_2561[] drawables = new class_2561[]{
                class_2561.method_43470(String.format("Level: %s", this.cesiumTask.levelName())),
                class_2561.method_43470(String.format("Progress: %s / %s", this.cesiumTask.currentElement(), this.cesiumTask.totalElements()))
        };

        for (int index = 0; index < drawables.length; index++) {
            guiGraphics.method_27535(this.field_22793, drawables[index], startX, 40 + ((index + 1) * textOffset), textColor);
        }

        final int statusOffset = 40 + ((drawables.length + 2) * textOffset);
        guiGraphics.method_25300(this.field_22793, this.cesiumTask.status(), offsetX, statusOffset, textColor);

        final int progressOffset = statusOffset + textOffset;
        final int barEnd = (int) Math.floor(this.cesiumTask.percentage() * (endX - startX));

        guiGraphics.method_25294(startX - 1, progressOffset - 1, endX + 1, progressOffset + textOffset + 1, -16777216);
        guiGraphics.method_25294(startX, progressOffset, startX + barEnd, progressOffset + textOffset, -13408734);
    }
}
