package de.yamayaki.cesium.maintenance.tasks;

import de.yamayaki.cesium.CesiumMod;
import de.yamayaki.cesium.api.database.IDBInstance;
import de.yamayaki.cesium.maintenance.AbstractTask;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import net.minecraft.class_1937;
import net.minecraft.class_32;
import net.minecraft.class_5321;
import net.minecraft.class_5455;

public class DatabaseCompact extends AbstractTask {
    public DatabaseCompact(final class_32.class_5143 levelStorageAccess, final class_5455 registryAccess) {
        super("Compact", levelStorageAccess, registryAccess);
    }

    @Override
    protected void runTasks() {
        this.totalElements.set(this.levels.size());

        for (final class_5321<class_1937> levelResourceKey : this.levels) {
            this.currentElement.incrementAndGet();
            this.currentLevel.set(levelResourceKey);

            this.compactLevelDatabase(levelResourceKey);
        }

        this.running.set(false);
    }

    private void compactLevelDatabase(final class_5321<class_1937> level) {
        final Path dimensionPath = this.levelAccess.method_27424(level);

        final Path originalPath = dimensionPath.resolve("chunks" + CesiumMod.getFileEnding());
        final Path copyPath = dimensionPath.resolve("chunks.copy");

        final IDBInstance dbInstance = CesiumMod.openWorldDB(dimensionPath);

        this.status.set("Compacting level data for " + level.method_29177().method_12832());

        try {
            dbInstance.createCopy(copyPath);
            dbInstance.close();

            if (Files.isRegularFile(copyPath) && Files.isRegularFile(originalPath)) {
                Files.move(copyPath, originalPath, StandardCopyOption.ATOMIC_MOVE, StandardCopyOption.REPLACE_EXISTING);
            }
        } catch (final Throwable t) {
            throw new RuntimeException("Failed to compact level.", t);
        } finally {
            if (!dbInstance.closed()) {
                dbInstance.close();
            }
        }
    }
}
