package de.yamayaki.cesium.mixin.core.chunks;

import de.yamayaki.cesium.api.accessor.DatabaseActions;
import de.yamayaki.cesium.api.accessor.DatabaseSetter;
import de.yamayaki.cesium.api.accessor.SpecificationSetter;
import de.yamayaki.cesium.api.database.IDBInstance;
import de.yamayaki.cesium.common.spec.WorldDatabaseSpecs;
import net.minecraft.class_3977;
import net.minecraft.class_4698;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Mutable;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;

@Mixin(class_3977.class)
public class MixinChunkStorage implements DatabaseSetter, DatabaseActions {
    @Mutable
    @Shadow
    @Final
    private class_4698 worker;

    @Unique
    private IDBInstance database;

    @Override
    public void cesium$flush() {
        this.database.flushChanges();
    }

    @Override
    public void cesium$close() {
        this.database.close();
    }

    @Override
    public void cesium$setStorage(IDBInstance dbInstance) {
        this.database = dbInstance;

        ((DatabaseSetter) this.worker).cesium$setStorage(this.database);
        ((SpecificationSetter) this.worker).cesium$setSpec(WorldDatabaseSpecs.CHUNK_DATA);
    }
}
